-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local res = {}

for i = 1, 3 do
    local secboot = {}
    secboot['Name'] = ProcessingFlow[i].Destination.Name
    secboot['Signature'] = ProcessingFlow[i].Destination.Signature
    secboot['VerificationResult'] = ProcessingFlow[i].Destination.VerificationResult

    res[i] = secboot
end

-- 固件的 Version 需要从其它地方获取

-- UBOOT
res[1]['Version'] = string.format("%s(%s)", ProcessingFlow[4].Destination.Version,
    ProcessingFlow[4].Destination.ReleaseDate)
-- Rootfs
res[2]['Version'] = ProcessingFlow[5].Destination.Version
-- BIOS
res[3]['Version'] = string.format("%s(%s)", ProcessingFlow[6].Destination.Version,
    ProcessingFlow[6].Destination.Location)

return res