-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local cjson = require 'cjson'

local m = {}
local config = {
    MIN_ACCOUNT_ID = 2,      -- 最小用户ID
    MAX_ACCOUNT_ID = 21,     -- 最大用户ID
    REMOTE_ACCOUNT_ID = 1000 -- 远程用户起始ID
}

local function is_have_user_mgmt(privileges)
    for _, value in ipairs(privileges) do
        if value == 'UserMgmt' then
            return true
        end
    end
    return false
end

function m.get_rsp_body(session_id, privilege, username, expand_body_list)
    local body = cjson.json_object_is_array(expand_body_list) and cjson.json_object_to_table(expand_body_list) or {}
    local ret = {}
    for _, v in pairs(body) do
        if tonumber(v.UserID) < config.MIN_ACCOUNT_ID or
            (tonumber(v.UserID) > config.MAX_ACCOUNT_ID and tonumber(v.UserID) < config.REMOTE_ACCOUNT_ID) then
            goto continue
        end
        if is_have_user_mgmt(privilege) or username == v.UserName then
            v['MySession'] = v.SessionID == session_id and true or false
            ret[#ret + 1] = v
        end
        ::continue::
    end
    return ret
end

return m
