-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local systemid = Uri.systemid
local managerid = Uri.managerid
local log_format = managerid and 'EventLog' or Uri.logid:gsub('^%l', string.upper)
local sum = ProcessingFlow[1].Destination.CurEventCount
local skip = Query.Skip or 0
local top = Query.Top or (sum > 32 and 32 or sum)
local DEF_TOP = 32
local res = '/redfish/v1/%s/LogServices/%s/Entries?$skip=%s&$top=%s'

local id_format = systemid and 'Systems/' .. systemid or 'Managers/' .. managerid -- 判断manager/system资源

if sum >= (skip + top + DEF_TOP) then
    return string.format(res , id_format, log_format, skip + top, DEF_TOP)
elseif sum > (skip + top) then
    return string.format(res , id_format, log_format, skip + top, sum - skip - top)
else
    return
end