-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local firmware_list = ProcessingFlow[1].Destination.FirmwareInfoIntfs

local function search_id(id_table, firmware_type, id, board)
    -- 天工AI机型无挂耳,chassisBMC对象配置在扩展板上,需要单独判断
    if board.NodeId == 'chassisBMC' then
        -- PSR仅有SR需要升级,无其它固件
        if string.match(id, 'PSR') ~= nil then
            return board.NodeId .. 'PSR'
        end
        return
    end
    if board.Id == id_table[#id_table] and type(board.NodeId) == 'string' then
        if firmware_type == 'SR' then
            return board.NodeId .. 'HWSR'
        end
        if firmware_type == 'VRD' and board.Type == 'BCU' then
            --BCU的VRD不需要类型
            return string.match(board.NodeId, '(CpuBoard%d+)') .. 'VRD'
        end
        if firmware_type == 'CPLD' and id_table[2] == 'DPU' then
            return board.NodeId .. id_table[1]
        end
        if firmware_type == 'CPLD' and string.match(id_table[2], 'CPLD')  then
            return board.NodeId .. id_table[2]
        end
        if firmware_type == 'Retimer' and string.match(id_table[2], 'Retimer')  then
            return board.NodeId .. id_table[2]
        end
        return board.NodeId .. firmware_type
    end
end

local function get_firmwareid_via_uriid(id)
    if string.match(id, '_PSU%d+') then
        return 'chassis' .. string.match(id, 'PSU%d+')
    end

    if string.match(id, 'LinkBoard') then
        if string.match(id, 'Patch') then
            return 'LCN' .. string.match(id, 'LinkBoard%d+') .. string.match(id, 'Patch')
        end
        if string.match(id, 'Software') then
            return 'LCN' .. string.match(id, 'LinkBoard%d+') .. string.match(id, 'Software')
        end
    end

    local id_table = {} -- 资源树id格式末尾为_position
    for w in string.gmatch(id, '[^_]+') do
        table.insert(id_table, w)
    end

    local firmware_types = {
        'FPGA',
        'CPLD',
        'MCU',
        'SR',
        'VRD',
        'Retimer'
    }

    local firmware_type = ''
    for _, v in ipairs(firmware_types) do
        if string.match(id, v) ~= nil then
            firmware_type = v
            break
        end
    end

    if firmware_type ~= '' then
        for _, board in ipairs(Input) do
            local firmware_id = search_id(id_table, firmware_type, id, board)
            if firmware_id then
                return firmware_id
            end
        end
    end

    return id
end

local member = {}
for _, path in ipairs(firmware_list) do
    local uriid = string.match(path, '/bmc/kepler/UpdateService/FirmwareInventory/(.*)')
    if uriid and uriid ~= '' then
        local firmware_id = get_firmwareid_via_uriid(uriid)
        member[#member + 1] = '/redfish/v1/UpdateService/FirmwareInventory/' .. firmware_id
    end
end
return member
