-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local image_path = ReqBody.Image
local protocol_type = ReqBody.TransferProtocolType

if not protocol_type then
    return true
end
if #image_path <= #protocol_type or string.upper(string.sub(image_path, 1, #protocol_type)) ~= protocol_type then
    return error(custom_messages.FileTransferProtocolMismatch())
end
return true