-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local image_path = ReqBody.Image
local user_name = ReqBody.UserName

if not user_name then
    return image_path
end

local passwd = ReqBody.Password
local supported_auth_protocols = { 'https', 'cifs' } -- 目前需要鉴权的协议仅https和cifs, nfs不鉴权

local protocol, rest = string.match(image_path, "^(%a+)%://(.+)$")

local function contains_val(tbl, value)
    for _, v in ipairs(tbl) do
        if v == value then
            return true
        end
    end
    return false
end

if protocol and contains_val(supported_auth_protocols, protocol) then
    return string.format("%s://%s:%s@%s", protocol, user_name, passwd, rest)
else
    return image_path
end