-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log_table = cjson.json_object_new_array()
for _, items in ipairs(ProcessingFlow[2].Destination.Items) do
    local items_table = cjson.json_object_new_object()
    local odata_id = '/redfish/v1/Managers/1/LogServices/SecurityLog/Entries/' .. items['Params'][1]['Value']
    items_table['@odata.id'] = odata_id
    items_table['@odata.context'] = "/redfish/v1/$metadata#LogEntry.LogEntry"
    items_table['@odata.type'] = "#LogEntry.v1_1_1.LogEntry"
    items_table['Name'] = "Security Log"
    items_table['EntryType'] = "Oem"
    items_table['Id'] = tonumber(items['Params'][1]['Value'])
    items_table['Created'] = items['Params'][2]['Value']
    items_table['Message'] = items['Params'][5]['Value']

    local oem_info_table = cjson.json_object_new_object()
    oem_info_table['Interface'] = items['Params'][3]['Value']
    oem_info_table['Host'] = items['Params'][4]['Value']

    local oem_table = cjson.json_object_new_object()
    oem_table['{{OemIdentifier}}'] = oem_info_table

    items_table['Oem'] = oem_table
    log_table[#log_table + 1] = items_table
end

return log_table