-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

if ReqBody.IPv4Addresses == nil then
    return false
end

if ReqBody.IPv4Addresses[1].Address == nil and ReqBody.IPv4Addresses[1].SubnetMask == nil and
    ReqBody.IPv4Addresses[1].Gateway == nil then
    return false
end

if ReqBody.IPv4Addresses[1].AddressOrigin == 'DHCP' then
    local err = custom_messages.IPv4InfoConflictwithDHCP()
    err.RelatedProperties = {'#/IPv4Addresses'}
    error(err)
end

-- 如果当前模式为dhcp，但没传ip地址和静态ip模式，则掩码和网关都不能设置
if ProcessingFlow[2].Destination.IpMode == 'DHCP' and ReqBody.IPv4Addresses[1].AddressOrigin ~=
    'Static' and ReqBody.IPv4Addresses[1].Address == nil then
    if ReqBody.IPv4Addresses[1].SubnetMask ~= nil and ReqBody.IPv4Addresses[1].Gateway ~= nil then
        local err = custom_messages.IPv4InfoConflictwithDHCP()
        err.RelatedProperties = {'#/IPv4Addresses/0/SubnetMask', '#/IPv4Addresses/0/Gateway'}
        error(err)
    end
    if ReqBody.IPv4Addresses[1].SubnetMask ~= nil then
        local err = custom_messages.IPv4InfoConflictwithDHCP()
        err.RelatedProperties = {'#/IPv4Addresses/0/SubnetMask'}
        error(err)
    end
    if ReqBody.IPv4Addresses[1].Gateway ~= nil then
        local err = custom_messages.IPv4InfoConflictwithDHCP()
        err.RelatedProperties = {'#/IPv4Addresses/0/Gateway'}
        error(err)
    end
end

return true
