-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local privilege_tab = ReqBody.AssignedPrivileges
if not privilege_tab then
    return true
end
local is_have_login = false
local is_hava_configureself = false
for _, v in pairs(privilege_tab) do
    if v == 'Login' then
        is_have_login = true
    end
    if v == 'ConfigureSelf' then
        is_hava_configureself = true
    end
end

if not is_have_login then
    error(custom_messages.PropertyItemMissing('Login'))
end
if not is_hava_configureself then
    error(custom_messages.PropertyItemMissing('ConfigureSelf'))
end

return true