-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}
local INVALID = -1

function m.get_destination_type_and_id(uri_id)
    if tonumber(uri_id) then
        return {'Redfish', uri_id}
    end

    local lower_id = string.lower(uri_id)
    if lower_id:match('^snmp') then
        return {'Snmp', lower_id:match('^snmp(.*)$')}
    end

    return {'Other', INVALID}
end

return m