-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local vlan_state
local vlan_id
local port_type = 0 -- 默认为0
local dedicated_vlan_supported = ProcessingFlow[1].Destination.DedicatedVlanSupported
-- 未输入参数
if type(ReqBody.vlanid) ~= 'string' then
    return {false}
end

if ReqBody.vlanid == 'off' then
    vlan_state = false
    vlan_id = 0
else
    vlan_id = tonumber(ReqBody.vlanid)
    -- 判断输入的vlanid是否是1到4094之间的整数
    if not vlan_id or math.type(vlan_id) ~= 'integer' or vlan_id < 1 or vlan_id > 4094 then
        return {false}
    else
        vlan_state = true
    end
end

if type(ReqBody.port_type) == 'string' then
    port_type = tonumber(ReqBody.port_type)
    -- 支持专用管理网口vlan配置为false时只支持输入port_type为0
    if not port_type or math.type(port_type) ~= 'integer' or port_type < 0 or port_type > 1 then
        return {false}
    end
    if dedicated_vlan_supported ~= true and port_type == 1 then
        return {false}
    end
end
return {true, vlan_state, vlan_id, port_type}