-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local v1 = ReqBody.value1
local v2 = ReqBody.value2
local v3 = ReqBody.value3
local min_power_idx = 1
local max_power_idx = #ProcessingFlow[2].Destination.OnePowerList
local deep_sleep_supported = ProcessingFlow[1].Destination.DeepSleepSupported
if type(v1) ~= 'string' then -- 无输入参数
    return false
end
if type(v2) ~= 'string' then -- 只有1个参数，只能是设置0负载均衡
    if v1 ~= '0' then
        return false
    end
elseif type(v2) == 'string' and type(v3) ~= 'string' then -- 2个参数
    if v1 == '1' then -- 主备模式
        local v2_to_int = tonumber(v2)
        if math.type(v2_to_int) ~= 'integer' then -- 非整数输入
            return false
        end
        -- 不在可选电源id范围内
        if v2_to_int < min_power_idx or v2_to_int > max_power_idx then
            return false
        end
    elseif v1 == '2' and deep_sleep_supported == true then -- 深度休眠模式
        if v2 ~= 'enabled' and v2 ~= 'disabled' then
            return false
        end
    else
        return false
    end
else -- 3个参数只能选择主备模式
    if v1 ~= '1' then
        return false
    end
    local v2_to_int = tonumber(v2)
    local v3_to_int = tonumber(v3)
    -- 非整数输入
    if math.type(v2_to_int) ~= 'integer' or math.type(v3_to_int) ~= 'integer' then
        return false
    end
    -- 不在可选电源id范围内
    if v2_to_int < min_power_idx or v2_to_int > max_power_idx then
        return false
    end
    if v3_to_int < min_power_idx or v3_to_int > max_power_idx then
        return false
    end
end
return true