-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

function m.get_severity(lowest_severity)
    if lowest_severity == 'None' then
        return 'none'
    elseif lowest_severity == 'Critical' then
        return 'critical'
    elseif lowest_severity == 'Major' then
        return 'major  critical'
    elseif lowest_severity == 'Minor' then
        return 'minor  major  critical'
    elseif lowest_severity == 'Normal' then
        return 'normal  minor  major  critical'
    end
end

function m.get_identity(server_identity_source)
    if server_identity_source == 'HostName' then
        return 'host name'
    elseif server_identity_source == 'ProductAssetTag' then
        return 'product asset tag'
    elseif server_identity_source == 'BoardSN' then
        return 'board serial number'
    end
end

function m.set_severity(lowest_severity)
    if lowest_severity == 'critical' then
        return 'Critical'
    elseif lowest_severity == 'major' then
        return 'Major'
    elseif lowest_severity == 'minor' then
        return 'Minor'
    elseif lowest_severity == 'normal' or lowest_severity == 'all' then
        return 'Normal'
    elseif lowest_severity == 'none' then
        return 'None'
    end
end

function m.check_message_format(message_format)
    if message_format == 'Custom' then
        return true
    end

    return false
end

local log_type_mask = {
    operationlogs = 0x1,
    securitylogs = 0x2,
    eventlogs = 0x4,
    intrusion_detectionlogs = 0x8
}

function m.check_log_type(ReqBody)
    local log_type = {}
    for k, v in pairs(ReqBody) do
        if k ~= 'Destination' and v ~= nil then
            log_type[#log_type + 1] = v
        end
    end

    if #log_type == 1 then
        local all_log_type_mask = log_type_mask
        all_log_type_mask['none'] = 0
        all_log_type_mask['all'] = 16
        for _, v in ipairs(log_type) do
            if all_log_type_mask[v] == nil then
                return false
            end
        end
    else
        local log_count = {
            operationlogs = 0,
            securitylogs = 0,
            eventlogs = 0,
            intrusion_detectionlogs = 0
        }
        for _, value in ipairs(log_type) do
            if log_count[value] == nil then
                return false
            end

            if log_count[value] ~= 0 then
                return false
            end

            log_count[value] = log_count[value] + 1
        end
    end

    return true
end

function m.set_log_type(ReqBody)
    local log_type = {}
    for k, v in pairs(ReqBody) do
        if k ~= 'Destination' and v ~= nil then
            log_type[#log_type + 1] = v
        end
    end

    local log_table = {}
    if log_type[1] == 'none' then
        log_table = {}
    elseif log_type[1] == 'all' then
        log_table = {'OperationLog', 'SecurityLog', 'EventLog', 'IntrusionDetectionLog'}
    else
        for _, v in pairs(log_type) do
            if v == 'operationlogs' then
                table.insert(log_table, 'OperationLog')
            elseif v == 'securitylogs' then
                table.insert(log_table, 'SecurityLog')
            elseif v == 'eventlogs' then
                table.insert(log_table, 'EventLog')
            elseif v == 'intrusion_detectionlogs' then
                table.insert(log_table, 'IntrusionDetectionLog')
            end
        end
    end

    return log_table
end

return m
