-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local context = require 'mc.context'

local LATCH<const> = 1
local NO_LATCH<const> = 0
local POWER_MGMT_MDB_SERVICE<const> = 'bmc.kepler.power_mgmt'
local POWER_STATUS_MDB_INTERFACE<const> = 'bmc.kepler.Systems.PowerMgmt.OnePower.Status'

local m = {}

function m.set_psu_alarm_latch(one_power_path, state)
    if not one_power_path or type(one_power_path) ~= "string" or #one_power_path == 0 then
        return false
    end
    local err, _ = bus:pcall(POWER_MGMT_MDB_SERVICE, one_power_path, POWER_STATUS_MDB_INTERFACE,
        'SetAlarmLatch', 'a{ss}y', context.get_context() or context.new(), state == 'enabled' and
        LATCH or NO_LATCH)
    if err then
        return false
    end
    return true
end

return m