-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

TestPowerMgmtApp = {}

function TestPowerMgmtApp:test_init_debug_service()
    local power_mgmt_app = require 'power_mgmt_app'
    lu.assertEquals(power_mgmt_app ~= nil, true)
    local bus = ''
    local tmp = {
        power_debug_service_class = {
            new = function (b)
                return 1
            end
        },
        debug_service_enable = false
    }
    local ok = pcall(function ()
        return power_mgmt_app.init_debug_service(tmp, bus)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(tmp.debug_service_enable, true)
end

function TestPowerMgmtApp:test_create_debug_service()
    local power_mgmt_app = require 'power_mgmt_app'
    lu.assertEquals(power_mgmt_app ~= nil, true)
    local tmp = {
        debug_service_enable = true,
        power_mgmt_debug_service = {
            CreateOnePowerDebug = function ()
                return
            end
        }
    }
    local psu_object = {
        ObjectName = 'OnePower_0_010109'
    }
    local ok = pcall(function ()
        power_mgmt_app.create_debug_service(tmp, psu_object)
    end)
    lu.assertEquals(ok, true)
end

function TestPowerMgmtApp:test_register_debug_rpc_methods()
    local power_mgmt_app = require 'power_mgmt_app'
    lu.assertEquals(power_mgmt_app ~= nil, true)
    local tmp = {
        power_debug_service_class = {
            implement_methods = function ()
                return
            end
        },
        power_mgmt_debug_service = {
            implement_methods = function ()
                return
            end
        }
    }
    local ok = pcall(function ()
        power_mgmt_app.register_debug_rpc_methods(tmp)
    end)
    lu.assertEquals(ok, true)
end

function TestPowerMgmtApp:test_set_power_reset_type()
    local power_mgmt_app = require 'power_mgmt_app'
    lu.assertEquals(power_mgmt_app ~= nil, true)
    power_mgmt_app.psu_service = {
        set_power_reset_type = function (...)
            return
        end
    }
    local ok = pcall(function ()
        power_mgmt_app:set_power_reset_type(nil, {SlotNumber = 1}, "ForceRestart")
    end)
    lu.assertEquals(ok, true)
end

local E_OK <const> = nil -- 函数执行成功返回nil
local E_FAILED <const> = '' -- 空错误信息
function TestPowerMgmtApp:test_set_power_capacitor_enable_1()
    local power_mgmt_app = require 'power_mgmt_app'
    lu.assertEquals(power_mgmt_app ~= nil, true)
    power_mgmt_app.psu_service = {
        set_power_capacitor_enable = function (...)
            return E_OK
        end
    }
    local psu = {}
    psu.SlotNumber = 1
    local c_psu_object = require 'device.psu'
    lu.assertEquals(c_psu_object ~= nil, true)
    c_psu_object.collection.find = function (...)
        return psu
    end
    local ok = pcall(function ()
        power_mgmt_app:set_power_capacitor_enable(nil, {SlotNumber = 1}, "ForceOff")
    end)
    lu.assertEquals(ok, true)
    power_mgmt_app.psu_service = {
        set_power_capacitor_enable = function (...)
            return E_FAILED
        end
    }
    ok = pcall(function ()
        power_mgmt_app:set_power_capacitor_enable(nil, {SlotNumber = 1}, "ForceOff")
    end)
    lu.assertEquals(ok, false)
end