-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'

TestCanbusTpsu = {}

function TestCanbusTpsu:test_reset()
    local canbus_tpsu = require 'device_tree.adapters.power_mgmt.protocol.canbus_tpsu'
    local canbus_tpsu_mock = {
        set_signal_data = function ()
            return 0
        end,
        cmd = {
            CANBUS_CMD_RESET = 0x136
        }
    }
    local ok, _ = pcall(function()
        return canbus_tpsu.reset(canbus_tpsu_mock, 'ForceOn')
    end)
    lu.assertEquals(ok, false)

    ok, _ = pcall(function()
        return canbus_tpsu.reset(canbus_tpsu_mock, 'ForceOff')
    end)

    lu.assertTrue(ok)

    ok, _ = pcall(function()
        return canbus_tpsu.reset(canbus_tpsu_mock, 'On')
    end)
    lu.assertTrue(ok)
end