-- Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: fumingquan
-- Create: 2023-05-29
local log = require 'mc.logging'
local mc_context = require 'mc.context'
local json = require 'cjson'

local context = mc_context.new('IT', 'Admin', '127.0.0.1')
local service = 'bmc.kepler.power_mgmt'
local path = '/bmc/kepler/power_mgmt/MicroComponent'
local intf = 'bmc.kepler.MicroComponent.ConfigManage'

local test_customize_config = {}

local function test_on_import(bus)
    -- 当前回调函数不支持代理对象访问，这地方直接使用busctl访问方式进行测试
    -- 使用导出功能进行验证

    local data = json.encode({
        ConfigData = {
            CustomSettings = {
                BMCSet_RetransferDelaySeconds = { Value = 1800 }
            }
        }
    })
    bus:call(service, path, intf, 'Import', 'a{ss}ss', context, data, 'custom')
end

local function test_on_export(bus)
    -- 当前回调函数不支持代理对象访问，这地方直接使用busctl访问方式进行测试
    local ret = bus:call(service, path, intf, 'Export', 'a{ss}s', context, 'custom')
    assert(ret)
    local data = json.decode(ret)
    assert(data)
    assert(data.ConfigData)
    assert(data.ConfigData.CustomSettings.BMCSet_RetransferDelaySeconds == 1800)
end

function test_customize_config.main(bus)
    test_on_import(bus)
    test_on_export(bus)
end

return test_customize_config
