-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 添加事件接口
local singleton = require 'mc.singleton'
local class = require 'mc.class'
local log = require 'mc.logging'
local cjson = require 'cjson'
local ctx = require 'mc.context'
local client = require 'power_mgmt.client'

local c_add_event = class()

function c_add_event.generate_power_failure(assert, time_stamp)
    log:notice('touch power failure alarm')
    local param = {}
    param[#param + 1] = { 'ComponentName', 'PowerSupply' }
    param[#param + 1] = { 'State', assert }
    param[#param + 1] = { 'EventKeyId', 'PSU.PSUServerPowerFailure' }
    param[#param + 1] = { 'MessageArgs', cjson.encode({time_stamp}) }
    param[#param + 1] = { 'SystemId', '' }
    param[#param + 1] = { 'ManagerId', '' }
    param[#param + 1] = { 'ChassisId', '' }
    param[#param + 1] = { 'NodeId', '' }
    local ok, ret = pcall(client.EventsEventsAddEvent, client, ctx.new(), {["SystemId"] = 1}, param)
    if ok then
        log:notice('add event successfully')
    else
        log:error('add event failed, %s', ret)
    end
end

return singleton(c_add_event)