-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local UpdateService = {}

---@class UpdateService.PendingFirmware
---@field SystemId integer
---@field Firmware string
---@field FirmwareInstance string
---@field ActiveStatus string
---@field ActiveAction string
local TPendingFirmware = {}
TPendingFirmware.__index = TPendingFirmware
TPendingFirmware.group = {}

local function TPendingFirmware_from_obj(obj)
    return setmetatable(obj, TPendingFirmware)
end

function TPendingFirmware.new(SystemId, Firmware, FirmwareInstance, ActiveStatus, ActiveAction)
    return TPendingFirmware_from_obj({
        SystemId = SystemId,
        Firmware = Firmware,
        FirmwareInstance = FirmwareInstance,
        ActiveStatus = ActiveStatus,
        ActiveAction = ActiveAction
    })
end
---@param obj UpdateService.PendingFirmware
function TPendingFirmware:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Firmware = obj.Firmware
    self.FirmwareInstance = obj.FirmwareInstance
    self.ActiveStatus = obj.ActiveStatus
    self.ActiveAction = obj.ActiveAction
end

function TPendingFirmware:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPendingFirmware.group)
end

TPendingFirmware.from_obj = TPendingFirmware_from_obj

TPendingFirmware.proto_property = {'SystemId', 'Firmware', 'FirmwareInstance', 'ActiveStatus', 'ActiveAction'}

TPendingFirmware.default = {0, '', '', '', ''}

TPendingFirmware.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'Firmware', is_array = false, struct = nil},
    {name = 'FirmwareInstance', is_array = false, struct = nil},
    {name = 'ActiveStatus', is_array = false, struct = nil}, {name = 'ActiveAction', is_array = false, struct = nil}
}

function TPendingFirmware:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Firmware', self.Firmware, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareInstance', self.FirmwareInstance, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ActiveStatus', self.ActiveStatus, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ActiveAction', self.ActiveAction, 'string', false, errs, need_convert)

    TPendingFirmware:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPendingFirmware.proto_property, errs, need_convert)
    return self
end

function TPendingFirmware:unpack(_)
    return self.SystemId, self.Firmware, self.FirmwareInstance, self.ActiveStatus, self.ActiveAction
end

UpdateService.PendingFirmware = TPendingFirmware

---@class UpdateService.UpdateProgress
---@field key string
---@field value string
local TUpdateProgress = {}
TUpdateProgress.__index = TUpdateProgress
TUpdateProgress.group = {}

local function TUpdateProgress_from_obj(obj)
    return setmetatable(obj, TUpdateProgress)
end

function TUpdateProgress.new(dict)
    return TUpdateProgress_from_obj(dict)
end

---@param obj UpdateService.UpdateProgress
function TUpdateProgress:init_from_obj(obj)
    self = obj
end

function TUpdateProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateProgress.group)
end

TUpdateProgress.from_obj = TUpdateProgress_from_obj

TUpdateProgress.proto_property = {}

TUpdateProgress.default = {}

TUpdateProgress.struct = {}

function TUpdateProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TUpdateProgress:remove_error_props(errs, self)
    return self
end

function TUpdateProgress:unpack(_)
    return self
end

UpdateService.UpdateProgress = TUpdateProgress

---@class UpdateService.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj UpdateService.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

UpdateService.Object = TObject

---@class UpdateService.ParallelUpgradePackages
---@field FilePath string
---@field AdditionalOptions UpdateService.Object
local TParallelUpgradePackages = {}
TParallelUpgradePackages.__index = TParallelUpgradePackages
TParallelUpgradePackages.group = {}

local function TParallelUpgradePackages_from_obj(obj)
    return setmetatable(obj, TParallelUpgradePackages)
end

function TParallelUpgradePackages.new(FilePath, AdditionalOptions)
    return TParallelUpgradePackages_from_obj({FilePath = FilePath, AdditionalOptions = AdditionalOptions})
end
---@param obj UpdateService.ParallelUpgradePackages
function TParallelUpgradePackages:init_from_obj(obj)
    self.FilePath = obj.FilePath
    self.AdditionalOptions = obj.AdditionalOptions
end

function TParallelUpgradePackages:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParallelUpgradePackages.group)
end

TParallelUpgradePackages.from_obj = TParallelUpgradePackages_from_obj

TParallelUpgradePackages.proto_property = {'FilePath', 'AdditionalOptions'}

TParallelUpgradePackages.default = {'', UpdateService.Object.default}

TParallelUpgradePackages.struct = {
    {name = 'FilePath', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TParallelUpgradePackages:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TParallelUpgradePackages:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParallelUpgradePackages.proto_property, errs, need_convert)
    return self
end

function TParallelUpgradePackages:unpack(_)
    return self.FilePath, self.AdditionalOptions
end

UpdateService.ParallelUpgradePackages = TParallelUpgradePackages

---@class UpdateService.TimeoutPolicy
---@field TimeoutPolicy integer
local TTimeoutPolicy = {}
TTimeoutPolicy.__index = TTimeoutPolicy
TTimeoutPolicy.group = {}

local function TTimeoutPolicy_from_obj(obj)
    return setmetatable(obj, TTimeoutPolicy)
end

function TTimeoutPolicy.new(TimeoutPolicy)
    return TTimeoutPolicy_from_obj({TimeoutPolicy = TimeoutPolicy})
end
---@param obj UpdateService.TimeoutPolicy
function TTimeoutPolicy:init_from_obj(obj)
    self.TimeoutPolicy = obj.TimeoutPolicy
end

function TTimeoutPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeoutPolicy.group)
end

TTimeoutPolicy.from_obj = TTimeoutPolicy_from_obj

TTimeoutPolicy.proto_property = {'TimeoutPolicy'}

TTimeoutPolicy.default = {0}

TTimeoutPolicy.struct = {{name = 'TimeoutPolicy', is_array = false, struct = nil}}

function TTimeoutPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeoutPolicy', self.TimeoutPolicy, 'uint8', true, errs, need_convert)

    TTimeoutPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeoutPolicy.proto_property, errs, need_convert)
    return self
end

function TTimeoutPolicy:unpack(_)
    return self.TimeoutPolicy
end

UpdateService.TimeoutPolicy = TTimeoutPolicy

---@class UpdateService.UpgradeMode
---@field UpgradeMode string
local TUpgradeMode = {}
TUpgradeMode.__index = TUpgradeMode
TUpgradeMode.group = {}

local function TUpgradeMode_from_obj(obj)
    return setmetatable(obj, TUpgradeMode)
end

function TUpgradeMode.new(UpgradeMode)
    return TUpgradeMode_from_obj({UpgradeMode = UpgradeMode})
end
---@param obj UpdateService.UpgradeMode
function TUpgradeMode:init_from_obj(obj)
    self.UpgradeMode = obj.UpgradeMode
end

function TUpgradeMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeMode.group)
end

TUpgradeMode.from_obj = TUpgradeMode_from_obj

TUpgradeMode.proto_property = {'UpgradeMode'}

TUpgradeMode.default = {''}

TUpgradeMode.struct = {{name = 'UpgradeMode', is_array = false, struct = nil}}

function TUpgradeMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeMode', self.UpgradeMode, 'string', true, errs, need_convert)

    if self.UpgradeMode ~= nil then
        validate.Enum(prefix .. 'UpgradeMode', self.UpgradeMode, '', {'Serial', 'Parallel'}, errs, need_convert)
    end

    TUpgradeMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeMode.proto_property, errs, need_convert)
    return self
end

function TUpgradeMode:unpack(_)
    return self.UpgradeMode
end

UpdateService.UpgradeMode = TUpgradeMode

---@class UpdateService.ParallelSupported
---@field ParallelSupported boolean
local TParallelSupported = {}
TParallelSupported.__index = TParallelSupported
TParallelSupported.group = {}

local function TParallelSupported_from_obj(obj)
    return setmetatable(obj, TParallelSupported)
end

function TParallelSupported.new(ParallelSupported)
    return TParallelSupported_from_obj({ParallelSupported = ParallelSupported})
end
---@param obj UpdateService.ParallelSupported
function TParallelSupported:init_from_obj(obj)
    self.ParallelSupported = obj.ParallelSupported
end

function TParallelSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParallelSupported.group)
end

TParallelSupported.from_obj = TParallelSupported_from_obj

TParallelSupported.proto_property = {'ParallelSupported'}

TParallelSupported.default = {false}

TParallelSupported.struct = {{name = 'ParallelSupported', is_array = false, struct = nil}}

function TParallelSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ParallelSupported', self.ParallelSupported, 'bool', true, errs, need_convert)

    TParallelSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParallelSupported.proto_property, errs, need_convert)
    return self
end

function TParallelSupported:unpack(_)
    return self.ParallelSupported
end

UpdateService.ParallelSupported = TParallelSupported

---@class UpdateService.UpgradingFlag
---@field UpgradingFlag boolean
local TUpgradingFlag = {}
TUpgradingFlag.__index = TUpgradingFlag
TUpgradingFlag.group = {}

local function TUpgradingFlag_from_obj(obj)
    return setmetatable(obj, TUpgradingFlag)
end

function TUpgradingFlag.new(UpgradingFlag)
    return TUpgradingFlag_from_obj({UpgradingFlag = UpgradingFlag})
end
---@param obj UpdateService.UpgradingFlag
function TUpgradingFlag:init_from_obj(obj)
    self.UpgradingFlag = obj.UpgradingFlag
end

function TUpgradingFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradingFlag.group)
end

TUpgradingFlag.from_obj = TUpgradingFlag_from_obj

TUpgradingFlag.proto_property = {'UpgradingFlag'}

TUpgradingFlag.default = {false}

TUpgradingFlag.struct = {{name = 'UpgradingFlag', is_array = false, struct = nil}}

function TUpgradingFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradingFlag', self.UpgradingFlag, 'bool', true, errs, need_convert)

    TUpgradingFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradingFlag.proto_property, errs, need_convert)
    return self
end

function TUpgradingFlag:unpack(_)
    return self.UpgradingFlag
end

UpdateService.UpgradingFlag = TUpgradingFlag

---@class UpdateService.UpgradeKeyDomainId
---@field UpgradeKeyDomainId integer
local TUpgradeKeyDomainId = {}
TUpgradeKeyDomainId.__index = TUpgradeKeyDomainId
TUpgradeKeyDomainId.group = {}

local function TUpgradeKeyDomainId_from_obj(obj)
    return setmetatable(obj, TUpgradeKeyDomainId)
end

function TUpgradeKeyDomainId.new(UpgradeKeyDomainId)
    return TUpgradeKeyDomainId_from_obj({UpgradeKeyDomainId = UpgradeKeyDomainId})
end
---@param obj UpdateService.UpgradeKeyDomainId
function TUpgradeKeyDomainId:init_from_obj(obj)
    self.UpgradeKeyDomainId = obj.UpgradeKeyDomainId
end

function TUpgradeKeyDomainId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeKeyDomainId.group)
end

TUpgradeKeyDomainId.from_obj = TUpgradeKeyDomainId_from_obj

TUpgradeKeyDomainId.proto_property = {'UpgradeKeyDomainId'}

TUpgradeKeyDomainId.default = {0}

TUpgradeKeyDomainId.struct = {{name = 'UpgradeKeyDomainId', is_array = false, struct = nil}}

function TUpgradeKeyDomainId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeKeyDomainId', self.UpgradeKeyDomainId, 'uint32', true, errs, need_convert)

    TUpgradeKeyDomainId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeKeyDomainId.proto_property, errs, need_convert)
    return self
end

function TUpgradeKeyDomainId:unpack(_)
    return self.UpgradeKeyDomainId
end

UpdateService.UpgradeKeyDomainId = TUpgradeKeyDomainId

---@class UpdateService.ExportSignalSignature
---@field SystemId integer
---@field Id string
local TExportSignalSignature = {}
TExportSignalSignature.__index = TExportSignalSignature
TExportSignalSignature.group = {}

local function TExportSignalSignature_from_obj(obj)
    return setmetatable(obj, TExportSignalSignature)
end

function TExportSignalSignature.new(SystemId, Id)
    return TExportSignalSignature_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.ExportSignalSignature
function TExportSignalSignature:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TExportSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportSignalSignature.group)
end

TExportSignalSignature.from_obj = TExportSignalSignature_from_obj

TExportSignalSignature.proto_property = {'SystemId', 'Id'}

TExportSignalSignature.default = {0, ''}

TExportSignalSignature.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil}
}

function TExportSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TExportSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportSignalSignature.proto_property, errs, need_convert)
    return self
end

function TExportSignalSignature:unpack(_)
    return self.SystemId, self.Id
end

UpdateService.ExportSignalSignature = TExportSignalSignature

---@class UpdateService.RollbackSignalSignature
---@field SystemId integer
---@field Id string
local TRollbackSignalSignature = {}
TRollbackSignalSignature.__index = TRollbackSignalSignature
TRollbackSignalSignature.group = {}

local function TRollbackSignalSignature_from_obj(obj)
    return setmetatable(obj, TRollbackSignalSignature)
end

function TRollbackSignalSignature.new(SystemId, Id)
    return TRollbackSignalSignature_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.RollbackSignalSignature
function TRollbackSignalSignature:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TRollbackSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackSignalSignature.group)
end

TRollbackSignalSignature.from_obj = TRollbackSignalSignature_from_obj

TRollbackSignalSignature.proto_property = {'SystemId', 'Id'}

TRollbackSignalSignature.default = {0, ''}

TRollbackSignalSignature.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil}
}

function TRollbackSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TRollbackSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackSignalSignature.proto_property, errs, need_convert)
    return self
end

function TRollbackSignalSignature:unpack(_)
    return self.SystemId, self.Id
end

UpdateService.RollbackSignalSignature = TRollbackSignalSignature

---@class UpdateService.UpgradeFinishSignalSignature
---@field SystemId integer
---@field FirmwareType string
---@field AdditionalOptions UpdateService.Object
local TUpgradeFinishSignalSignature = {}
TUpgradeFinishSignalSignature.__index = TUpgradeFinishSignalSignature
TUpgradeFinishSignalSignature.group = {}

local function TUpgradeFinishSignalSignature_from_obj(obj)
    return setmetatable(obj, TUpgradeFinishSignalSignature)
end

function TUpgradeFinishSignalSignature.new(SystemId, FirmwareType, AdditionalOptions)
    return TUpgradeFinishSignalSignature_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.UpgradeFinishSignalSignature
function TUpgradeFinishSignalSignature:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.AdditionalOptions = obj.AdditionalOptions
end

function TUpgradeFinishSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFinishSignalSignature.group)
end

TUpgradeFinishSignalSignature.from_obj = TUpgradeFinishSignalSignature_from_obj

TUpgradeFinishSignalSignature.proto_property = {'SystemId', 'FirmwareType', 'AdditionalOptions'}

TUpgradeFinishSignalSignature.default = {0, '', UpdateService.Object.default}

TUpgradeFinishSignalSignature.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TUpgradeFinishSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)

    TUpgradeFinishSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFinishSignalSignature.proto_property, errs, need_convert)
    return self
end

function TUpgradeFinishSignalSignature:unpack(_)
    return self.SystemId, self.FirmwareType, self.AdditionalOptions
end

UpdateService.UpgradeFinishSignalSignature = TUpgradeFinishSignalSignature

---@class UpdateService.UpgradeProcessSignalSignature
---@field SystemId integer
---@field FirmwareType string
---@field FileName string
---@field AdditionalOptions UpdateService.Object
local TUpgradeProcessSignalSignature = {}
TUpgradeProcessSignalSignature.__index = TUpgradeProcessSignalSignature
TUpgradeProcessSignalSignature.group = {}

local function TUpgradeProcessSignalSignature_from_obj(obj)
    return setmetatable(obj, TUpgradeProcessSignalSignature)
end

function TUpgradeProcessSignalSignature.new(SystemId, FirmwareType, FileName, AdditionalOptions)
    return TUpgradeProcessSignalSignature_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        FileName = FileName,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.UpgradeProcessSignalSignature
function TUpgradeProcessSignalSignature:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.FileName = obj.FileName
    self.AdditionalOptions = obj.AdditionalOptions
end

function TUpgradeProcessSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeProcessSignalSignature.group)
end

TUpgradeProcessSignalSignature.from_obj = TUpgradeProcessSignalSignature_from_obj

TUpgradeProcessSignalSignature.proto_property = {'SystemId', 'FirmwareType', 'FileName', 'AdditionalOptions'}

TUpgradeProcessSignalSignature.default = {0, '', '', UpdateService.Object.default}

TUpgradeProcessSignalSignature.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FileName', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TUpgradeProcessSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FileName', self.FileName, 'string', false, errs, need_convert)

    TUpgradeProcessSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeProcessSignalSignature.proto_property, errs, need_convert)
    return self
end

function TUpgradeProcessSignalSignature:unpack(_)
    return self.SystemId, self.FirmwareType, self.FileName, self.AdditionalOptions
end

UpdateService.UpgradeProcessSignalSignature = TUpgradeProcessSignalSignature

---@class UpdateService.UpgradePrepareSignalSignature
---@field SystemId integer
---@field FirmwareType string
---@field CfgPath string
---@field FilePath string
---@field AdditionalOptions UpdateService.Object
local TUpgradePrepareSignalSignature = {}
TUpgradePrepareSignalSignature.__index = TUpgradePrepareSignalSignature
TUpgradePrepareSignalSignature.group = {}

local function TUpgradePrepareSignalSignature_from_obj(obj)
    return setmetatable(obj, TUpgradePrepareSignalSignature)
end

function TUpgradePrepareSignalSignature.new(SystemId, FirmwareType, CfgPath, FilePath, AdditionalOptions)
    return TUpgradePrepareSignalSignature_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        CfgPath = CfgPath,
        FilePath = FilePath,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.UpgradePrepareSignalSignature
function TUpgradePrepareSignalSignature:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.CfgPath = obj.CfgPath
    self.FilePath = obj.FilePath
    self.AdditionalOptions = obj.AdditionalOptions
end

function TUpgradePrepareSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradePrepareSignalSignature.group)
end

TUpgradePrepareSignalSignature.from_obj = TUpgradePrepareSignalSignature_from_obj

TUpgradePrepareSignalSignature.proto_property = {'SystemId', 'FirmwareType', 'CfgPath', 'FilePath', 'AdditionalOptions'}

TUpgradePrepareSignalSignature.default = {0, '', '', '', UpdateService.Object.default}

TUpgradePrepareSignalSignature.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'CfgPath', is_array = false, struct = nil}, {name = 'FilePath', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TUpgradePrepareSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CfgPath', self.CfgPath, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TUpgradePrepareSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradePrepareSignalSignature.proto_property, errs, need_convert)
    return self
end

function TUpgradePrepareSignalSignature:unpack(_)
    return self.SystemId, self.FirmwareType, self.CfgPath, self.FilePath, self.AdditionalOptions
end

UpdateService.UpgradePrepareSignalSignature = TUpgradePrepareSignalSignature

---@class UpdateService.ParseFirmwarePackageRsp
---@field FirmwareType string
---@field FirmwareDirectory string
local TParseFirmwarePackageRsp = {}
TParseFirmwarePackageRsp.__index = TParseFirmwarePackageRsp
TParseFirmwarePackageRsp.group = {}

local function TParseFirmwarePackageRsp_from_obj(obj)
    return setmetatable(obj, TParseFirmwarePackageRsp)
end

function TParseFirmwarePackageRsp.new(FirmwareType, FirmwareDirectory)
    return TParseFirmwarePackageRsp_from_obj({FirmwareType = FirmwareType, FirmwareDirectory = FirmwareDirectory})
end
---@param obj UpdateService.ParseFirmwarePackageRsp
function TParseFirmwarePackageRsp:init_from_obj(obj)
    self.FirmwareType = obj.FirmwareType
    self.FirmwareDirectory = obj.FirmwareDirectory
end

function TParseFirmwarePackageRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParseFirmwarePackageRsp.group)
end

TParseFirmwarePackageRsp.from_obj = TParseFirmwarePackageRsp_from_obj

TParseFirmwarePackageRsp.proto_property = {'FirmwareType', 'FirmwareDirectory'}

TParseFirmwarePackageRsp.default = {'', ''}

TParseFirmwarePackageRsp.struct = {
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FirmwareDirectory', is_array = false, struct = nil}
}

function TParseFirmwarePackageRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareDirectory', self.FirmwareDirectory, 'string', false, errs, need_convert)

    TParseFirmwarePackageRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParseFirmwarePackageRsp.proto_property, errs, need_convert)
    return self
end

function TParseFirmwarePackageRsp:unpack(_)
    return self.FirmwareType, self.FirmwareDirectory
end

UpdateService.ParseFirmwarePackageRsp = TParseFirmwarePackageRsp

---@class UpdateService.ParseFirmwarePackageReq
---@field FilePath string
local TParseFirmwarePackageReq = {}
TParseFirmwarePackageReq.__index = TParseFirmwarePackageReq
TParseFirmwarePackageReq.group = {}

local function TParseFirmwarePackageReq_from_obj(obj)
    return setmetatable(obj, TParseFirmwarePackageReq)
end

function TParseFirmwarePackageReq.new(FilePath)
    return TParseFirmwarePackageReq_from_obj({FilePath = FilePath})
end
---@param obj UpdateService.ParseFirmwarePackageReq
function TParseFirmwarePackageReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
end

function TParseFirmwarePackageReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParseFirmwarePackageReq.group)
end

TParseFirmwarePackageReq.from_obj = TParseFirmwarePackageReq_from_obj

TParseFirmwarePackageReq.proto_property = {'FilePath'}

TParseFirmwarePackageReq.default = {''}

TParseFirmwarePackageReq.struct = {{name = 'FilePath', is_array = false, struct = nil}}

function TParseFirmwarePackageReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TParseFirmwarePackageReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParseFirmwarePackageReq.proto_property, errs, need_convert)
    return self
end

function TParseFirmwarePackageReq:unpack(_)
    return self.FilePath
end

UpdateService.ParseFirmwarePackageReq = TParseFirmwarePackageReq

---@class UpdateService.CheckFirmwareTypeRsp
---@field IsMatch boolean
local TCheckFirmwareTypeRsp = {}
TCheckFirmwareTypeRsp.__index = TCheckFirmwareTypeRsp
TCheckFirmwareTypeRsp.group = {}

local function TCheckFirmwareTypeRsp_from_obj(obj)
    return setmetatable(obj, TCheckFirmwareTypeRsp)
end

function TCheckFirmwareTypeRsp.new(IsMatch)
    return TCheckFirmwareTypeRsp_from_obj({IsMatch = IsMatch})
end
---@param obj UpdateService.CheckFirmwareTypeRsp
function TCheckFirmwareTypeRsp:init_from_obj(obj)
    self.IsMatch = obj.IsMatch
end

function TCheckFirmwareTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCheckFirmwareTypeRsp.group)
end

TCheckFirmwareTypeRsp.from_obj = TCheckFirmwareTypeRsp_from_obj

TCheckFirmwareTypeRsp.proto_property = {'IsMatch'}

TCheckFirmwareTypeRsp.default = {false}

TCheckFirmwareTypeRsp.struct = {{name = 'IsMatch', is_array = false, struct = nil}}

function TCheckFirmwareTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsMatch', self.IsMatch, 'bool', false, errs, need_convert)

    TCheckFirmwareTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCheckFirmwareTypeRsp.proto_property, errs, need_convert)
    return self
end

function TCheckFirmwareTypeRsp:unpack(_)
    return self.IsMatch
end

UpdateService.CheckFirmwareTypeRsp = TCheckFirmwareTypeRsp

---@class UpdateService.CheckFirmwareTypeReq
---@field FilePath string
---@field FirmwareType string
local TCheckFirmwareTypeReq = {}
TCheckFirmwareTypeReq.__index = TCheckFirmwareTypeReq
TCheckFirmwareTypeReq.group = {}

local function TCheckFirmwareTypeReq_from_obj(obj)
    return setmetatable(obj, TCheckFirmwareTypeReq)
end

function TCheckFirmwareTypeReq.new(FilePath, FirmwareType)
    return TCheckFirmwareTypeReq_from_obj({FilePath = FilePath, FirmwareType = FirmwareType})
end
---@param obj UpdateService.CheckFirmwareTypeReq
function TCheckFirmwareTypeReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
    self.FirmwareType = obj.FirmwareType
end

function TCheckFirmwareTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCheckFirmwareTypeReq.group)
end

TCheckFirmwareTypeReq.from_obj = TCheckFirmwareTypeReq_from_obj

TCheckFirmwareTypeReq.proto_property = {'FilePath', 'FirmwareType'}

TCheckFirmwareTypeReq.default = {'', ''}

TCheckFirmwareTypeReq.struct = {
    {name = 'FilePath', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil}
}

function TCheckFirmwareTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)

    TCheckFirmwareTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCheckFirmwareTypeReq.proto_property, errs, need_convert)
    return self
end

function TCheckFirmwareTypeReq:unpack(_)
    return self.FilePath, self.FirmwareType
end

UpdateService.CheckFirmwareTypeReq = TCheckFirmwareTypeReq

---@class UpdateService.ExportRsp
local TExportRsp = {}
TExportRsp.__index = TExportRsp
TExportRsp.group = {}

local function TExportRsp_from_obj(obj)
    return setmetatable(obj, TExportRsp)
end

function TExportRsp.new()
    return TExportRsp_from_obj({})
end
---@param obj UpdateService.ExportRsp
function TExportRsp:init_from_obj(obj)

end

function TExportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRsp.group)
end

TExportRsp.from_obj = TExportRsp_from_obj

TExportRsp.proto_property = {}

TExportRsp.default = {}

TExportRsp.struct = {}

function TExportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRsp.proto_property, errs, need_convert)
    return self
end

function TExportRsp:unpack(_)
end

UpdateService.ExportRsp = TExportRsp

---@class UpdateService.ExportReq
---@field SystemId integer
---@field Id string
local TExportReq = {}
TExportReq.__index = TExportReq
TExportReq.group = {}

local function TExportReq_from_obj(obj)
    return setmetatable(obj, TExportReq)
end

function TExportReq.new(SystemId, Id)
    return TExportReq_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.ExportReq
function TExportReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TExportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportReq.group)
end

TExportReq.from_obj = TExportReq_from_obj

TExportReq.proto_property = {'SystemId', 'Id'}

TExportReq.default = {0, ''}

TExportReq.struct = {{name = 'SystemId', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil}}

function TExportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TExportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportReq.proto_property, errs, need_convert)
    return self
end

function TExportReq:unpack(_)
    return self.SystemId, self.Id
end

UpdateService.ExportReq = TExportReq

---@class UpdateService.RollbackRsp
local TRollbackRsp = {}
TRollbackRsp.__index = TRollbackRsp
TRollbackRsp.group = {}

local function TRollbackRsp_from_obj(obj)
    return setmetatable(obj, TRollbackRsp)
end

function TRollbackRsp.new()
    return TRollbackRsp_from_obj({})
end
---@param obj UpdateService.RollbackRsp
function TRollbackRsp:init_from_obj(obj)

end

function TRollbackRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackRsp.group)
end

TRollbackRsp.from_obj = TRollbackRsp_from_obj

TRollbackRsp.proto_property = {}

TRollbackRsp.default = {}

TRollbackRsp.struct = {}

function TRollbackRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRollbackRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackRsp.proto_property, errs, need_convert)
    return self
end

function TRollbackRsp:unpack(_)
end

UpdateService.RollbackRsp = TRollbackRsp

---@class UpdateService.RollbackReq
---@field SystemId integer
---@field Id string
local TRollbackReq = {}
TRollbackReq.__index = TRollbackReq
TRollbackReq.group = {}

local function TRollbackReq_from_obj(obj)
    return setmetatable(obj, TRollbackReq)
end

function TRollbackReq.new(SystemId, Id)
    return TRollbackReq_from_obj({SystemId = SystemId, Id = Id})
end
---@param obj UpdateService.RollbackReq
function TRollbackReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.Id = obj.Id
end

function TRollbackReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackReq.group)
end

TRollbackReq.from_obj = TRollbackReq_from_obj

TRollbackReq.proto_property = {'SystemId', 'Id'}

TRollbackReq.default = {0, ''}

TRollbackReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil}
}

function TRollbackReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TRollbackReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackReq.proto_property, errs, need_convert)
    return self
end

function TRollbackReq:unpack(_)
    return self.SystemId, self.Id
end

UpdateService.RollbackReq = TRollbackReq

---@class UpdateService.GetPendingFirmwareListRsp
---@field PendingFirmwareList UpdateService.PendingFirmware[]
local TGetPendingFirmwareListRsp = {}
TGetPendingFirmwareListRsp.__index = TGetPendingFirmwareListRsp
TGetPendingFirmwareListRsp.group = {}

local function TGetPendingFirmwareListRsp_from_obj(obj)
    obj.PendingFirmwareList = utils.from_obj(UpdateService.PendingFirmware, obj.PendingFirmwareList, true)
    return setmetatable(obj, TGetPendingFirmwareListRsp)
end

function TGetPendingFirmwareListRsp.new(PendingFirmwareList)
    return TGetPendingFirmwareListRsp_from_obj({PendingFirmwareList = PendingFirmwareList})
end
---@param obj UpdateService.GetPendingFirmwareListRsp
function TGetPendingFirmwareListRsp:init_from_obj(obj)
    self.PendingFirmwareList = obj.PendingFirmwareList
end

function TGetPendingFirmwareListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPendingFirmwareListRsp.group)
end

TGetPendingFirmwareListRsp.from_obj = TGetPendingFirmwareListRsp_from_obj

TGetPendingFirmwareListRsp.proto_property = {'PendingFirmwareList'}

TGetPendingFirmwareListRsp.default = {{}}

TGetPendingFirmwareListRsp.struct = {
    {name = 'PendingFirmwareList', is_array = true, struct = UpdateService.PendingFirmware.struct}
}

function TGetPendingFirmwareListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PendingFirmwareList) do
        UpdateService.PendingFirmware.new(v.SystemId, v.Firmware, v.FirmwareInstance, v.ActiveStatus,
            v.ActiveAction):validate(prefix, errs, need_convert)
    end

    TGetPendingFirmwareListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPendingFirmwareListRsp.proto_property, errs, need_convert)
    return self
end

function TGetPendingFirmwareListRsp:unpack(raw)
    return utils.unpack(raw, self.PendingFirmwareList, true)
end

UpdateService.GetPendingFirmwareListRsp = TGetPendingFirmwareListRsp

---@class UpdateService.GetPendingFirmwareListReq
local TGetPendingFirmwareListReq = {}
TGetPendingFirmwareListReq.__index = TGetPendingFirmwareListReq
TGetPendingFirmwareListReq.group = {}

local function TGetPendingFirmwareListReq_from_obj(obj)
    return setmetatable(obj, TGetPendingFirmwareListReq)
end

function TGetPendingFirmwareListReq.new()
    return TGetPendingFirmwareListReq_from_obj({})
end
---@param obj UpdateService.GetPendingFirmwareListReq
function TGetPendingFirmwareListReq:init_from_obj(obj)

end

function TGetPendingFirmwareListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPendingFirmwareListReq.group)
end

TGetPendingFirmwareListReq.from_obj = TGetPendingFirmwareListReq_from_obj

TGetPendingFirmwareListReq.proto_property = {}

TGetPendingFirmwareListReq.default = {}

TGetPendingFirmwareListReq.struct = {}

function TGetPendingFirmwareListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPendingFirmwareListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPendingFirmwareListReq.proto_property, errs, need_convert)
    return self
end

function TGetPendingFirmwareListReq:unpack(_)
end

UpdateService.GetPendingFirmwareListReq = TGetPendingFirmwareListReq

---@class UpdateService.GetUpdateProgressRsp
---@field UpgradeMode string
---@field UpgradeTasks UpdateService.UpdateProgress[]
local TGetUpdateProgressRsp = {}
TGetUpdateProgressRsp.__index = TGetUpdateProgressRsp
TGetUpdateProgressRsp.group = {}

local function TGetUpdateProgressRsp_from_obj(obj)
    return setmetatable(obj, TGetUpdateProgressRsp)
end

function TGetUpdateProgressRsp.new(UpgradeMode, UpgradeTasks)
    return TGetUpdateProgressRsp_from_obj({UpgradeMode = UpgradeMode, UpgradeTasks = UpgradeTasks})
end
---@param obj UpdateService.GetUpdateProgressRsp
function TGetUpdateProgressRsp:init_from_obj(obj)
    self.UpgradeMode = obj.UpgradeMode
    self.UpgradeTasks = obj.UpgradeTasks
end

function TGetUpdateProgressRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpdateProgressRsp.group)
end

TGetUpdateProgressRsp.from_obj = TGetUpdateProgressRsp_from_obj

TGetUpdateProgressRsp.proto_property = {'UpgradeMode', 'UpgradeTasks'}

TGetUpdateProgressRsp.default = {'', {}}

TGetUpdateProgressRsp.struct = {
    {name = 'UpgradeMode', is_array = false, struct = nil},
    {name = 'UpgradeTasks', is_array = true, struct = UpdateService.UpdateProgress.struct}
}

function TGetUpdateProgressRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.UpgradeTasks) do
        UpdateService.UpdateProgress.new(v):validate(prefix, errs, need_convert)
    end

    validate.Optional(prefix .. 'UpgradeMode', self.UpgradeMode, 'string', false, errs, need_convert)

    TGetUpdateProgressRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpdateProgressRsp.proto_property, errs, need_convert)
    return self
end

function TGetUpdateProgressRsp:unpack(_)
    return self.UpgradeMode, self.UpgradeTasks
end

UpdateService.GetUpdateProgressRsp = TGetUpdateProgressRsp

---@class UpdateService.GetUpdateProgressReq
local TGetUpdateProgressReq = {}
TGetUpdateProgressReq.__index = TGetUpdateProgressReq
TGetUpdateProgressReq.group = {}

local function TGetUpdateProgressReq_from_obj(obj)
    return setmetatable(obj, TGetUpdateProgressReq)
end

function TGetUpdateProgressReq.new()
    return TGetUpdateProgressReq_from_obj({})
end
---@param obj UpdateService.GetUpdateProgressReq
function TGetUpdateProgressReq:init_from_obj(obj)

end

function TGetUpdateProgressReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpdateProgressReq.group)
end

TGetUpdateProgressReq.from_obj = TGetUpdateProgressReq_from_obj

TGetUpdateProgressReq.proto_property = {}

TGetUpdateProgressReq.default = {}

TGetUpdateProgressReq.struct = {}

function TGetUpdateProgressReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetUpdateProgressReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpdateProgressReq.proto_property, errs, need_convert)
    return self
end

function TGetUpdateProgressReq:unpack(_)
end

UpdateService.GetUpdateProgressReq = TGetUpdateProgressReq

---@class UpdateService.GetUpgradeStatusRsp
---@field FirmwareType string
---@field ResultCode integer
---@field Progress integer
---@field ResultDetail string
local TGetUpgradeStatusRsp = {}
TGetUpgradeStatusRsp.__index = TGetUpgradeStatusRsp
TGetUpgradeStatusRsp.group = {}

local function TGetUpgradeStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetUpgradeStatusRsp)
end

function TGetUpgradeStatusRsp.new(FirmwareType, ResultCode, Progress, ResultDetail)
    return TGetUpgradeStatusRsp_from_obj({
        FirmwareType = FirmwareType,
        ResultCode = ResultCode,
        Progress = Progress,
        ResultDetail = ResultDetail
    })
end
---@param obj UpdateService.GetUpgradeStatusRsp
function TGetUpgradeStatusRsp:init_from_obj(obj)
    self.FirmwareType = obj.FirmwareType
    self.ResultCode = obj.ResultCode
    self.Progress = obj.Progress
    self.ResultDetail = obj.ResultDetail
end

function TGetUpgradeStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpgradeStatusRsp.group)
end

TGetUpgradeStatusRsp.from_obj = TGetUpgradeStatusRsp_from_obj

TGetUpgradeStatusRsp.proto_property = {'FirmwareType', 'ResultCode', 'Progress', 'ResultDetail'}

TGetUpgradeStatusRsp.default = {'', 0, 0, ''}

TGetUpgradeStatusRsp.struct = {
    {name = 'FirmwareType', is_array = false, struct = nil}, {name = 'ResultCode', is_array = false, struct = nil},
    {name = 'Progress', is_array = false, struct = nil}, {name = 'ResultDetail', is_array = false, struct = nil}
}

function TGetUpgradeStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ResultCode', self.ResultCode, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Progress', self.Progress, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'ResultDetail', self.ResultDetail, 'string', false, errs, need_convert)

    if self.Progress ~= nil then
        validate.ranges(prefix .. 'Progress', self.Progress, 0, 100, errs, need_convert)
    end
    if self.ResultDetail ~= nil then
        validate.lens(prefix .. 'ResultDetail', self.ResultDetail, nil, 512, errs, need_convert)
    end

    TGetUpgradeStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpgradeStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetUpgradeStatusRsp:unpack(_)
    return self.FirmwareType, self.ResultCode, self.Progress, self.ResultDetail
end

UpdateService.GetUpgradeStatusRsp = TGetUpgradeStatusRsp

---@class UpdateService.GetUpgradeStatusReq
---@field TaskId integer
local TGetUpgradeStatusReq = {}
TGetUpgradeStatusReq.__index = TGetUpgradeStatusReq
TGetUpgradeStatusReq.group = {}

local function TGetUpgradeStatusReq_from_obj(obj)
    return setmetatable(obj, TGetUpgradeStatusReq)
end

function TGetUpgradeStatusReq.new(TaskId)
    return TGetUpgradeStatusReq_from_obj({TaskId = TaskId})
end
---@param obj UpdateService.GetUpgradeStatusReq
function TGetUpgradeStatusReq:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TGetUpgradeStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetUpgradeStatusReq.group)
end

TGetUpgradeStatusReq.from_obj = TGetUpgradeStatusReq_from_obj

TGetUpgradeStatusReq.proto_property = {'TaskId'}

TGetUpgradeStatusReq.default = {0}

TGetUpgradeStatusReq.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TGetUpgradeStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TGetUpgradeStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetUpgradeStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetUpgradeStatusReq:unpack(_)
    return self.TaskId
end

UpdateService.GetUpgradeStatusReq = TGetUpgradeStatusReq

---@class UpdateService.UpdateUpgradeStatusRsp
local TUpdateUpgradeStatusRsp = {}
TUpdateUpgradeStatusRsp.__index = TUpdateUpgradeStatusRsp
TUpdateUpgradeStatusRsp.group = {}

local function TUpdateUpgradeStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdateUpgradeStatusRsp)
end

function TUpdateUpgradeStatusRsp.new()
    return TUpdateUpgradeStatusRsp_from_obj({})
end
---@param obj UpdateService.UpdateUpgradeStatusRsp
function TUpdateUpgradeStatusRsp:init_from_obj(obj)

end

function TUpdateUpgradeStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateUpgradeStatusRsp.group)
end

TUpdateUpgradeStatusRsp.from_obj = TUpdateUpgradeStatusRsp_from_obj

TUpdateUpgradeStatusRsp.proto_property = {}

TUpdateUpgradeStatusRsp.default = {}

TUpdateUpgradeStatusRsp.struct = {}

function TUpdateUpgradeStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TUpdateUpgradeStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateUpgradeStatusRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateUpgradeStatusRsp:unpack(_)
end

UpdateService.UpdateUpgradeStatusRsp = TUpdateUpgradeStatusRsp

---@class UpdateService.UpdateUpgradeStatusReq
---@field SystemId integer
---@field FirmwareType string
---@field ResultCode integer
---@field Progress integer
---@field ResultDetail string
---@field AdditionalOptions UpdateService.Object
local TUpdateUpgradeStatusReq = {}
TUpdateUpgradeStatusReq.__index = TUpdateUpgradeStatusReq
TUpdateUpgradeStatusReq.group = {}

local function TUpdateUpgradeStatusReq_from_obj(obj)
    return setmetatable(obj, TUpdateUpgradeStatusReq)
end

function TUpdateUpgradeStatusReq.new(SystemId, FirmwareType, ResultCode, Progress, ResultDetail, AdditionalOptions)
    return TUpdateUpgradeStatusReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ResultCode = ResultCode,
        Progress = Progress,
        ResultDetail = ResultDetail,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.UpdateUpgradeStatusReq
function TUpdateUpgradeStatusReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ResultCode = obj.ResultCode
    self.Progress = obj.Progress
    self.ResultDetail = obj.ResultDetail
    self.AdditionalOptions = obj.AdditionalOptions
end

function TUpdateUpgradeStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateUpgradeStatusReq.group)
end

TUpdateUpgradeStatusReq.from_obj = TUpdateUpgradeStatusReq_from_obj

TUpdateUpgradeStatusReq.proto_property = {
    'SystemId', 'FirmwareType', 'ResultCode', 'Progress', 'ResultDetail', 'AdditionalOptions'
}

TUpdateUpgradeStatusReq.default = {0, '', 0, 0, '', UpdateService.Object.default}

TUpdateUpgradeStatusReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ResultCode', is_array = false, struct = nil}, {name = 'Progress', is_array = false, struct = nil},
    {name = 'ResultDetail', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TUpdateUpgradeStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ResultCode', self.ResultCode, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Progress', self.Progress, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'ResultDetail', self.ResultDetail, 'string', false, errs, need_convert)

    if self.Progress ~= nil then
        validate.ranges(prefix .. 'Progress', self.Progress, 0, 100, errs, need_convert)
    end
    if self.ResultDetail ~= nil then
        validate.lens(prefix .. 'ResultDetail', self.ResultDetail, nil, 512, errs, need_convert)
    end

    TUpdateUpgradeStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateUpgradeStatusReq.proto_property, errs, need_convert)
    return self
end

function TUpdateUpgradeStatusReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ResultCode, self.Progress, self.ResultDetail, self.AdditionalOptions
end

UpdateService.UpdateUpgradeStatusReq = TUpdateUpgradeStatusReq

---@class UpdateService.FinishReplyRsp
local TFinishReplyRsp = {}
TFinishReplyRsp.__index = TFinishReplyRsp
TFinishReplyRsp.group = {}

local function TFinishReplyRsp_from_obj(obj)
    return setmetatable(obj, TFinishReplyRsp)
end

function TFinishReplyRsp.new()
    return TFinishReplyRsp_from_obj({})
end
---@param obj UpdateService.FinishReplyRsp
function TFinishReplyRsp:init_from_obj(obj)

end

function TFinishReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFinishReplyRsp.group)
end

TFinishReplyRsp.from_obj = TFinishReplyRsp_from_obj

TFinishReplyRsp.proto_property = {}

TFinishReplyRsp.default = {}

TFinishReplyRsp.struct = {}

function TFinishReplyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TFinishReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFinishReplyRsp.proto_property, errs, need_convert)
    return self
end

function TFinishReplyRsp:unpack(_)
end

UpdateService.FinishReplyRsp = TFinishReplyRsp

---@class UpdateService.FinishReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field FinishResult integer
---@field AdditionalOptions UpdateService.Object
local TFinishReplyReq = {}
TFinishReplyReq.__index = TFinishReplyReq
TFinishReplyReq.group = {}

local function TFinishReplyReq_from_obj(obj)
    return setmetatable(obj, TFinishReplyReq)
end

function TFinishReplyReq.new(SystemId, FirmwareType, FinishResult, AdditionalOptions)
    return TFinishReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        FinishResult = FinishResult,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.FinishReplyReq
function TFinishReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.FinishResult = obj.FinishResult
    self.AdditionalOptions = obj.AdditionalOptions
end

function TFinishReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFinishReplyReq.group)
end

TFinishReplyReq.from_obj = TFinishReplyReq_from_obj

TFinishReplyReq.proto_property = {'SystemId', 'FirmwareType', 'FinishResult', 'AdditionalOptions'}

TFinishReplyReq.default = {0, '', 0, UpdateService.Object.default}

TFinishReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FinishResult', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TFinishReplyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FinishResult', self.FinishResult, 'int32', false, errs, need_convert)

    TFinishReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFinishReplyReq.proto_property, errs, need_convert)
    return self
end

function TFinishReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.FinishResult, self.AdditionalOptions
end

UpdateService.FinishReplyReq = TFinishReplyReq

---@class UpdateService.ProcessReplyRsp
local TProcessReplyRsp = {}
TProcessReplyRsp.__index = TProcessReplyRsp
TProcessReplyRsp.group = {}

local function TProcessReplyRsp_from_obj(obj)
    return setmetatable(obj, TProcessReplyRsp)
end

function TProcessReplyRsp.new()
    return TProcessReplyRsp_from_obj({})
end
---@param obj UpdateService.ProcessReplyRsp
function TProcessReplyRsp:init_from_obj(obj)

end

function TProcessReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessReplyRsp.group)
end

TProcessReplyRsp.from_obj = TProcessReplyRsp_from_obj

TProcessReplyRsp.proto_property = {}

TProcessReplyRsp.default = {}

TProcessReplyRsp.struct = {}

function TProcessReplyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TProcessReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessReplyRsp.proto_property, errs, need_convert)
    return self
end

function TProcessReplyRsp:unpack(_)
end

UpdateService.ProcessReplyRsp = TProcessReplyRsp

---@class UpdateService.ProcessReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field ProcessResult integer
---@field AdditionalOptions UpdateService.Object
local TProcessReplyReq = {}
TProcessReplyReq.__index = TProcessReplyReq
TProcessReplyReq.group = {}

local function TProcessReplyReq_from_obj(obj)
    return setmetatable(obj, TProcessReplyReq)
end

function TProcessReplyReq.new(SystemId, FirmwareType, ProcessResult, AdditionalOptions)
    return TProcessReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ProcessResult = ProcessResult,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.ProcessReplyReq
function TProcessReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ProcessResult = obj.ProcessResult
    self.AdditionalOptions = obj.AdditionalOptions
end

function TProcessReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessReplyReq.group)
end

TProcessReplyReq.from_obj = TProcessReplyReq_from_obj

TProcessReplyReq.proto_property = {'SystemId', 'FirmwareType', 'ProcessResult', 'AdditionalOptions'}

TProcessReplyReq.default = {0, '', 0, UpdateService.Object.default}

TProcessReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ProcessResult', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TProcessReplyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'ProcessResult', self.ProcessResult, 'int32', false, errs, need_convert)

    TProcessReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessReplyReq.proto_property, errs, need_convert)
    return self
end

function TProcessReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ProcessResult, self.AdditionalOptions
end

UpdateService.ProcessReplyReq = TProcessReplyReq

---@class UpdateService.PrepareReplyRsp
local TPrepareReplyRsp = {}
TPrepareReplyRsp.__index = TPrepareReplyRsp
TPrepareReplyRsp.group = {}

local function TPrepareReplyRsp_from_obj(obj)
    return setmetatable(obj, TPrepareReplyRsp)
end

function TPrepareReplyRsp.new()
    return TPrepareReplyRsp_from_obj({})
end
---@param obj UpdateService.PrepareReplyRsp
function TPrepareReplyRsp:init_from_obj(obj)

end

function TPrepareReplyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareReplyRsp.group)
end

TPrepareReplyRsp.from_obj = TPrepareReplyRsp_from_obj

TPrepareReplyRsp.proto_property = {}

TPrepareReplyRsp.default = {}

TPrepareReplyRsp.struct = {}

function TPrepareReplyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPrepareReplyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareReplyRsp.proto_property, errs, need_convert)
    return self
end

function TPrepareReplyRsp:unpack(_)
end

UpdateService.PrepareReplyRsp = TPrepareReplyRsp

---@class UpdateService.PrepareReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field VersionStr string
---@field PrepareResult integer
---@field AdditionalOptions UpdateService.Object
local TPrepareReplyReq = {}
TPrepareReplyReq.__index = TPrepareReplyReq
TPrepareReplyReq.group = {}

local function TPrepareReplyReq_from_obj(obj)
    return setmetatable(obj, TPrepareReplyReq)
end

function TPrepareReplyReq.new(SystemId, FirmwareType, VersionStr, PrepareResult, AdditionalOptions)
    return TPrepareReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        VersionStr = VersionStr,
        PrepareResult = PrepareResult,
        AdditionalOptions = AdditionalOptions
    })
end
---@param obj UpdateService.PrepareReplyReq
function TPrepareReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.VersionStr = obj.VersionStr
    self.PrepareResult = obj.PrepareResult
    self.AdditionalOptions = obj.AdditionalOptions
end

function TPrepareReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrepareReplyReq.group)
end

TPrepareReplyReq.from_obj = TPrepareReplyReq_from_obj

TPrepareReplyReq.proto_property = {'SystemId', 'FirmwareType', 'VersionStr', 'PrepareResult', 'AdditionalOptions'}

TPrepareReplyReq.default = {0, '', '', 0, UpdateService.Object.default}

TPrepareReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'VersionStr', is_array = false, struct = nil}, {name = 'PrepareResult', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TPrepareReplyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'VersionStr', self.VersionStr, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'PrepareResult', self.PrepareResult, 'int32', false, errs, need_convert)

    TPrepareReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrepareReplyReq.proto_property, errs, need_convert)
    return self
end

function TPrepareReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.VersionStr, self.PrepareResult, self.AdditionalOptions
end

UpdateService.PrepareReplyReq = TPrepareReplyReq

---@class UpdateService.ParallelUpdateRsp
---@field TaskId integer
---@field SubTaskIds integer[]
local TParallelUpdateRsp = {}
TParallelUpdateRsp.__index = TParallelUpdateRsp
TParallelUpdateRsp.group = {}

local function TParallelUpdateRsp_from_obj(obj)
    return setmetatable(obj, TParallelUpdateRsp)
end

function TParallelUpdateRsp.new(TaskId, SubTaskIds)
    return TParallelUpdateRsp_from_obj({TaskId = TaskId, SubTaskIds = SubTaskIds})
end
---@param obj UpdateService.ParallelUpdateRsp
function TParallelUpdateRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
    self.SubTaskIds = obj.SubTaskIds
end

function TParallelUpdateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParallelUpdateRsp.group)
end

TParallelUpdateRsp.from_obj = TParallelUpdateRsp_from_obj

TParallelUpdateRsp.proto_property = {'TaskId', 'SubTaskIds'}

TParallelUpdateRsp.default = {0, {}}

TParallelUpdateRsp.struct = {
    {name = 'TaskId', is_array = false, struct = nil}, {name = 'SubTaskIds', is_array = true, struct = nil}
}

function TParallelUpdateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'SubTaskIds', self.SubTaskIds, 'uint32', false, errs, need_convert)

    TParallelUpdateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParallelUpdateRsp.proto_property, errs, need_convert)
    return self
end

function TParallelUpdateRsp:unpack(_)
    return self.TaskId, self.SubTaskIds
end

UpdateService.ParallelUpdateRsp = TParallelUpdateRsp

---@class UpdateService.ParallelUpdateReq
---@field UpgradeOptions UpdateService.Object
---@field Packages UpdateService.ParallelUpgradePackages[]
local TParallelUpdateReq = {}
TParallelUpdateReq.__index = TParallelUpdateReq
TParallelUpdateReq.group = {}

local function TParallelUpdateReq_from_obj(obj)
    obj.Packages = utils.from_obj(UpdateService.ParallelUpgradePackages, obj.Packages, true)
    return setmetatable(obj, TParallelUpdateReq)
end

function TParallelUpdateReq.new(UpgradeOptions, Packages)
    return TParallelUpdateReq_from_obj({UpgradeOptions = UpgradeOptions, Packages = Packages})
end
---@param obj UpdateService.ParallelUpdateReq
function TParallelUpdateReq:init_from_obj(obj)
    self.UpgradeOptions = obj.UpgradeOptions
    self.Packages = obj.Packages
end

function TParallelUpdateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParallelUpdateReq.group)
end

TParallelUpdateReq.from_obj = TParallelUpdateReq_from_obj

TParallelUpdateReq.proto_property = {'UpgradeOptions', 'Packages'}

TParallelUpdateReq.default = {UpdateService.Object.default, {}}

TParallelUpdateReq.struct = {
    {name = 'UpgradeOptions', is_array = false, struct = UpdateService.Object.struct},
    {name = 'Packages', is_array = true, struct = UpdateService.ParallelUpgradePackages.struct}
}

function TParallelUpdateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.UpgradeOptions):validate(prefix, errs, need_convert)
    for _, v in pairs(self.Packages) do
        UpdateService.ParallelUpgradePackages.new(v.FilePath, v.AdditionalOptions):validate(prefix, errs, need_convert)
    end

    TParallelUpdateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParallelUpdateReq.proto_property, errs, need_convert)
    return self
end

function TParallelUpdateReq:unpack(raw)
    return self.UpgradeOptions, utils.unpack(raw, self.Packages, true)
end

UpdateService.ParallelUpdateReq = TParallelUpdateReq

---@class UpdateService.StartUpgradeRsp
---@field TaskId integer
local TStartUpgradeRsp = {}
TStartUpgradeRsp.__index = TStartUpgradeRsp
TStartUpgradeRsp.group = {}

local function TStartUpgradeRsp_from_obj(obj)
    return setmetatable(obj, TStartUpgradeRsp)
end

function TStartUpgradeRsp.new(TaskId)
    return TStartUpgradeRsp_from_obj({TaskId = TaskId})
end
---@param obj UpdateService.StartUpgradeRsp
function TStartUpgradeRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TStartUpgradeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartUpgradeRsp.group)
end

TStartUpgradeRsp.from_obj = TStartUpgradeRsp_from_obj

TStartUpgradeRsp.proto_property = {'TaskId'}

TStartUpgradeRsp.default = {0}

TStartUpgradeRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TStartUpgradeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TStartUpgradeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartUpgradeRsp.proto_property, errs, need_convert)
    return self
end

function TStartUpgradeRsp:unpack(_)
    return self.TaskId
end

UpdateService.StartUpgradeRsp = TStartUpgradeRsp

---@class UpdateService.StartUpgradeReq
---@field FilePath string
---@field AdditionalOptions UpdateService.Object
local TStartUpgradeReq = {}
TStartUpgradeReq.__index = TStartUpgradeReq
TStartUpgradeReq.group = {}

local function TStartUpgradeReq_from_obj(obj)
    return setmetatable(obj, TStartUpgradeReq)
end

function TStartUpgradeReq.new(FilePath, AdditionalOptions)
    return TStartUpgradeReq_from_obj({FilePath = FilePath, AdditionalOptions = AdditionalOptions})
end
---@param obj UpdateService.StartUpgradeReq
function TStartUpgradeReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
    self.AdditionalOptions = obj.AdditionalOptions
end

function TStartUpgradeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartUpgradeReq.group)
end

TStartUpgradeReq.from_obj = TStartUpgradeReq_from_obj

TStartUpgradeReq.proto_property = {'FilePath', 'AdditionalOptions'}

TStartUpgradeReq.default = {'', UpdateService.Object.default}

TStartUpgradeReq.struct = {
    {name = 'FilePath', is_array = false, struct = nil},
    {name = 'AdditionalOptions', is_array = false, struct = UpdateService.Object.struct}
}

function TStartUpgradeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    UpdateService.Object.new(self.AdditionalOptions):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TStartUpgradeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartUpgradeReq.proto_property, errs, need_convert)
    return self
end

function TStartUpgradeReq:unpack(_)
    return self.FilePath, self.AdditionalOptions
end

UpdateService.StartUpgradeReq = TStartUpgradeReq

UpdateService.interface = mdb.register_interface('bmc.kepler.UpdateService', {
    UpgradeKeyDomainId = {'u', {}, true, nil, false},
    UpgradingFlag = {'b', nil, true, nil, false},
    ParallelSupported = {'b', nil, true, nil, false},
    UpgradeMode = {'s', {}, true, nil, false},
    TimeoutPolicy = {'y', {}, true, nil, false}
}, {
    StartUpgrade = {'a{ss}sa{ss}', 'u', TStartUpgradeReq, TStartUpgradeRsp},
    ParallelUpdate = {'a{ss}a{ss}a(sa{ss})', 'uau', TParallelUpdateReq, TParallelUpdateRsp},
    PrepareReply = {'a{ss}issia{ss}', '', TPrepareReplyReq, TPrepareReplyRsp},
    ProcessReply = {'a{ss}isia{ss}', '', TProcessReplyReq, TProcessReplyRsp},
    FinishReply = {'a{ss}isia{ss}', '', TFinishReplyReq, TFinishReplyRsp},
    UpdateUpgradeStatus = {'a{ss}isiisa{ss}', '', TUpdateUpgradeStatusReq, TUpdateUpgradeStatusRsp},
    GetUpgradeStatus = {'a{ss}u', 'siis', TGetUpgradeStatusReq, TGetUpgradeStatusRsp},
    GetUpdateProgress = {'a{ss}', 'saa{ss}', TGetUpdateProgressReq, TGetUpdateProgressRsp},
    GetPendingFirmwareList = {'a{ss}', 'a(yssss)', TGetPendingFirmwareListReq, TGetPendingFirmwareListRsp},
    Rollback = {'a{ss}is', '', TRollbackReq, TRollbackRsp},
    Export = {'a{ss}is', '', TExportReq, TExportRsp},
    CheckFirmwareType = {'a{ss}ss', 'b', TCheckFirmwareTypeReq, TCheckFirmwareTypeRsp},
    ParseFirmwarePackage = {'a{ss}s', 'ss', TParseFirmwarePackageReq, TParseFirmwarePackageRsp}
}, {
    UpgradePrepareSignal = 'a{ss}isssa{ss}',
    UpgradeProcessSignal = 'a{ss}issa{ss}',
    UpgradeFinishSignal = 'a{ss}isa{ss}',
    RollbackSignal = 'a{ss}is',
    ExportSignal = 'a{ss}is'
})

return UpdateService
