-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OutputControl = {}

---@class OutputControl.OutputPowerLimitWatts
---@field OutputPowerLimitWatts integer
local TOutputPowerLimitWatts = {}
TOutputPowerLimitWatts.__index = TOutputPowerLimitWatts
TOutputPowerLimitWatts.group = {}

local function TOutputPowerLimitWatts_from_obj(obj)
    return setmetatable(obj, TOutputPowerLimitWatts)
end

function TOutputPowerLimitWatts.new(OutputPowerLimitWatts)
    return TOutputPowerLimitWatts_from_obj({OutputPowerLimitWatts = OutputPowerLimitWatts})
end
---@param obj OutputControl.OutputPowerLimitWatts
function TOutputPowerLimitWatts:init_from_obj(obj)
    self.OutputPowerLimitWatts = obj.OutputPowerLimitWatts
end

function TOutputPowerLimitWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerLimitWatts.group)
end

TOutputPowerLimitWatts.from_obj = TOutputPowerLimitWatts_from_obj

TOutputPowerLimitWatts.proto_property = {'OutputPowerLimitWatts'}

TOutputPowerLimitWatts.default = {0}

TOutputPowerLimitWatts.struct = {{name = 'OutputPowerLimitWatts', is_array = false, struct = nil}}

function TOutputPowerLimitWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerLimitWatts', self.OutputPowerLimitWatts, 'uint32', true, errs, need_convert)

    TOutputPowerLimitWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerLimitWatts.proto_property, errs, need_convert)
    return self
end

function TOutputPowerLimitWatts:unpack(_)
    return self.OutputPowerLimitWatts
end

OutputControl.OutputPowerLimitWatts = TOutputPowerLimitWatts

---@class OutputControl.SetOutputPowerLimitWattsRsp
local TSetOutputPowerLimitWattsRsp = {}
TSetOutputPowerLimitWattsRsp.__index = TSetOutputPowerLimitWattsRsp
TSetOutputPowerLimitWattsRsp.group = {}

local function TSetOutputPowerLimitWattsRsp_from_obj(obj)
    return setmetatable(obj, TSetOutputPowerLimitWattsRsp)
end

function TSetOutputPowerLimitWattsRsp.new()
    return TSetOutputPowerLimitWattsRsp_from_obj({})
end
---@param obj OutputControl.SetOutputPowerLimitWattsRsp
function TSetOutputPowerLimitWattsRsp:init_from_obj(obj)

end

function TSetOutputPowerLimitWattsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOutputPowerLimitWattsRsp.group)
end

TSetOutputPowerLimitWattsRsp.from_obj = TSetOutputPowerLimitWattsRsp_from_obj

TSetOutputPowerLimitWattsRsp.proto_property = {}

TSetOutputPowerLimitWattsRsp.default = {}

TSetOutputPowerLimitWattsRsp.struct = {}

function TSetOutputPowerLimitWattsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetOutputPowerLimitWattsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOutputPowerLimitWattsRsp.proto_property, errs, need_convert)
    return self
end

function TSetOutputPowerLimitWattsRsp:unpack(_)
end

OutputControl.SetOutputPowerLimitWattsRsp = TSetOutputPowerLimitWattsRsp

---@class OutputControl.SetOutputPowerLimitWattsReq
---@field OutputPowerLimitWatts integer
local TSetOutputPowerLimitWattsReq = {}
TSetOutputPowerLimitWattsReq.__index = TSetOutputPowerLimitWattsReq
TSetOutputPowerLimitWattsReq.group = {}

local function TSetOutputPowerLimitWattsReq_from_obj(obj)
    return setmetatable(obj, TSetOutputPowerLimitWattsReq)
end

function TSetOutputPowerLimitWattsReq.new(OutputPowerLimitWatts)
    return TSetOutputPowerLimitWattsReq_from_obj({OutputPowerLimitWatts = OutputPowerLimitWatts})
end
---@param obj OutputControl.SetOutputPowerLimitWattsReq
function TSetOutputPowerLimitWattsReq:init_from_obj(obj)
    self.OutputPowerLimitWatts = obj.OutputPowerLimitWatts
end

function TSetOutputPowerLimitWattsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOutputPowerLimitWattsReq.group)
end

TSetOutputPowerLimitWattsReq.from_obj = TSetOutputPowerLimitWattsReq_from_obj

TSetOutputPowerLimitWattsReq.proto_property = {'OutputPowerLimitWatts'}

TSetOutputPowerLimitWattsReq.default = {0}

TSetOutputPowerLimitWattsReq.struct = {{name = 'OutputPowerLimitWatts', is_array = false, struct = nil}}

function TSetOutputPowerLimitWattsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerLimitWatts', 
        self.OutputPowerLimitWatts, 'uint32', false, errs, need_convert)

    TSetOutputPowerLimitWattsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOutputPowerLimitWattsReq.proto_property, errs, need_convert)
    return self
end

function TSetOutputPowerLimitWattsReq:unpack(_)
    return self.OutputPowerLimitWatts
end

OutputControl.SetOutputPowerLimitWattsReq = TSetOutputPowerLimitWattsReq

OutputControl.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.PowerSupply.OutputControl',
    {OutputPowerLimitWatts = {'u', {}, true, nil, false}}, {
        SetOutputPowerLimitWatts = {'a{ss}u', '', TSetOutputPowerLimitWattsReq, TSetOutputPowerLimitWattsRsp}
    }, {})

return OutputControl
