-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Collector = {}

---@class Collector.GetRegisterValueRsp
---@field OutData integer[]
local TGetRegisterValueRsp = {}
TGetRegisterValueRsp.__index = TGetRegisterValueRsp
TGetRegisterValueRsp.group = {}

local function TGetRegisterValueRsp_from_obj(obj)
    return setmetatable(obj, TGetRegisterValueRsp)
end

function TGetRegisterValueRsp.new(OutData)
    return TGetRegisterValueRsp_from_obj({OutData = OutData})
end
---@param obj Collector.GetRegisterValueRsp
function TGetRegisterValueRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TGetRegisterValueRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRegisterValueRsp.group)
end

TGetRegisterValueRsp.from_obj = TGetRegisterValueRsp_from_obj

TGetRegisterValueRsp.proto_property = {'OutData'}

TGetRegisterValueRsp.default = {{}}

TGetRegisterValueRsp.struct = {{name = 'OutData', is_array = true, struct = nil}}

function TGetRegisterValueRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OutData', self.OutData, 'uint8', false, errs, need_convert)

    TGetRegisterValueRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRegisterValueRsp.proto_property, errs, need_convert)
    return self
end

function TGetRegisterValueRsp:unpack(_)
    return self.OutData
end

Collector.GetRegisterValueRsp = TGetRegisterValueRsp

---@class Collector.GetRegisterValueReq
---@field Cmd integer
---@field Length integer
local TGetRegisterValueReq = {}
TGetRegisterValueReq.__index = TGetRegisterValueReq
TGetRegisterValueReq.group = {}

local function TGetRegisterValueReq_from_obj(obj)
    return setmetatable(obj, TGetRegisterValueReq)
end

function TGetRegisterValueReq.new(Cmd, Length)
    return TGetRegisterValueReq_from_obj({Cmd = Cmd, Length = Length})
end
---@param obj Collector.GetRegisterValueReq
function TGetRegisterValueReq:init_from_obj(obj)
    self.Cmd = obj.Cmd
    self.Length = obj.Length
end

function TGetRegisterValueReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRegisterValueReq.group)
end

TGetRegisterValueReq.from_obj = TGetRegisterValueReq_from_obj

TGetRegisterValueReq.proto_property = {'Cmd', 'Length'}

TGetRegisterValueReq.default = {0, 0}

TGetRegisterValueReq.descriptions = {[=[PSU register address.]=], [=[Read length.]=]}

TGetRegisterValueReq.struct = {
    {name = 'Cmd', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetRegisterValueReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cmd', self.Cmd, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint32', false, errs, need_convert)

    TGetRegisterValueReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRegisterValueReq.proto_property, errs, need_convert)
    return self
end

function TGetRegisterValueReq:unpack(_)
    return self.Cmd, self.Length
end

Collector.GetRegisterValueReq = TGetRegisterValueReq

---@class Collector.GetFanSpeedRsp
---@field FanSpeed integer
local TGetFanSpeedRsp = {}
TGetFanSpeedRsp.__index = TGetFanSpeedRsp
TGetFanSpeedRsp.group = {}

local function TGetFanSpeedRsp_from_obj(obj)
    return setmetatable(obj, TGetFanSpeedRsp)
end

function TGetFanSpeedRsp.new(FanSpeed)
    return TGetFanSpeedRsp_from_obj({FanSpeed = FanSpeed})
end
---@param obj Collector.GetFanSpeedRsp
function TGetFanSpeedRsp:init_from_obj(obj)
    self.FanSpeed = obj.FanSpeed
end

function TGetFanSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpeedRsp.group)
end

TGetFanSpeedRsp.from_obj = TGetFanSpeedRsp_from_obj

TGetFanSpeedRsp.proto_property = {'FanSpeed'}

TGetFanSpeedRsp.default = {0}

TGetFanSpeedRsp.struct = {{name = 'FanSpeed', is_array = false, struct = nil}}

function TGetFanSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanSpeed', self.FanSpeed, 'uint16', false, errs, need_convert)

    TGetFanSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TGetFanSpeedRsp:unpack(_)
    return self.FanSpeed
end

Collector.GetFanSpeedRsp = TGetFanSpeedRsp

---@class Collector.GetFanSpeedReq
local TGetFanSpeedReq = {}
TGetFanSpeedReq.__index = TGetFanSpeedReq
TGetFanSpeedReq.group = {}

local function TGetFanSpeedReq_from_obj(obj)
    return setmetatable(obj, TGetFanSpeedReq)
end

function TGetFanSpeedReq.new()
    return TGetFanSpeedReq_from_obj({})
end
---@param obj Collector.GetFanSpeedReq
function TGetFanSpeedReq:init_from_obj(obj)

end

function TGetFanSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpeedReq.group)
end

TGetFanSpeedReq.from_obj = TGetFanSpeedReq_from_obj

TGetFanSpeedReq.proto_property = {}

TGetFanSpeedReq.default = {}

TGetFanSpeedReq.struct = {}

function TGetFanSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetFanSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpeedReq.proto_property, errs, need_convert)
    return self
end

function TGetFanSpeedReq:unpack(_)
end

Collector.GetFanSpeedReq = TGetFanSpeedReq

Collector.interface = mdb.register_interface('bmc.kepler.Release.OnePower.Collector', {}, {
    GetFanSpeed = {
        'a{ss}', 'q', TGetFanSpeedReq, TGetFanSpeedRsp,
        [=[Get PSU fan speed. For example: getpsufanspeed OnePower_0_010109]=]
    },
    GetRegisterValue = {
        'a{ss}uu', 'ay', TGetRegisterValueReq, TGetRegisterValueRsp,
        [=[Get PSU register value. For example: getpsureg OnePower_0_010109 144 2]=]
    }
}, {})

return Collector
