-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Capacitor = {}

---@class Capacitor.DepthOfDischargeVolts
---@field DepthOfDischargeVolts integer
local TDepthOfDischargeVolts = {}
TDepthOfDischargeVolts.__index = TDepthOfDischargeVolts
TDepthOfDischargeVolts.group = {}

local function TDepthOfDischargeVolts_from_obj(obj)
    return setmetatable(obj, TDepthOfDischargeVolts)
end

function TDepthOfDischargeVolts.new(DepthOfDischargeVolts)
    return TDepthOfDischargeVolts_from_obj({DepthOfDischargeVolts = DepthOfDischargeVolts})
end
---@param obj Capacitor.DepthOfDischargeVolts
function TDepthOfDischargeVolts:init_from_obj(obj)
    self.DepthOfDischargeVolts = obj.DepthOfDischargeVolts
end

function TDepthOfDischargeVolts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDepthOfDischargeVolts.group)
end

TDepthOfDischargeVolts.from_obj = TDepthOfDischargeVolts_from_obj

TDepthOfDischargeVolts.proto_property = {'DepthOfDischargeVolts'}

TDepthOfDischargeVolts.default = {0}

TDepthOfDischargeVolts.struct = {{name = 'DepthOfDischargeVolts', is_array = false, struct = nil}}

function TDepthOfDischargeVolts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DepthOfDischargeVolts', self.DepthOfDischargeVolts, 'uint32', true, errs, need_convert)

    TDepthOfDischargeVolts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDepthOfDischargeVolts.proto_property, errs, need_convert)
    return self
end

function TDepthOfDischargeVolts:unpack(_)
    return self.DepthOfDischargeVolts
end

Capacitor.DepthOfDischargeVolts = TDepthOfDischargeVolts

---@class Capacitor.VOUTDebounceMilliseconds
---@field VOUTDebounceMilliseconds integer
local TVOUTDebounceMilliseconds = {}
TVOUTDebounceMilliseconds.__index = TVOUTDebounceMilliseconds
TVOUTDebounceMilliseconds.group = {}

local function TVOUTDebounceMilliseconds_from_obj(obj)
    return setmetatable(obj, TVOUTDebounceMilliseconds)
end

function TVOUTDebounceMilliseconds.new(VOUTDebounceMilliseconds)
    return TVOUTDebounceMilliseconds_from_obj({VOUTDebounceMilliseconds = VOUTDebounceMilliseconds})
end
---@param obj Capacitor.VOUTDebounceMilliseconds
function TVOUTDebounceMilliseconds:init_from_obj(obj)
    self.VOUTDebounceMilliseconds = obj.VOUTDebounceMilliseconds
end

function TVOUTDebounceMilliseconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVOUTDebounceMilliseconds.group)
end

TVOUTDebounceMilliseconds.from_obj = TVOUTDebounceMilliseconds_from_obj

TVOUTDebounceMilliseconds.proto_property = {'VOUTDebounceMilliseconds'}

TVOUTDebounceMilliseconds.default = {0}

TVOUTDebounceMilliseconds.struct = {{name = 'VOUTDebounceMilliseconds', is_array = false, struct = nil}}

function TVOUTDebounceMilliseconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VOUTDebounceMilliseconds', self.VOUTDebounceMilliseconds, 'uint32', true, errs,
        need_convert)

    TVOUTDebounceMilliseconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVOUTDebounceMilliseconds.proto_property, errs, need_convert)
    return self
end

function TVOUTDebounceMilliseconds:unpack(_)
    return self.VOUTDebounceMilliseconds
end

Capacitor.VOUTDebounceMilliseconds = TVOUTDebounceMilliseconds

---@class Capacitor.PowerState
---@field PowerState string
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState or [=[N/A]=]})
end
---@param obj Capacitor.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState or [=[N/A]=]
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {''}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'string', true, errs, need_convert)

    if self.PowerState ~= nil then
        validate.Enum(prefix .. 'PowerState', self.PowerState, '', {'On', 'Off', 'N/A'}, errs, need_convert)
    end

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

Capacitor.PowerState = TPowerState

---@class Capacitor.HardwareVersion
---@field HardwareVersion string
local THardwareVersion = {}
THardwareVersion.__index = THardwareVersion
THardwareVersion.group = {}

local function THardwareVersion_from_obj(obj)
    return setmetatable(obj, THardwareVersion)
end

function THardwareVersion.new(HardwareVersion)
    return THardwareVersion_from_obj({HardwareVersion = HardwareVersion})
end
---@param obj Capacitor.HardwareVersion
function THardwareVersion:init_from_obj(obj)
    self.HardwareVersion = obj.HardwareVersion
end

function THardwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THardwareVersion.group)
end

THardwareVersion.from_obj = THardwareVersion_from_obj

THardwareVersion.proto_property = {'HardwareVersion'}

THardwareVersion.default = {''}

THardwareVersion.struct = {{name = 'HardwareVersion', is_array = false, struct = nil}}

function THardwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HardwareVersion', self.HardwareVersion, 'string', true, errs, need_convert)

    THardwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THardwareVersion.proto_property, errs, need_convert)
    return self
end

function THardwareVersion:unpack(_)
    return self.HardwareVersion
end

Capacitor.HardwareVersion = THardwareVersion

---@class Capacitor.SetDepthOfDischargeVoltsRsp
local TSetDepthOfDischargeVoltsRsp = {}
TSetDepthOfDischargeVoltsRsp.__index = TSetDepthOfDischargeVoltsRsp
TSetDepthOfDischargeVoltsRsp.group = {}

local function TSetDepthOfDischargeVoltsRsp_from_obj(obj)
    return setmetatable(obj, TSetDepthOfDischargeVoltsRsp)
end

function TSetDepthOfDischargeVoltsRsp.new()
    return TSetDepthOfDischargeVoltsRsp_from_obj({})
end
---@param obj Capacitor.SetDepthOfDischargeVoltsRsp
function TSetDepthOfDischargeVoltsRsp:init_from_obj(obj)

end

function TSetDepthOfDischargeVoltsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDepthOfDischargeVoltsRsp.group)
end

TSetDepthOfDischargeVoltsRsp.from_obj = TSetDepthOfDischargeVoltsRsp_from_obj

TSetDepthOfDischargeVoltsRsp.proto_property = {}

TSetDepthOfDischargeVoltsRsp.default = {}

TSetDepthOfDischargeVoltsRsp.struct = {}

function TSetDepthOfDischargeVoltsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDepthOfDischargeVoltsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDepthOfDischargeVoltsRsp.proto_property, errs, need_convert)
    return self
end

function TSetDepthOfDischargeVoltsRsp:unpack(_)
end

Capacitor.SetDepthOfDischargeVoltsRsp = TSetDepthOfDischargeVoltsRsp

---@class Capacitor.SetDepthOfDischargeVoltsReq
---@field DepthOfDischargeVolts integer
local TSetDepthOfDischargeVoltsReq = {}
TSetDepthOfDischargeVoltsReq.__index = TSetDepthOfDischargeVoltsReq
TSetDepthOfDischargeVoltsReq.group = {}

local function TSetDepthOfDischargeVoltsReq_from_obj(obj)
    return setmetatable(obj, TSetDepthOfDischargeVoltsReq)
end

function TSetDepthOfDischargeVoltsReq.new(DepthOfDischargeVolts)
    return TSetDepthOfDischargeVoltsReq_from_obj({DepthOfDischargeVolts = DepthOfDischargeVolts})
end
---@param obj Capacitor.SetDepthOfDischargeVoltsReq
function TSetDepthOfDischargeVoltsReq:init_from_obj(obj)
    self.DepthOfDischargeVolts = obj.DepthOfDischargeVolts
end

function TSetDepthOfDischargeVoltsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDepthOfDischargeVoltsReq.group)
end

TSetDepthOfDischargeVoltsReq.from_obj = TSetDepthOfDischargeVoltsReq_from_obj

TSetDepthOfDischargeVoltsReq.proto_property = {'DepthOfDischargeVolts'}

TSetDepthOfDischargeVoltsReq.default = {0}

TSetDepthOfDischargeVoltsReq.struct = {{name = 'DepthOfDischargeVolts', is_array = false, struct = nil}}

function TSetDepthOfDischargeVoltsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DepthOfDischargeVolts', self.DepthOfDischargeVolts, 'uint32', false,
        errs, need_convert)

    TSetDepthOfDischargeVoltsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDepthOfDischargeVoltsReq.proto_property, errs, need_convert)
    return self
end

function TSetDepthOfDischargeVoltsReq:unpack(_)
    return self.DepthOfDischargeVolts
end

Capacitor.SetDepthOfDischargeVoltsReq = TSetDepthOfDischargeVoltsReq

---@class Capacitor.SetVOUTDebounceMillisecondsRsp
local TSetVOUTDebounceMillisecondsRsp = {}
TSetVOUTDebounceMillisecondsRsp.__index = TSetVOUTDebounceMillisecondsRsp
TSetVOUTDebounceMillisecondsRsp.group = {}

local function TSetVOUTDebounceMillisecondsRsp_from_obj(obj)
    return setmetatable(obj, TSetVOUTDebounceMillisecondsRsp)
end

function TSetVOUTDebounceMillisecondsRsp.new()
    return TSetVOUTDebounceMillisecondsRsp_from_obj({})
end
---@param obj Capacitor.SetVOUTDebounceMillisecondsRsp
function TSetVOUTDebounceMillisecondsRsp:init_from_obj(obj)

end

function TSetVOUTDebounceMillisecondsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVOUTDebounceMillisecondsRsp.group)
end

TSetVOUTDebounceMillisecondsRsp.from_obj = TSetVOUTDebounceMillisecondsRsp_from_obj

TSetVOUTDebounceMillisecondsRsp.proto_property = {}

TSetVOUTDebounceMillisecondsRsp.default = {}

TSetVOUTDebounceMillisecondsRsp.struct = {}

function TSetVOUTDebounceMillisecondsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetVOUTDebounceMillisecondsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVOUTDebounceMillisecondsRsp.proto_property, errs, need_convert)
    return self
end

function TSetVOUTDebounceMillisecondsRsp:unpack(_)
end

Capacitor.SetVOUTDebounceMillisecondsRsp = TSetVOUTDebounceMillisecondsRsp

---@class Capacitor.SetVOUTDebounceMillisecondsReq
---@field VOUTDebounceMilliseconds integer
local TSetVOUTDebounceMillisecondsReq = {}
TSetVOUTDebounceMillisecondsReq.__index = TSetVOUTDebounceMillisecondsReq
TSetVOUTDebounceMillisecondsReq.group = {}

local function TSetVOUTDebounceMillisecondsReq_from_obj(obj)
    return setmetatable(obj, TSetVOUTDebounceMillisecondsReq)
end

function TSetVOUTDebounceMillisecondsReq.new(VOUTDebounceMilliseconds)
    return TSetVOUTDebounceMillisecondsReq_from_obj({VOUTDebounceMilliseconds = VOUTDebounceMilliseconds})
end
---@param obj Capacitor.SetVOUTDebounceMillisecondsReq
function TSetVOUTDebounceMillisecondsReq:init_from_obj(obj)
    self.VOUTDebounceMilliseconds = obj.VOUTDebounceMilliseconds
end

function TSetVOUTDebounceMillisecondsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetVOUTDebounceMillisecondsReq.group)
end

TSetVOUTDebounceMillisecondsReq.from_obj = TSetVOUTDebounceMillisecondsReq_from_obj

TSetVOUTDebounceMillisecondsReq.proto_property = {'VOUTDebounceMilliseconds'}

TSetVOUTDebounceMillisecondsReq.default = {0}

TSetVOUTDebounceMillisecondsReq.struct = {{name = 'VOUTDebounceMilliseconds', is_array = false, struct = nil}}

function TSetVOUTDebounceMillisecondsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VOUTDebounceMilliseconds', self.VOUTDebounceMilliseconds, 'uint32', false, errs,
        need_convert)

    TSetVOUTDebounceMillisecondsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetVOUTDebounceMillisecondsReq.proto_property, errs, need_convert)
    return self
end

function TSetVOUTDebounceMillisecondsReq:unpack(_)
    return self.VOUTDebounceMilliseconds
end

Capacitor.SetVOUTDebounceMillisecondsReq = TSetVOUTDebounceMillisecondsReq

---@class Capacitor.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj Capacitor.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

Capacitor.ResetRsp = TResetRsp

---@class Capacitor.ResetReq
---@field ResetType string
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new(ResetType)
    return TResetReq_from_obj({ResetType = ResetType})
end
---@param obj Capacitor.ResetReq
function TResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {'ResetType'}

TResetReq.default = {''}

TResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'string', false, errs, need_convert)

    if self.ResetType ~= nil then
        validate.Enum(prefix .. 'ResetType', self.ResetType, '', {'ForceOff', 'On'}, errs, need_convert)
    end

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
    return self.ResetType
end

Capacitor.ResetReq = TResetReq

Capacitor.interface = mdb.register_interface('bmc.kepler.Chassis.PowerSubsystem.Capacitor', {
    HardwareVersion = {'s', {}, true, nil, false},
    PowerState = {'s', {'EMIT_CHANGE'}, true, 'N/A', false},
    VOUTDebounceMilliseconds = {'u', {}, true, nil, false},
    DepthOfDischargeVolts = {'u', {}, true, nil, false}
}, {
    Reset = {'a{ss}s', '', TResetReq, TResetRsp},
    SetVOUTDebounceMilliseconds = {'a{ss}u', '', TSetVOUTDebounceMillisecondsReq, TSetVOUTDebounceMillisecondsRsp},
    SetDepthOfDischargeVolts = {'a{ss}u', '', TSetDepthOfDischargeVoltsReq, TSetDepthOfDischargeVoltsRsp}
}, {})

return Capacitor
