--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingVoltageInput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageInputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingVoltageInputReq = {}
TGetThresholdSensorReadingVoltageInputReq.__index = TGetThresholdSensorReadingVoltageInputReq
TGetThresholdSensorReadingVoltageInputReq.group = {}

local function TGetThresholdSensorReadingVoltageInputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingVoltageInputReq)
end

function TGetThresholdSensorReadingVoltageInputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingVoltageInputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageInputReq
function TGetThresholdSensorReadingVoltageInputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingVoltageInputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingVoltageInputReq.group)
end

TGetThresholdSensorReadingVoltageInputReq.from_obj = TGetThresholdSensorReadingVoltageInputReq_from_obj

TGetThresholdSensorReadingVoltageInputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingVoltageInputReq.default = {0, 0}

TGetThresholdSensorReadingVoltageInputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingVoltageInputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingVoltageInputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingVoltageInputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingVoltageInputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingVoltageInput.GetThresholdSensorReadingVoltageInputReq =
    TGetThresholdSensorReadingVoltageInputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageInputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingVoltageInputRsp = {}
TGetThresholdSensorReadingVoltageInputRsp.__index = TGetThresholdSensorReadingVoltageInputRsp
TGetThresholdSensorReadingVoltageInputRsp.group = {}

local function TGetThresholdSensorReadingVoltageInputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingVoltageInputRsp)
end

function TGetThresholdSensorReadingVoltageInputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingVoltageInputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageInputRsp
function TGetThresholdSensorReadingVoltageInputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingVoltageInputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingVoltageInputRsp.group)
end

TGetThresholdSensorReadingVoltageInputRsp.from_obj = TGetThresholdSensorReadingVoltageInputRsp_from_obj

TGetThresholdSensorReadingVoltageInputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingVoltageInputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingVoltageInputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingVoltageInputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingVoltageInputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingVoltageInputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingVoltageInputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingVoltageInput.GetThresholdSensorReadingVoltageInputRsp =
    TGetThresholdSensorReadingVoltageInputRsp

return GetThresholdSensorReadingVoltageInput
