--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingPowerOutput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerOutputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingPowerOutputReq = {}
TGetThresholdSensorReadingPowerOutputReq.__index = TGetThresholdSensorReadingPowerOutputReq
TGetThresholdSensorReadingPowerOutputReq.group = {}

local function TGetThresholdSensorReadingPowerOutputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingPowerOutputReq)
end

function TGetThresholdSensorReadingPowerOutputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingPowerOutputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerOutputReq
function TGetThresholdSensorReadingPowerOutputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingPowerOutputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingPowerOutputReq.group)
end

TGetThresholdSensorReadingPowerOutputReq.from_obj = TGetThresholdSensorReadingPowerOutputReq_from_obj

TGetThresholdSensorReadingPowerOutputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingPowerOutputReq.default = {0, 0}

TGetThresholdSensorReadingPowerOutputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingPowerOutputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingPowerOutputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingPowerOutputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingPowerOutputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingPowerOutput.GetThresholdSensorReadingPowerOutputReq = TGetThresholdSensorReadingPowerOutputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerOutputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingPowerOutputRsp = {}
TGetThresholdSensorReadingPowerOutputRsp.__index = TGetThresholdSensorReadingPowerOutputRsp
TGetThresholdSensorReadingPowerOutputRsp.group = {}

local function TGetThresholdSensorReadingPowerOutputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingPowerOutputRsp)
end

function TGetThresholdSensorReadingPowerOutputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingPowerOutputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerOutputRsp
function TGetThresholdSensorReadingPowerOutputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingPowerOutputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingPowerOutputRsp.group)
end

TGetThresholdSensorReadingPowerOutputRsp.from_obj = TGetThresholdSensorReadingPowerOutputRsp_from_obj

TGetThresholdSensorReadingPowerOutputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingPowerOutputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingPowerOutputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingPowerOutputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingPowerOutputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingPowerOutputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingPowerOutputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingPowerOutput.GetThresholdSensorReadingPowerOutputRsp = TGetThresholdSensorReadingPowerOutputRsp

return GetThresholdSensorReadingPowerOutput
