--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingPowerInput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerInputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingPowerInputReq = {}
TGetThresholdSensorReadingPowerInputReq.__index = TGetThresholdSensorReadingPowerInputReq
TGetThresholdSensorReadingPowerInputReq.group = {}

local function TGetThresholdSensorReadingPowerInputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingPowerInputReq)
end

function TGetThresholdSensorReadingPowerInputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingPowerInputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerInputReq
function TGetThresholdSensorReadingPowerInputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingPowerInputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingPowerInputReq.group)
end

TGetThresholdSensorReadingPowerInputReq.from_obj = TGetThresholdSensorReadingPowerInputReq_from_obj

TGetThresholdSensorReadingPowerInputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingPowerInputReq.default = {0, 0}

TGetThresholdSensorReadingPowerInputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingPowerInputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingPowerInputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingPowerInputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingPowerInputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingPowerInput.GetThresholdSensorReadingPowerInputReq = TGetThresholdSensorReadingPowerInputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerInputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingPowerInputRsp = {}
TGetThresholdSensorReadingPowerInputRsp.__index = TGetThresholdSensorReadingPowerInputRsp
TGetThresholdSensorReadingPowerInputRsp.group = {}

local function TGetThresholdSensorReadingPowerInputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingPowerInputRsp)
end

function TGetThresholdSensorReadingPowerInputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingPowerInputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerInputRsp
function TGetThresholdSensorReadingPowerInputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingPowerInputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingPowerInputRsp.group)
end

TGetThresholdSensorReadingPowerInputRsp.from_obj = TGetThresholdSensorReadingPowerInputRsp_from_obj

TGetThresholdSensorReadingPowerInputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingPowerInputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingPowerInputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingPowerInputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingPowerInputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingPowerInputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingPowerInputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingPowerInput.GetThresholdSensorReadingPowerInputRsp = TGetThresholdSensorReadingPowerInputRsp

return GetThresholdSensorReadingPowerInput
