--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetThresholdSensorReadingCurrentInput = {}

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentInputReq
---@field ManufactureId integer
---@field DeviceId integer
local TGetThresholdSensorReadingCurrentInputReq = {}
TGetThresholdSensorReadingCurrentInputReq.__index = TGetThresholdSensorReadingCurrentInputReq
TGetThresholdSensorReadingCurrentInputReq.group = {}

local function TGetThresholdSensorReadingCurrentInputReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingCurrentInputReq)
end

function TGetThresholdSensorReadingCurrentInputReq.new(ManufactureId, DeviceId)
    return TGetThresholdSensorReadingCurrentInputReq_from_obj({ManufactureId = ManufactureId, DeviceId = DeviceId})
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentInputReq
function TGetThresholdSensorReadingCurrentInputReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceId = obj.DeviceId
end

function TGetThresholdSensorReadingCurrentInputReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingCurrentInputReq.group)
end

TGetThresholdSensorReadingCurrentInputReq.from_obj = TGetThresholdSensorReadingCurrentInputReq_from_obj

TGetThresholdSensorReadingCurrentInputReq.proto_property = {'ManufactureId', 'DeviceId'}

TGetThresholdSensorReadingCurrentInputReq.default = {0, 0}

TGetThresholdSensorReadingCurrentInputReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingCurrentInputReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', false, errs, need_convert)

    TGetThresholdSensorReadingCurrentInputReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingCurrentInputReq.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingCurrentInputReq:unpack(_)
    return self.ManufactureId, self.DeviceId
end

GetThresholdSensorReadingCurrentInput.GetThresholdSensorReadingCurrentInputReq =
    TGetThresholdSensorReadingCurrentInputReq

---@class PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentInputRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
local TGetThresholdSensorReadingCurrentInputRsp = {}
TGetThresholdSensorReadingCurrentInputRsp.__index = TGetThresholdSensorReadingCurrentInputRsp
TGetThresholdSensorReadingCurrentInputRsp.group = {}

local function TGetThresholdSensorReadingCurrentInputRsp_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorReadingCurrentInputRsp)
end

function TGetThresholdSensorReadingCurrentInputRsp.new(CompletionCode, ManufactureId, Reading)
    return TGetThresholdSensorReadingCurrentInputRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading
    })
end
---@param obj PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentInputRsp
function TGetThresholdSensorReadingCurrentInputRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
end

function TGetThresholdSensorReadingCurrentInputRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorReadingCurrentInputRsp.group)
end

TGetThresholdSensorReadingCurrentInputRsp.from_obj = TGetThresholdSensorReadingCurrentInputRsp_from_obj

TGetThresholdSensorReadingCurrentInputRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reading'}

TGetThresholdSensorReadingCurrentInputRsp.default = {0, 0, 0}

TGetThresholdSensorReadingCurrentInputRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil}
}

function TGetThresholdSensorReadingCurrentInputRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint32', false, errs, need_convert)

    TGetThresholdSensorReadingCurrentInputRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorReadingCurrentInputRsp.proto_property, errs, need_convert)
    return self
end

function TGetThresholdSensorReadingCurrentInputRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading
end

GetThresholdSensorReadingCurrentInput.GetThresholdSensorReadingCurrentInputRsp =
    TGetThresholdSensorReadingCurrentInputRsp

return GetThresholdSensorReadingCurrentInput
