--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPsuFruConfig = {}

---@class PowerMgmtIpmiCmds.GetPsuFruConfigReq
---@field ManufactureId integer
local TGetPsuFruConfigReq = {}
TGetPsuFruConfigReq.__index = TGetPsuFruConfigReq
TGetPsuFruConfigReq.group = {}

local function TGetPsuFruConfigReq_from_obj(obj)
    return setmetatable(obj, TGetPsuFruConfigReq)
end

function TGetPsuFruConfigReq.new(ManufactureId)
    return TGetPsuFruConfigReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj PowerMgmtIpmiCmds.GetPsuFruConfigReq
function TGetPsuFruConfigReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetPsuFruConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPsuFruConfigReq.group)
end

TGetPsuFruConfigReq.from_obj = TGetPsuFruConfigReq_from_obj

TGetPsuFruConfigReq.proto_property = {'ManufactureId'}

TGetPsuFruConfigReq.default = {0}

TGetPsuFruConfigReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetPsuFruConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetPsuFruConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPsuFruConfigReq.proto_property, errs, need_convert)
    return self
end

function TGetPsuFruConfigReq:unpack(_)
    return self.ManufactureId
end

GetPsuFruConfig.GetPsuFruConfigReq = TGetPsuFruConfigReq

---@class PowerMgmtIpmiCmds.GetPsuFruConfigRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field ConfigValue integer
local TGetPsuFruConfigRsp = {}
TGetPsuFruConfigRsp.__index = TGetPsuFruConfigRsp
TGetPsuFruConfigRsp.group = {}

local function TGetPsuFruConfigRsp_from_obj(obj)
    return setmetatable(obj, TGetPsuFruConfigRsp)
end

function TGetPsuFruConfigRsp.new(CompletionCode, ManufactureId, ConfigValue)
    return TGetPsuFruConfigRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        ConfigValue = ConfigValue
    })
end
---@param obj PowerMgmtIpmiCmds.GetPsuFruConfigRsp
function TGetPsuFruConfigRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.ConfigValue = obj.ConfigValue
end

function TGetPsuFruConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPsuFruConfigRsp.group)
end

TGetPsuFruConfigRsp.from_obj = TGetPsuFruConfigRsp_from_obj

TGetPsuFruConfigRsp.proto_property = {'CompletionCode', 'ManufactureId', 'ConfigValue'}

TGetPsuFruConfigRsp.default = {0, 0, 0}

TGetPsuFruConfigRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'ConfigValue', is_array = false, struct = nil}
}

function TGetPsuFruConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigValue', self.ConfigValue, 'uint8', false, errs, need_convert)

    TGetPsuFruConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPsuFruConfigRsp.proto_property, errs, need_convert)
    return self
end

function TGetPsuFruConfigRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.ConfigValue
end

GetPsuFruConfig.GetPsuFruConfigRsp = TGetPsuFruConfigRsp

return GetPsuFruConfig
