-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-6-16
-- Description: DO NOT EDIT; Code generated by "service.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class'
local object_manage = require 'mc.mdb.object_manage'

local BlackBoxTypes = require 'debug.json_types.BlackBox'
local PropertiesTypes = require 'debug.json_types.Properties'

local OnePowerDebug = mdb.register_object('/bmc/kepler/Debug/Chassis/:ChassisId/PowerMgmt/:ID', {
    {name = 'bmc.kepler.Debug.BlackBox', interface = BlackBoxTypes.interface},
    {name = 'bmc.kepler.Object.Properties', interface = PropertiesTypes.interface}
})

function OnePowerDebug:ctor(ChassisId, ID)
    self.path = '/bmc/kepler/Debug/Chassis/' .. ChassisId .. '/PowerMgmt/' .. ID
end

local model = require 'debug.class.model'

local power_mgmt_service = class()

power_mgmt_service.package = 'power_mgmt'

function power_mgmt_service:CreateOnePowerDebug(ChassisId, ID, prop_setting_cb)
    local path = '/bmc/kepler/Debug/Chassis/' .. ChassisId .. '/PowerMgmt/' .. ID
    return object_manage.create_object('OnePowerDebug', path, path, prop_setting_cb)
end

function power_mgmt_service:ImplOnePowerDebugBlackBoxDumpPsuBlackbox(cb)
    model.ImplOnePowerDebugBlackBoxDumpPsuBlackbox(cb)
end

function power_mgmt_service:get_bus()
    return self.bus
end

function power_mgmt_service:ctor(bus)
    self.bus = bus
    self.signal_slots = {}
    self.name = self.name or power_mgmt_service.package

    model.init(self.bus)
    power_mgmt_service.bus = self.bus
end

function power_mgmt_service:init()
end

return power_mgmt_service
