-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPowerSupplies = {}

---@class MPowerSupplies.RetransferDelaySeconds
---@field RetransferDelaySeconds integer
local TRetransferDelaySeconds = {}
TRetransferDelaySeconds.__index = TRetransferDelaySeconds
TRetransferDelaySeconds.group = {}

local function TRetransferDelaySeconds_from_obj(obj)
    return setmetatable(obj, TRetransferDelaySeconds)
end

function TRetransferDelaySeconds.new(RetransferDelaySeconds)
    return TRetransferDelaySeconds_from_obj({RetransferDelaySeconds = RetransferDelaySeconds or 1800})
end
---@param obj MPowerSupplies.RetransferDelaySeconds
function TRetransferDelaySeconds:init_from_obj(obj)
    self.RetransferDelaySeconds = obj.RetransferDelaySeconds or 1800
end

function TRetransferDelaySeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRetransferDelaySeconds.group)
end

TRetransferDelaySeconds.from_obj = TRetransferDelaySeconds_from_obj

TRetransferDelaySeconds.proto_property = {'RetransferDelaySeconds'}

TRetransferDelaySeconds.default = {0}

TRetransferDelaySeconds.struct = {{name = 'RetransferDelaySeconds', is_array = false, struct = nil}}

function TRetransferDelaySeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RetransferDelaySeconds', self.RetransferDelaySeconds, 'uint32', false, errs,
        need_convert)

    if self.RetransferDelaySeconds ~= nil then
        validate.ranges(prefix .. 'RetransferDelaySeconds', self.RetransferDelaySeconds, 10, 16200, errs, need_convert)
    end

    TRetransferDelaySeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRetransferDelaySeconds.proto_property, errs, need_convert)
    return self
end

function TRetransferDelaySeconds:unpack(_)
    return self.RetransferDelaySeconds
end

MPowerSupplies.RetransferDelaySeconds = TRetransferDelaySeconds

---@class MPowerSupplies.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MPowerSupplies.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MPowerSupplies.Id = TId

return MPowerSupplies
