-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPowerOutputEfficiencyCurve = {}

---@class MPowerOutputEfficiencyCurve.PowerLevel
---@field PowerLevel string
local TPowerLevel = {}
TPowerLevel.__index = TPowerLevel
TPowerLevel.group = {}

local function TPowerLevel_from_obj(obj)
    return setmetatable(obj, TPowerLevel)
end

function TPowerLevel.new(PowerLevel)
    return TPowerLevel_from_obj({PowerLevel = PowerLevel or [=[N/A]=]})
end
---@param obj MPowerOutputEfficiencyCurve.PowerLevel
function TPowerLevel:init_from_obj(obj)
    self.PowerLevel = obj.PowerLevel or [=[N/A]=]
end

function TPowerLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerLevel.group)
end

TPowerLevel.from_obj = TPowerLevel_from_obj

TPowerLevel.proto_property = {'PowerLevel'}

TPowerLevel.default = {''}

TPowerLevel.struct = {{name = 'PowerLevel', is_array = false, struct = nil}}

function TPowerLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerLevel', self.PowerLevel, 'string', false, errs, need_convert)

    if self.PowerLevel ~= nil then
        validate.Enum(prefix .. 'PowerLevel', self.PowerLevel, '', {
            '80PLUS', '80PLUS Bronze', '80PLUS Silver', '80PLUS Gold', '80PLUS Platinum', '80PLUS Titanium', 'N/A'
        }, errs, need_convert)
    end

    TPowerLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerLevel.proto_property, errs, need_convert)
    return self
end

function TPowerLevel:unpack(_)
    return self.PowerLevel
end

MPowerOutputEfficiencyCurve.PowerLevel = TPowerLevel

---@class MPowerOutputEfficiencyCurve.EfficiencyCurve
---@field EfficiencyCurve number[]
local TEfficiencyCurve = {}
TEfficiencyCurve.__index = TEfficiencyCurve
TEfficiencyCurve.group = {}

local function TEfficiencyCurve_from_obj(obj)
    return setmetatable(obj, TEfficiencyCurve)
end

function TEfficiencyCurve.new(EfficiencyCurve)
    return TEfficiencyCurve_from_obj({EfficiencyCurve = EfficiencyCurve})
end
---@param obj MPowerOutputEfficiencyCurve.EfficiencyCurve
function TEfficiencyCurve:init_from_obj(obj)
    self.EfficiencyCurve = obj.EfficiencyCurve
end

function TEfficiencyCurve:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEfficiencyCurve.group)
end

TEfficiencyCurve.from_obj = TEfficiencyCurve_from_obj

TEfficiencyCurve.proto_property = {'EfficiencyCurve'}

TEfficiencyCurve.default = {{}}

TEfficiencyCurve.struct = {{name = 'EfficiencyCurve', is_array = true, struct = nil}}

function TEfficiencyCurve:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'EfficiencyCurve', self.EfficiencyCurve, 'double', false, errs, need_convert)

    TEfficiencyCurve:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEfficiencyCurve.proto_property, errs, need_convert)
    return self
end

function TEfficiencyCurve:unpack(_)
    return self.EfficiencyCurve
end

MPowerOutputEfficiencyCurve.EfficiencyCurve = TEfficiencyCurve

---@class MPowerOutputEfficiencyCurve.LoadPercentRange
---@field LoadPercentRange integer[]
local TLoadPercentRange = {}
TLoadPercentRange.__index = TLoadPercentRange
TLoadPercentRange.group = {}

local function TLoadPercentRange_from_obj(obj)
    return setmetatable(obj, TLoadPercentRange)
end

function TLoadPercentRange.new(LoadPercentRange)
    return TLoadPercentRange_from_obj({LoadPercentRange = LoadPercentRange})
end
---@param obj MPowerOutputEfficiencyCurve.LoadPercentRange
function TLoadPercentRange:init_from_obj(obj)
    self.LoadPercentRange = obj.LoadPercentRange
end

function TLoadPercentRange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoadPercentRange.group)
end

TLoadPercentRange.from_obj = TLoadPercentRange_from_obj

TLoadPercentRange.proto_property = {'LoadPercentRange'}

TLoadPercentRange.default = {{}}

TLoadPercentRange.struct = {{name = 'LoadPercentRange', is_array = true, struct = nil}}

function TLoadPercentRange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LoadPercentRange', self.LoadPercentRange, 'uint8', false, errs, need_convert)

    TLoadPercentRange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoadPercentRange.proto_property, errs, need_convert)
    return self
end

function TLoadPercentRange:unpack(_)
    return self.LoadPercentRange
end

MPowerOutputEfficiencyCurve.LoadPercentRange = TLoadPercentRange

---@class MPowerOutputEfficiencyCurve.InputVoltage
---@field InputVoltage integer
local TInputVoltage = {}
TInputVoltage.__index = TInputVoltage
TInputVoltage.group = {}

local function TInputVoltage_from_obj(obj)
    return setmetatable(obj, TInputVoltage)
end

function TInputVoltage.new(InputVoltage)
    return TInputVoltage_from_obj({InputVoltage = InputVoltage})
end
---@param obj MPowerOutputEfficiencyCurve.InputVoltage
function TInputVoltage:init_from_obj(obj)
    self.InputVoltage = obj.InputVoltage
end

function TInputVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltage.group)
end

TInputVoltage.from_obj = TInputVoltage_from_obj

TInputVoltage.proto_property = {'InputVoltage'}

TInputVoltage.default = {0}

TInputVoltage.struct = {{name = 'InputVoltage', is_array = false, struct = nil}}

function TInputVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'InputVoltage', self.InputVoltage, 'uint16', false, errs, need_convert)

    TInputVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltage.proto_property, errs, need_convert)
    return self
end

function TInputVoltage:unpack(_)
    return self.InputVoltage
end

MPowerOutputEfficiencyCurve.InputVoltage = TInputVoltage

---@class MPowerOutputEfficiencyCurve.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj MPowerOutputEfficiencyCurve.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PartNumber', self.PartNumber, 'string', false, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

MPowerOutputEfficiencyCurve.PartNumber = TPartNumber

---@class MPowerOutputEfficiencyCurve.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj MPowerOutputEfficiencyCurve.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Position', self.Position, 'string', false, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

MPowerOutputEfficiencyCurve.Position = TPosition

return MPowerOutputEfficiencyCurve
