-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local common_interface = require 'common_interface'
local client = require 'pcie_device.client'

TestCommonInterfae = {}

function TestCommonInterfae:test_listen_and_update_power_status()
    local values = {
        PowerState = {value = function()
            return 'OFF'
        end}
    }
    local path = 'bmc/kepler/Systems/1/FruCtrl'
    local interface = 'bmc.kepler.Systems.FruCtrl'
    client.OnFruCtrlPropertiesChanged = function(client, cb)
        cb(values, path, interface)
    end
    local obj_tab = {
        {path = 'bmc/kepler/Systems/2/FruCtrl', PowerState = 'ON'},
        {path = 'bmc/kepler/Systems/3/FruCtrl', PowerState = 'OFF'}
    }
    client.ForeachFruCtrlObjects = function(client, cb)
        for _, obj in pairs(obj_tab) do
            cb(obj)
        end
    end
    common_interface:ctor({})
    common_interface:init()
    lu.assertEquals(common_interface.power_status[1], 'OFF')
    lu.assertEquals(common_interface.power_status[2], 'ON')
    lu.assertEquals(common_interface.power_status[3], 'OFF')
end