-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local comm_fun = require 'device_mgmt.comm_fun'
local comm_defs = require 'device_mgmt.comm_defs'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local org_freedesktop_dbus = require 'sd_bus.org_freedesktop_dbus'
local match_rule = org_freedesktop_dbus.MatchRule
local interface_add = org_freedesktop_dbus.ObjMgrInterfacesAdded

TestCommFun = {}

local mds_obj = {
}

function TestCommFun:setupClass()
end

function TestCommFun:teardownClass()
end

function TestCommFun:test_get_all_device_paths()
    local bus = {
        call = function()
            return "paths"
        end
    }
    local ret = comm_fun.get_all_device_paths(bus)
    lu.assertEquals(ret, "paths")
end

function TestCommFun:test_get_parent_path()
    local mdb_register_interface = mdb.register_interface
    local mdb_get_object = mdb.get_object

    local bus = {
        call = function()
            return {{comm_defs.OBJECT_PROPERTIES_INTERFACE}}
        end
    }
    mdb.register_interface = function()
    end

    mdb.get_object = function()
    end

    local ret = comm_fun.get_parent_path(bus)
    lu.assertEquals(ret, nil)

    mdb.get_object = function()
        return {
            get_property = function()
                return 0, 'ParentPath'
            end
        }
    end
    local ret = comm_fun.get_parent_path(bus)
    lu.assertEquals(ret, 'ParentPath')

    mdb.register_interface = mdb_register_interface
    mdb.get_object = mdb_get_object
end

function TestCommFun:test_get_position_by_object_name()
    local str = "Card_1_010101"
    local ret = comm_fun.get_position_by_object_name(str)
    lu.assertEquals(ret, "010101")
end

function TestCommFun:test_get_device_name_by_object_name()
    local str = "Card_1_010101"
    local ret = comm_fun.get_device_name_by_object_name(str, "PCIeCard")
    lu.assertEquals(ret, "PCIeCard_1_010101")
end

