-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_device_loader = require 'biz_topo.device_loader'
local c_load_info = require 'biz_topo.class.load_info'
local c_device_service = require 'device.device_service'
local cmn = require 'common'

TestDeviceLoader = {}

function TestDeviceLoader:test_parse_pcie_card_bdf_data()
    local data = '\x00\x00\x01\x01\x01\x01\x00\x00\x00\x00\x00\x01\x02\x02\x02'

    local pcie_card_info = c_device_loader.parse_pcie_card_bdf_data(data)
    -- PCIeSlot 1
    lu.assertEquals(pcie_card_info[1].bus_info.segment, 0)
    lu.assertEquals(pcie_card_info[1].bus_info.socket_id, 0)
    lu.assertEquals(pcie_card_info[1].bus_info.bus, 1)
    lu.assertEquals(pcie_card_info[1].bus_info.device, 1)
    lu.assertEquals(pcie_card_info[1].bus_info.func, 1)
    -- PCIeSlot 3
    lu.assertEquals(pcie_card_info[3].bus_info.segment, 0)
    lu.assertEquals(pcie_card_info[3].bus_info.socket_id, 1)
    lu.assertEquals(pcie_card_info[3].bus_info.bus, 2)
    lu.assertEquals(pcie_card_info[3].bus_info.device, 2)
    lu.assertEquals(pcie_card_info[3].bus_info.func, 2)
end

function TestDeviceLoader:test_get_pcie_vid_did_info()
    local bus = {
        call = function()
            return 0, '\x00\x07\xdb\x04\x01\x02\x03\x04'
        end
    }
    local pcie_info = {
        bus_info = {
            socket_id = 1,
            bus = 1,
            device = 1,
            func = 1
        }
    }
    c_device_loader.get_pcie_vid_did_info(1, bus, pcie_info)
end

function TestDeviceLoader:test_load_unload_device()
    local mock_device_load = {
        biz_topo = {
            get_mgmt_connector = function(...)
                return true, nil, {Presence = 1, LoadStatus = 0}
            end
        }
    }
    local load_info = {
        slot_id = 256
    }
    c_device_loader.load_unload_device(mock_device_load, load_info, _, _, _)
    
end

function TestDeviceLoader:test_get_id_auxid_str()
    local load_info = {
        ['id'] = 1,
        ['aux_id'] = 2,
        ['type'] = 'PCIeCard'
    }
    local str_id, str_auxid = c_device_loader.get_id_auxid_str({}, nil, load_info)
    lu.assertEquals(str_id, '')
    lu.assertEquals(str_auxid, '')

    load_info = {
        ['id'] = 1,
        ['aux_id'] = 2,
        ['type'] = 'OCPCard'
    }

    str_id, str_auxid = c_device_loader.get_id_auxid_str({}, 'bom', load_info)
    lu.assertEquals(str_id, "00000001")
    lu.assertEquals(str_auxid, "00000002")

    load_info = {
        ['id'] = 0xfffffffe,
        ['aux_id'] = 2,
        ['type'] = 'PCIeCard'
    }
    str_id, str_auxid = c_device_loader.get_id_auxid_str({}, 'bom', load_info)
    lu.assertEquals(str_id, "fffffffe")
    lu.assertEquals(str_auxid, "ffffffff")
end

function TestDeviceLoader:test_unload_device_connector()
    local c_get_instance = c_device_service.get_instance
    c_device_service.get_instance = function()
        return {
            clear_flash_checker_event = function()
            end
        }
    end
    local load_info = {
        slot_id = 256
    }
    local connector_info = {
        Id = "fffffffe",
        AuxId = "ffffffff",
    }
    local ok, _ = pcall(function()
        c_device_loader.unload_device_connector(load_info, connector_info, 1)
    end)
    lu.assertEquals(ok, true)

    c_device_service.get_instance = c_get_instance
end