-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local comm_defs = {}

comm_defs.MACA_SERVICE = 'bmc.kepler.maca'
comm_defs.MDB_PATH = '/bmc/kepler/MdbService'
comm_defs.MDB_INTERFACE = 'bmc.kepler.Mdb'

comm_defs.PCIE_NIC_CARD_PATH_PATTERN = '/bmc/dev/Systems/1/PCIeNicCard'
comm_defs.PCIE_GPU_CARD_PATH_PATTERN = '/bmc/dev/Systems/1/PCIeGpuCard'

comm_defs.OBJECT_PROPERTIES_INTERFACE = 'bmc.kepler.Object.Properties'
comm_defs.ORG_PROPERTIES_INTERFACE = 'org.freedesktop.DBus.Properties'

-- PCIeDevice相关设备树接口
comm_defs.PCIE_DEVICE_INTERFACE = 'bmc.dev.PCIeDevice'
comm_defs.PCIE_CARD_DEVICE_INTERFACE = 'bmc.dev.PCIeCard'
comm_defs.NETWORK_ADAPTER_INTERFACE = 'bmc.dev.NetworkAdapter'

comm_defs.PCIE_DEVICE_CLASS_NAME = 'PCIeDevice'
comm_defs.PCIE_CARD_CLASS_NAME = 'PCIeCard'

-- 用代理对象设置属性和调方法，依赖register_interface的时候把属性、方法注册好。设备树对象需要注册属性和方法
comm_defs.INTERFACE_REGISTER_TABLE = {
    [comm_defs.PCIE_DEVICE_INTERFACE] = {
        Slot = {'y', nil, false, nil, false},
        Segment = {'y', nil, false, nil, false},
        SocketId = {'y', nil, false, nil, false},
        Bus = {'y', nil, false, nil, false},
        Device = {'y', nil, false, nil, false},
        Function = {'y', nil, false, nil, false},
        DevBus = {'y', nil, false, nil, false},
        DevDevice = {'y', nil, false, nil, false},
        DevFunction = {'y', nil, false, nil, false},
        DiagnosticFault = {'y', nil, false, nil, false},
        PredictiveFault = {'y', nil, false, nil, false},
        UCEByBIOS = {'y', nil, false, nil, false},
        BandwidthReduction = {'y', nil, false, nil, false},
        LinkSpeedReduced = {'y', nil, false, nil, false},
        DeviceName = {'s', nil, false, nil, false},
        Location = {'s', nil, false, nil, false},
        GroupPosition = {'s', nil, false, nil, false}
    }
}

comm_defs.POSITION_INDEX = 4

return comm_defs
