-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local M = {}

-- PCIe带外管理协议错误码定义
local PM_ERROR_CODE_BASE <const> = 0x3000
local e_err_code <const> = {
    REQUEST_LEN_ERROR = PM_ERROR_CODE_BASE + 0x03,
    IDENTIFY_CODE_ERROR = PM_ERROR_CODE_BASE + 0x04,
    CAP_UNSUPPORTED = PM_ERROR_CODE_BASE + 0x05
}

-- 协议类型
local e_protocol <const> = {
    I2C = 'I2C',
    SMBUS = 'SmBus',
    STD_SMBUS = 'StdSmBus'
}

-- opcode
local e_opcode <const> = {
    CAPABILITY = 0,
    GET_HEALTH = 1,
    GET_FIRMWARE_VERSION = 5
}

M.e_err_code = e_err_code
M.e_opcode = e_opcode
M.e_protocol = e_protocol
return M