-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local cmn = require 'common'
local client = require 'pcie_device.client'

local MAX_CHECK_COUNT<const> = 3

local c_pcie_card_flash_checker = class()

function c_pcie_card_flash_checker:config_new(Id, Description)
    return { Id = Id, Description = Description }
end

local function config_tbl_new(Id, Description)
    return { Id or "", Description or "" }
end

function c_pcie_card_flash_checker:update_fault_status(v)
    self.mds_obj["FaultStatus"] = v
end

function c_pcie_card_flash_checker:need_check()
    if self.check_count >= MAX_CHECK_COUNT then
        return false
    end
    return true
end

function c_pcie_card_flash_checker:add_check_count()
    self.check_count = self.check_count + 1
end

function c_pcie_card_flash_checker:init()
    -- 将数组重新转成结构体
    local cfg
    if self.mds_obj.PCIeQuadrupleList and #self.mds_obj.PCIeQuadrupleList ~= 0 and
        #self.mds_obj.PCIeQuadrupleList[1] ~= 0 then
        for i, config in ipairs(self.mds_obj.PCIeQuadrupleList) do
            self.mds_obj.PCIeQuadrupleList[i] = config_tbl_new(table.unpack(config, 1, 2))
            cfg = self:config_new(table.unpack(config, 1, 2))
            self.id_list[cfg.Id] = cfg.Description
        end
    end
end

function c_pcie_card_flash_checker:ctor(mds_obj, position, bus)
    self.mds_obj = mds_obj
    self.position = position
    self.bus = bus
    self.check_count = 0
    self.id_list = {}
end

return c_pcie_card_flash_checker