-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CPU = {}

---@class CPU.BaseSpeedMHz
---@field BaseSpeedMHz integer
local TBaseSpeedMHz = {}
TBaseSpeedMHz.__index = TBaseSpeedMHz
TBaseSpeedMHz.group = {}

local function TBaseSpeedMHz_from_obj(obj)
    return setmetatable(obj, TBaseSpeedMHz)
end

function TBaseSpeedMHz.new(BaseSpeedMHz)
    return TBaseSpeedMHz_from_obj({BaseSpeedMHz = BaseSpeedMHz})
end
---@param obj CPU.BaseSpeedMHz
function TBaseSpeedMHz:init_from_obj(obj)
    self.BaseSpeedMHz = obj.BaseSpeedMHz
end

function TBaseSpeedMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseSpeedMHz.group)
end

TBaseSpeedMHz.from_obj = TBaseSpeedMHz_from_obj

TBaseSpeedMHz.proto_property = {'BaseSpeedMHz'}

TBaseSpeedMHz.default = {0}

TBaseSpeedMHz.struct = {{name = 'BaseSpeedMHz', is_array = false, struct = nil}}

function TBaseSpeedMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseSpeedMHz', self.BaseSpeedMHz, 'uint32', true, errs, need_convert)

    TBaseSpeedMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseSpeedMHz.proto_property, errs, need_convert)
    return self
end

function TBaseSpeedMHz:unpack(_)
    return self.BaseSpeedMHz
end

CPU.BaseSpeedMHz = TBaseSpeedMHz

---@class CPU.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj CPU.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', true, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

CPU.SilkText = TSilkText

---@class CPU.TotalEnabledThreads
---@field TotalEnabledThreads integer
local TTotalEnabledThreads = {}
TTotalEnabledThreads.__index = TTotalEnabledThreads
TTotalEnabledThreads.group = {}

local function TTotalEnabledThreads_from_obj(obj)
    return setmetatable(obj, TTotalEnabledThreads)
end

function TTotalEnabledThreads.new(TotalEnabledThreads)
    return TTotalEnabledThreads_from_obj({TotalEnabledThreads = TotalEnabledThreads})
end
---@param obj CPU.TotalEnabledThreads
function TTotalEnabledThreads:init_from_obj(obj)
    self.TotalEnabledThreads = obj.TotalEnabledThreads
end

function TTotalEnabledThreads:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalEnabledThreads.group)
end

TTotalEnabledThreads.from_obj = TTotalEnabledThreads_from_obj

TTotalEnabledThreads.proto_property = {'TotalEnabledThreads'}

TTotalEnabledThreads.default = {0}

TTotalEnabledThreads.struct = {{name = 'TotalEnabledThreads', is_array = false, struct = nil}}

function TTotalEnabledThreads:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalEnabledThreads', self.TotalEnabledThreads, 'uint32', true, errs, need_convert)

    TTotalEnabledThreads:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalEnabledThreads.proto_property, errs, need_convert)
    return self
end

function TTotalEnabledThreads:unpack(_)
    return self.TotalEnabledThreads
end

CPU.TotalEnabledThreads = TTotalEnabledThreads

---@class CPU.PowerWatt
---@field PowerWatt number
local TPowerWatt = {}
TPowerWatt.__index = TPowerWatt
TPowerWatt.group = {}

local function TPowerWatt_from_obj(obj)
    return setmetatable(obj, TPowerWatt)
end

function TPowerWatt.new(PowerWatt)
    return TPowerWatt_from_obj({PowerWatt = PowerWatt})
end
---@param obj CPU.PowerWatt
function TPowerWatt:init_from_obj(obj)
    self.PowerWatt = obj.PowerWatt
end

function TPowerWatt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatt.group)
end

TPowerWatt.from_obj = TPowerWatt_from_obj

TPowerWatt.proto_property = {'PowerWatt'}

TPowerWatt.default = {0}

TPowerWatt.struct = {{name = 'PowerWatt', is_array = false, struct = nil}}

function TPowerWatt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatt', self.PowerWatt, 'double', true, errs, need_convert)

    TPowerWatt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatt.proto_property, errs, need_convert)
    return self
end

function TPowerWatt:unpack(_)
    return self.PowerWatt
end

CPU.PowerWatt = TPowerWatt

---@class CPU.IsMemoryPresence
---@field IsMemoryPresence integer
local TIsMemoryPresence = {}
TIsMemoryPresence.__index = TIsMemoryPresence
TIsMemoryPresence.group = {}

local function TIsMemoryPresence_from_obj(obj)
    return setmetatable(obj, TIsMemoryPresence)
end

function TIsMemoryPresence.new(IsMemoryPresence)
    return TIsMemoryPresence_from_obj({IsMemoryPresence = IsMemoryPresence})
end
---@param obj CPU.IsMemoryPresence
function TIsMemoryPresence:init_from_obj(obj)
    self.IsMemoryPresence = obj.IsMemoryPresence
end

function TIsMemoryPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsMemoryPresence.group)
end

TIsMemoryPresence.from_obj = TIsMemoryPresence_from_obj

TIsMemoryPresence.proto_property = {'IsMemoryPresence'}

TIsMemoryPresence.default = {0}

TIsMemoryPresence.struct = {{name = 'IsMemoryPresence', is_array = false, struct = nil}}

function TIsMemoryPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsMemoryPresence', self.IsMemoryPresence, 'uint8', true, errs, need_convert)

    TIsMemoryPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsMemoryPresence.proto_property, errs, need_convert)
    return self
end

function TIsMemoryPresence:unpack(_)
    return self.IsMemoryPresence
end

CPU.IsMemoryPresence = TIsMemoryPresence

---@class CPU.PowerGood
---@field PowerGood integer
local TPowerGood = {}
TPowerGood.__index = TPowerGood
TPowerGood.group = {}

local function TPowerGood_from_obj(obj)
    return setmetatable(obj, TPowerGood)
end

function TPowerGood.new(PowerGood)
    return TPowerGood_from_obj({PowerGood = PowerGood})
end
---@param obj CPU.PowerGood
function TPowerGood:init_from_obj(obj)
    self.PowerGood = obj.PowerGood
end

function TPowerGood:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerGood.group)
end

TPowerGood.from_obj = TPowerGood_from_obj

TPowerGood.proto_property = {'PowerGood'}

TPowerGood.default = {0}

TPowerGood.struct = {{name = 'PowerGood', is_array = false, struct = nil}}

function TPowerGood:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerGood', self.PowerGood, 'uint8', true, errs, need_convert)

    TPowerGood:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerGood.proto_property, errs, need_convert)
    return self
end

function TPowerGood:unpack(_)
    return self.PowerGood
end

CPU.PowerGood = TPowerGood

---@class CPU.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled})
end
---@param obj CPU.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', true, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

CPU.Enabled = TEnabled

---@class CPU.ProcessorHot
---@field ProcessorHot integer
local TProcessorHot = {}
TProcessorHot.__index = TProcessorHot
TProcessorHot.group = {}

local function TProcessorHot_from_obj(obj)
    return setmetatable(obj, TProcessorHot)
end

function TProcessorHot.new(ProcessorHot)
    return TProcessorHot_from_obj({ProcessorHot = ProcessorHot})
end
---@param obj CPU.ProcessorHot
function TProcessorHot:init_from_obj(obj)
    self.ProcessorHot = obj.ProcessorHot
end

function TProcessorHot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessorHot.group)
end

TProcessorHot.from_obj = TProcessorHot_from_obj

TProcessorHot.proto_property = {'ProcessorHot'}

TProcessorHot.default = {0}

TProcessorHot.struct = {{name = 'ProcessorHot', is_array = false, struct = nil}}

function TProcessorHot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessorHot', self.ProcessorHot, 'uint8', true, errs, need_convert)

    TProcessorHot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessorHot.proto_property, errs, need_convert)
    return self
end

function TProcessorHot:unpack(_)
    return self.ProcessorHot
end

CPU.ProcessorHot = TProcessorHot

---@class CPU.DeviceLocator
---@field DeviceLocator string
local TDeviceLocator = {}
TDeviceLocator.__index = TDeviceLocator
TDeviceLocator.group = {}

local function TDeviceLocator_from_obj(obj)
    return setmetatable(obj, TDeviceLocator)
end

function TDeviceLocator.new(DeviceLocator)
    return TDeviceLocator_from_obj({DeviceLocator = DeviceLocator})
end
---@param obj CPU.DeviceLocator
function TDeviceLocator:init_from_obj(obj)
    self.DeviceLocator = obj.DeviceLocator
end

function TDeviceLocator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceLocator.group)
end

TDeviceLocator.from_obj = TDeviceLocator_from_obj

TDeviceLocator.proto_property = {'DeviceLocator'}

TDeviceLocator.default = {''}

TDeviceLocator.struct = {{name = 'DeviceLocator', is_array = false, struct = nil}}

function TDeviceLocator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceLocator', self.DeviceLocator, 'string', true, errs, need_convert)

    TDeviceLocator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceLocator.proto_property, errs, need_convert)
    return self
end

function TDeviceLocator:unpack(_)
    return self.DeviceLocator
end

CPU.DeviceLocator = TDeviceLocator

---@class CPU.CATERR
---@field CATERR integer
local TCATERR = {}
TCATERR.__index = TCATERR
TCATERR.group = {}

local function TCATERR_from_obj(obj)
    return setmetatable(obj, TCATERR)
end

function TCATERR.new(CATERR)
    return TCATERR_from_obj({CATERR = CATERR or 0})
end
---@param obj CPU.CATERR
function TCATERR:init_from_obj(obj)
    self.CATERR = obj.CATERR or 0
end

function TCATERR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCATERR.group)
end

TCATERR.from_obj = TCATERR_from_obj

TCATERR.proto_property = {'CATERR'}

TCATERR.default = {0}

TCATERR.struct = {{name = 'CATERR', is_array = false, struct = nil}}

function TCATERR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CATERR', self.CATERR, 'uint8', true, errs, need_convert)

    TCATERR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCATERR.proto_property, errs, need_convert)
    return self
end

function TCATERR:unpack(_)
    return self.CATERR
end

CPU.CATERR = TCATERR

---@class CPU.PredictiveFault
---@field PredictiveFault integer
local TPredictiveFault = {}
TPredictiveFault.__index = TPredictiveFault
TPredictiveFault.group = {}

local function TPredictiveFault_from_obj(obj)
    return setmetatable(obj, TPredictiveFault)
end

function TPredictiveFault.new(PredictiveFault)
    return TPredictiveFault_from_obj({PredictiveFault = PredictiveFault or 0})
end
---@param obj CPU.PredictiveFault
function TPredictiveFault:init_from_obj(obj)
    self.PredictiveFault = obj.PredictiveFault or 0
end

function TPredictiveFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFault.group)
end

TPredictiveFault.from_obj = TPredictiveFault_from_obj

TPredictiveFault.proto_property = {'PredictiveFault'}

TPredictiveFault.default = {0}

TPredictiveFault.struct = {{name = 'PredictiveFault', is_array = false, struct = nil}}

function TPredictiveFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFault', self.PredictiveFault, 'uint8', false, errs, need_convert)

    TPredictiveFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFault.proto_property, errs, need_convert)
    return self
end

function TPredictiveFault:unpack(_)
    return self.PredictiveFault
end

CPU.PredictiveFault = TPredictiveFault

---@class CPU.DiagnosticFault
---@field DiagnosticFault integer
local TDiagnosticFault = {}
TDiagnosticFault.__index = TDiagnosticFault
TDiagnosticFault.group = {}

local function TDiagnosticFault_from_obj(obj)
    return setmetatable(obj, TDiagnosticFault)
end

function TDiagnosticFault.new(DiagnosticFault)
    return TDiagnosticFault_from_obj({DiagnosticFault = DiagnosticFault or 0})
end
---@param obj CPU.DiagnosticFault
function TDiagnosticFault:init_from_obj(obj)
    self.DiagnosticFault = obj.DiagnosticFault or 0
end

function TDiagnosticFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagnosticFault.group)
end

TDiagnosticFault.from_obj = TDiagnosticFault_from_obj

TDiagnosticFault.proto_property = {'DiagnosticFault'}

TDiagnosticFault.default = {0}

TDiagnosticFault.struct = {{name = 'DiagnosticFault', is_array = false, struct = nil}}

function TDiagnosticFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagnosticFault', self.DiagnosticFault, 'uint8', false, errs, need_convert)

    TDiagnosticFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagnosticFault.proto_property, errs, need_convert)
    return self
end

function TDiagnosticFault:unpack(_)
    return self.DiagnosticFault
end

CPU.DiagnosticFault = TDiagnosticFault

---@class CPU.MaxMemoryTemperatureName
---@field MaxMemoryTemperatureName string
local TMaxMemoryTemperatureName = {}
TMaxMemoryTemperatureName.__index = TMaxMemoryTemperatureName
TMaxMemoryTemperatureName.group = {}

local function TMaxMemoryTemperatureName_from_obj(obj)
    return setmetatable(obj, TMaxMemoryTemperatureName)
end

function TMaxMemoryTemperatureName.new(MaxMemoryTemperatureName)
    return TMaxMemoryTemperatureName_from_obj({MaxMemoryTemperatureName = MaxMemoryTemperatureName})
end
---@param obj CPU.MaxMemoryTemperatureName
function TMaxMemoryTemperatureName:init_from_obj(obj)
    self.MaxMemoryTemperatureName = obj.MaxMemoryTemperatureName
end

function TMaxMemoryTemperatureName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxMemoryTemperatureName.group)
end

TMaxMemoryTemperatureName.from_obj = TMaxMemoryTemperatureName_from_obj

TMaxMemoryTemperatureName.proto_property = {'MaxMemoryTemperatureName'}

TMaxMemoryTemperatureName.default = {''}

TMaxMemoryTemperatureName.struct = {{name = 'MaxMemoryTemperatureName', is_array = false, struct = nil}}

function TMaxMemoryTemperatureName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxMemoryTemperatureName', self.MaxMemoryTemperatureName, 'string', false, errs,
        need_convert)

    TMaxMemoryTemperatureName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxMemoryTemperatureName.proto_property, errs, need_convert)
    return self
end

function TMaxMemoryTemperatureName:unpack(_)
    return self.MaxMemoryTemperatureName
end

CPU.MaxMemoryTemperatureName = TMaxMemoryTemperatureName

---@class CPU.MaxMemoryTSensorTemperatureCelsius
---@field MaxMemoryTSensorTemperatureCelsius integer
local TMaxMemoryTSensorTemperatureCelsius = {}
TMaxMemoryTSensorTemperatureCelsius.__index = TMaxMemoryTSensorTemperatureCelsius
TMaxMemoryTSensorTemperatureCelsius.group = {}

local function TMaxMemoryTSensorTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TMaxMemoryTSensorTemperatureCelsius)
end

function TMaxMemoryTSensorTemperatureCelsius.new(MaxMemoryTSensorTemperatureCelsius)
    return TMaxMemoryTSensorTemperatureCelsius_from_obj({
        MaxMemoryTSensorTemperatureCelsius = MaxMemoryTSensorTemperatureCelsius
    })
end
---@param obj CPU.MaxMemoryTSensorTemperatureCelsius
function TMaxMemoryTSensorTemperatureCelsius:init_from_obj(obj)
    self.MaxMemoryTSensorTemperatureCelsius = obj.MaxMemoryTSensorTemperatureCelsius
end

function TMaxMemoryTSensorTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxMemoryTSensorTemperatureCelsius.group)
end

TMaxMemoryTSensorTemperatureCelsius.from_obj = TMaxMemoryTSensorTemperatureCelsius_from_obj

TMaxMemoryTSensorTemperatureCelsius.proto_property = {'MaxMemoryTSensorTemperatureCelsius'}

TMaxMemoryTSensorTemperatureCelsius.default = {0}

TMaxMemoryTSensorTemperatureCelsius.struct = {
    {name = 'MaxMemoryTSensorTemperatureCelsius', is_array = false, struct = nil}
}

function TMaxMemoryTSensorTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxMemoryTSensorTemperatureCelsius', self.MaxMemoryTSensorTemperatureCelsius, 'int16',
        false, errs, need_convert)

    TMaxMemoryTSensorTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxMemoryTSensorTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TMaxMemoryTSensorTemperatureCelsius:unpack(_)
    return self.MaxMemoryTSensorTemperatureCelsius
end

CPU.MaxMemoryTSensorTemperatureCelsius = TMaxMemoryTSensorTemperatureCelsius

---@class CPU.MaxMemoryTemperatureCelsius
---@field MaxMemoryTemperatureCelsius number
local TMaxMemoryTemperatureCelsius = {}
TMaxMemoryTemperatureCelsius.__index = TMaxMemoryTemperatureCelsius
TMaxMemoryTemperatureCelsius.group = {}

local function TMaxMemoryTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TMaxMemoryTemperatureCelsius)
end

function TMaxMemoryTemperatureCelsius.new(MaxMemoryTemperatureCelsius)
    return TMaxMemoryTemperatureCelsius_from_obj({MaxMemoryTemperatureCelsius = MaxMemoryTemperatureCelsius})
end
---@param obj CPU.MaxMemoryTemperatureCelsius
function TMaxMemoryTemperatureCelsius:init_from_obj(obj)
    self.MaxMemoryTemperatureCelsius = obj.MaxMemoryTemperatureCelsius
end

function TMaxMemoryTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxMemoryTemperatureCelsius.group)
end

TMaxMemoryTemperatureCelsius.from_obj = TMaxMemoryTemperatureCelsius_from_obj

TMaxMemoryTemperatureCelsius.proto_property = {'MaxMemoryTemperatureCelsius'}

TMaxMemoryTemperatureCelsius.default = {0}

TMaxMemoryTemperatureCelsius.struct = {{name = 'MaxMemoryTemperatureCelsius', is_array = false, struct = nil}}

function TMaxMemoryTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxMemoryTemperatureCelsius', self.MaxMemoryTemperatureCelsius, 'double', false, errs,
        need_convert)

    TMaxMemoryTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxMemoryTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TMaxMemoryTemperatureCelsius:unpack(_)
    return self.MaxMemoryTemperatureCelsius
end

CPU.MaxMemoryTemperatureCelsius = TMaxMemoryTemperatureCelsius

---@class CPU.TemperatureCelsius
---@field TemperatureCelsius number
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj CPU.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'double', false, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

CPU.TemperatureCelsius = TTemperatureCelsius

---@class CPU.Characteristics
---@field Characteristics string
local TCharacteristics = {}
TCharacteristics.__index = TCharacteristics
TCharacteristics.group = {}

local function TCharacteristics_from_obj(obj)
    return setmetatable(obj, TCharacteristics)
end

function TCharacteristics.new(Characteristics)
    return TCharacteristics_from_obj({Characteristics = Characteristics})
end
---@param obj CPU.Characteristics
function TCharacteristics:init_from_obj(obj)
    self.Characteristics = obj.Characteristics
end

function TCharacteristics:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCharacteristics.group)
end

TCharacteristics.from_obj = TCharacteristics_from_obj

TCharacteristics.proto_property = {'Characteristics'}

TCharacteristics.default = {''}

TCharacteristics.struct = {{name = 'Characteristics', is_array = false, struct = nil}}

function TCharacteristics:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Characteristics', self.Characteristics, 'string', true, errs, need_convert)

    TCharacteristics:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCharacteristics.proto_property, errs, need_convert)
    return self
end

function TCharacteristics:unpack(_)
    return self.Characteristics
end

CPU.Characteristics = TCharacteristics

---@class CPU.L3Cache
---@field L3Cache integer
local TL3Cache = {}
TL3Cache.__index = TL3Cache
TL3Cache.group = {}

local function TL3Cache_from_obj(obj)
    return setmetatable(obj, TL3Cache)
end

function TL3Cache.new(L3Cache)
    return TL3Cache_from_obj({L3Cache = L3Cache})
end
---@param obj CPU.L3Cache
function TL3Cache:init_from_obj(obj)
    self.L3Cache = obj.L3Cache
end

function TL3Cache:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TL3Cache.group)
end

TL3Cache.from_obj = TL3Cache_from_obj

TL3Cache.proto_property = {'L3Cache'}

TL3Cache.default = {0}

TL3Cache.struct = {{name = 'L3Cache', is_array = false, struct = nil}}

function TL3Cache:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'L3Cache', self.L3Cache, 'uint32', true, errs, need_convert)

    TL3Cache:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TL3Cache.proto_property, errs, need_convert)
    return self
end

function TL3Cache:unpack(_)
    return self.L3Cache
end

CPU.L3Cache = TL3Cache

---@class CPU.L2Cache
---@field L2Cache integer
local TL2Cache = {}
TL2Cache.__index = TL2Cache
TL2Cache.group = {}

local function TL2Cache_from_obj(obj)
    return setmetatable(obj, TL2Cache)
end

function TL2Cache.new(L2Cache)
    return TL2Cache_from_obj({L2Cache = L2Cache})
end
---@param obj CPU.L2Cache
function TL2Cache:init_from_obj(obj)
    self.L2Cache = obj.L2Cache
end

function TL2Cache:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TL2Cache.group)
end

TL2Cache.from_obj = TL2Cache_from_obj

TL2Cache.proto_property = {'L2Cache'}

TL2Cache.default = {0}

TL2Cache.struct = {{name = 'L2Cache', is_array = false, struct = nil}}

function TL2Cache:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'L2Cache', self.L2Cache, 'uint32', true, errs, need_convert)

    TL2Cache:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TL2Cache.proto_property, errs, need_convert)
    return self
end

function TL2Cache:unpack(_)
    return self.L2Cache
end

CPU.L2Cache = TL2Cache

---@class CPU.L1Cache
---@field L1Cache integer
local TL1Cache = {}
TL1Cache.__index = TL1Cache
TL1Cache.group = {}

local function TL1Cache_from_obj(obj)
    return setmetatable(obj, TL1Cache)
end

function TL1Cache.new(L1Cache)
    return TL1Cache_from_obj({L1Cache = L1Cache})
end
---@param obj CPU.L1Cache
function TL1Cache:init_from_obj(obj)
    self.L1Cache = obj.L1Cache
end

function TL1Cache:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TL1Cache.group)
end

TL1Cache.from_obj = TL1Cache_from_obj

TL1Cache.proto_property = {'L1Cache'}

TL1Cache.default = {0}

TL1Cache.struct = {{name = 'L1Cache', is_array = false, struct = nil}}

function TL1Cache:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'L1Cache', self.L1Cache, 'uint32', true, errs, need_convert)

    TL1Cache:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TL1Cache.proto_property, errs, need_convert)
    return self
end

function TL1Cache:unpack(_)
    return self.L1Cache
end

CPU.L1Cache = TL1Cache

---@class CPU.TotalThreads
---@field TotalThreads integer
local TTotalThreads = {}
TTotalThreads.__index = TTotalThreads
TTotalThreads.group = {}

local function TTotalThreads_from_obj(obj)
    return setmetatable(obj, TTotalThreads)
end

function TTotalThreads.new(TotalThreads)
    return TTotalThreads_from_obj({TotalThreads = TotalThreads})
end
---@param obj CPU.TotalThreads
function TTotalThreads:init_from_obj(obj)
    self.TotalThreads = obj.TotalThreads
end

function TTotalThreads:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalThreads.group)
end

TTotalThreads.from_obj = TTotalThreads_from_obj

TTotalThreads.proto_property = {'TotalThreads'}

TTotalThreads.default = {0}

TTotalThreads.struct = {{name = 'TotalThreads', is_array = false, struct = nil}}

function TTotalThreads:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalThreads', self.TotalThreads, 'uint32', true, errs, need_convert)

    TTotalThreads:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalThreads.proto_property, errs, need_convert)
    return self
end

function TTotalThreads:unpack(_)
    return self.TotalThreads
end

CPU.TotalThreads = TTotalThreads

---@class CPU.TotalEnabledCores
---@field TotalEnabledCores integer
local TTotalEnabledCores = {}
TTotalEnabledCores.__index = TTotalEnabledCores
TTotalEnabledCores.group = {}

local function TTotalEnabledCores_from_obj(obj)
    return setmetatable(obj, TTotalEnabledCores)
end

function TTotalEnabledCores.new(TotalEnabledCores)
    return TTotalEnabledCores_from_obj({TotalEnabledCores = TotalEnabledCores})
end
---@param obj CPU.TotalEnabledCores
function TTotalEnabledCores:init_from_obj(obj)
    self.TotalEnabledCores = obj.TotalEnabledCores
end

function TTotalEnabledCores:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalEnabledCores.group)
end

TTotalEnabledCores.from_obj = TTotalEnabledCores_from_obj

TTotalEnabledCores.proto_property = {'TotalEnabledCores'}

TTotalEnabledCores.default = {0}

TTotalEnabledCores.struct = {{name = 'TotalEnabledCores', is_array = false, struct = nil}}

function TTotalEnabledCores:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalEnabledCores', self.TotalEnabledCores, 'uint32', true, errs, need_convert)

    TTotalEnabledCores:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalEnabledCores.proto_property, errs, need_convert)
    return self
end

function TTotalEnabledCores:unpack(_)
    return self.TotalEnabledCores
end

CPU.TotalEnabledCores = TTotalEnabledCores

---@class CPU.TotalCores
---@field TotalCores integer
local TTotalCores = {}
TTotalCores.__index = TTotalCores
TTotalCores.group = {}

local function TTotalCores_from_obj(obj)
    return setmetatable(obj, TTotalCores)
end

function TTotalCores.new(TotalCores)
    return TTotalCores_from_obj({TotalCores = TotalCores})
end
---@param obj CPU.TotalCores
function TTotalCores:init_from_obj(obj)
    self.TotalCores = obj.TotalCores
end

function TTotalCores:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalCores.group)
end

TTotalCores.from_obj = TTotalCores_from_obj

TTotalCores.proto_property = {'TotalCores'}

TTotalCores.default = {0}

TTotalCores.struct = {{name = 'TotalCores', is_array = false, struct = nil}}

function TTotalCores:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalCores', self.TotalCores, 'uint32', true, errs, need_convert)

    TTotalCores:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalCores.proto_property, errs, need_convert)
    return self
end

function TTotalCores:unpack(_)
    return self.TotalCores
end

CPU.TotalCores = TTotalCores

---@class CPU.ProcessorIDString
---@field ProcessorIDString string
local TProcessorIDString = {}
TProcessorIDString.__index = TProcessorIDString
TProcessorIDString.group = {}

local function TProcessorIDString_from_obj(obj)
    return setmetatable(obj, TProcessorIDString)
end

function TProcessorIDString.new(ProcessorIDString)
    return TProcessorIDString_from_obj({ProcessorIDString = ProcessorIDString})
end
---@param obj CPU.ProcessorIDString
function TProcessorIDString:init_from_obj(obj)
    self.ProcessorIDString = obj.ProcessorIDString
end

function TProcessorIDString:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessorIDString.group)
end

TProcessorIDString.from_obj = TProcessorIDString_from_obj

TProcessorIDString.proto_property = {'ProcessorIDString'}

TProcessorIDString.default = {''}

TProcessorIDString.struct = {{name = 'ProcessorIDString', is_array = false, struct = nil}}

function TProcessorIDString:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessorIDString', self.ProcessorIDString, 'string', true, errs, need_convert)

    TProcessorIDString:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessorIDString.proto_property, errs, need_convert)
    return self
end

function TProcessorIDString:unpack(_)
    return self.ProcessorIDString
end

CPU.ProcessorIDString = TProcessorIDString

---@class CPU.ProcessorID
---@field ProcessorID integer
local TProcessorID = {}
TProcessorID.__index = TProcessorID
TProcessorID.group = {}

local function TProcessorID_from_obj(obj)
    return setmetatable(obj, TProcessorID)
end

function TProcessorID.new(ProcessorID)
    return TProcessorID_from_obj({ProcessorID = ProcessorID})
end
---@param obj CPU.ProcessorID
function TProcessorID:init_from_obj(obj)
    self.ProcessorID = obj.ProcessorID
end

function TProcessorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProcessorID.group)
end

TProcessorID.from_obj = TProcessorID_from_obj

TProcessorID.proto_property = {'ProcessorID'}

TProcessorID.default = {0}

TProcessorID.struct = {{name = 'ProcessorID', is_array = false, struct = nil}}

function TProcessorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessorID', self.ProcessorID, 'uint32', true, errs, need_convert)

    TProcessorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProcessorID.proto_property, errs, need_convert)
    return self
end

function TProcessorID:unpack(_)
    return self.ProcessorID
end

CPU.ProcessorID = TProcessorID

---@class CPU.CurrentSpeedMHz
---@field CurrentSpeedMHz integer
local TCurrentSpeedMHz = {}
TCurrentSpeedMHz.__index = TCurrentSpeedMHz
TCurrentSpeedMHz.group = {}

local function TCurrentSpeedMHz_from_obj(obj)
    return setmetatable(obj, TCurrentSpeedMHz)
end

function TCurrentSpeedMHz.new(CurrentSpeedMHz)
    return TCurrentSpeedMHz_from_obj({CurrentSpeedMHz = CurrentSpeedMHz})
end
---@param obj CPU.CurrentSpeedMHz
function TCurrentSpeedMHz:init_from_obj(obj)
    self.CurrentSpeedMHz = obj.CurrentSpeedMHz
end

function TCurrentSpeedMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentSpeedMHz.group)
end

TCurrentSpeedMHz.from_obj = TCurrentSpeedMHz_from_obj

TCurrentSpeedMHz.proto_property = {'CurrentSpeedMHz'}

TCurrentSpeedMHz.default = {0}

TCurrentSpeedMHz.struct = {{name = 'CurrentSpeedMHz', is_array = false, struct = nil}}

function TCurrentSpeedMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentSpeedMHz', self.CurrentSpeedMHz, 'uint32', true, errs, need_convert)

    TCurrentSpeedMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentSpeedMHz.proto_property, errs, need_convert)
    return self
end

function TCurrentSpeedMHz:unpack(_)
    return self.CurrentSpeedMHz
end

CPU.CurrentSpeedMHz = TCurrentSpeedMHz

---@class CPU.MaxSpeedMHz
---@field MaxSpeedMHz integer
local TMaxSpeedMHz = {}
TMaxSpeedMHz.__index = TMaxSpeedMHz
TMaxSpeedMHz.group = {}

local function TMaxSpeedMHz_from_obj(obj)
    return setmetatable(obj, TMaxSpeedMHz)
end

function TMaxSpeedMHz.new(MaxSpeedMHz)
    return TMaxSpeedMHz_from_obj({MaxSpeedMHz = MaxSpeedMHz})
end
---@param obj CPU.MaxSpeedMHz
function TMaxSpeedMHz:init_from_obj(obj)
    self.MaxSpeedMHz = obj.MaxSpeedMHz
end

function TMaxSpeedMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxSpeedMHz.group)
end

TMaxSpeedMHz.from_obj = TMaxSpeedMHz_from_obj

TMaxSpeedMHz.proto_property = {'MaxSpeedMHz'}

TMaxSpeedMHz.default = {0}

TMaxSpeedMHz.struct = {{name = 'MaxSpeedMHz', is_array = false, struct = nil}}

function TMaxSpeedMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxSpeedMHz', self.MaxSpeedMHz, 'uint32', true, errs, need_convert)

    TMaxSpeedMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxSpeedMHz.proto_property, errs, need_convert)
    return self
end

function TMaxSpeedMHz:unpack(_)
    return self.MaxSpeedMHz
end

CPU.MaxSpeedMHz = TMaxSpeedMHz

---@class CPU.LogicalId
---@field LogicalId integer
local TLogicalId = {}
TLogicalId.__index = TLogicalId
TLogicalId.group = {}

local function TLogicalId_from_obj(obj)
    return setmetatable(obj, TLogicalId)
end

function TLogicalId.new(LogicalId)
    return TLogicalId_from_obj({LogicalId = LogicalId})
end
---@param obj CPU.LogicalId
function TLogicalId:init_from_obj(obj)
    self.LogicalId = obj.LogicalId
end

function TLogicalId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicalId.group)
end

TLogicalId.from_obj = TLogicalId_from_obj

TLogicalId.proto_property = {'LogicalId'}

TLogicalId.default = {0}

TLogicalId.struct = {{name = 'LogicalId', is_array = false, struct = nil}}

function TLogicalId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicalId', self.LogicalId, 'uint8', true, errs, need_convert)

    TLogicalId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicalId.proto_property, errs, need_convert)
    return self
end

function TLogicalId:unpack(_)
    return self.LogicalId
end

CPU.LogicalId = TLogicalId

---@class CPU.PhysicalId
---@field PhysicalId integer
local TPhysicalId = {}
TPhysicalId.__index = TPhysicalId
TPhysicalId.group = {}

local function TPhysicalId_from_obj(obj)
    return setmetatable(obj, TPhysicalId)
end

function TPhysicalId.new(PhysicalId)
    return TPhysicalId_from_obj({PhysicalId = PhysicalId})
end
---@param obj CPU.PhysicalId
function TPhysicalId:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId
end

function TPhysicalId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalId.group)
end

TPhysicalId.from_obj = TPhysicalId_from_obj

TPhysicalId.proto_property = {'PhysicalId'}

TPhysicalId.default = {0}

TPhysicalId.struct = {{name = 'PhysicalId', is_array = false, struct = nil}}

function TPhysicalId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalId', self.PhysicalId, 'uint8', true, errs, need_convert)

    TPhysicalId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalId.proto_property, errs, need_convert)
    return self
end

function TPhysicalId:unpack(_)
    return self.PhysicalId
end

CPU.PhysicalId = TPhysicalId

CPU.interface = mdb.register_interface('bmc.kepler.Systems.Processor.CPU', {
    PhysicalId = {'y', nil, true, nil, false},
    LogicalId = {'y', nil, true, nil, false},
    MaxSpeedMHz = {'u', nil, true, nil, false},
    CurrentSpeedMHz = {'u', {'EMIT_CHANGE'}, true, nil, false},
    ProcessorID = {'u', nil, true, nil, false},
    ProcessorIDString = {'s', nil, true, nil, false},
    TotalCores = {'u', nil, true, nil, false},
    TotalEnabledCores = {'u', nil, true, nil, false},
    TotalThreads = {'u', nil, true, nil, false},
    L1Cache = {'u', nil, true, nil, false},
    L2Cache = {'u', nil, true, nil, false},
    L3Cache = {'u', nil, true, nil, false},
    Characteristics = {'s', nil, true, nil, false},
    TemperatureCelsius = {'d', {'EMIT_CHANGE'}, false, nil, false},
    MaxMemoryTemperatureCelsius = {'d', {'EMIT_CHANGE'}, false, nil, false},
    MaxMemoryTSensorTemperatureCelsius = {'n', {'EMIT_CHANGE'}, false, nil, false},
    MaxMemoryTemperatureName = {'s', nil, false, nil, false},
    DiagnosticFault = {'y', nil, false, 0, false},
    PredictiveFault = {'y', nil, false, 0, false},
    CATERR = {'y', nil, true, 0, false},
    DeviceLocator = {'s', nil, true, nil, false},
    ProcessorHot = {'y', nil, true, nil, false},
    Enabled = {'b', nil, true, nil, false},
    PowerGood = {'y', nil, true, nil, false},
    IsMemoryPresence = {'y', nil, true, nil, false},
    PowerWatt = {'d', {'EMIT_CHANGE'}, true, nil, false},
    TotalEnabledThreads = {'u', {'EMIT_CHANGE'}, true, nil, false},
    SilkText = {'s', {}, true, nil, false},
    BaseSpeedMHz = {'u', {}, true, nil, false}
}, {}, {})

return CPU
