-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MPCIeIPMIChannelConfig = {}

---@class MPCIeIPMIChannelConfig.Maps
---@field Maps def_types.IPMIChannelConfig[]
local TMaps = {}
TMaps.__index = TMaps
TMaps.group = {}

local function TMaps_from_obj(obj)
    obj.Maps = utils.from_obj(def_types.IPMIChannelConfig, obj.Maps, true)
    return setmetatable(obj, TMaps)
end

function TMaps.new(Maps)
    return TMaps_from_obj({Maps = Maps})
end
---@param obj MPCIeIPMIChannelConfig.Maps
function TMaps:init_from_obj(obj)
    self.Maps = obj.Maps
end

function TMaps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaps.group)
end

TMaps.from_obj = TMaps_from_obj

TMaps.proto_property = {'Maps'}

TMaps.default = {{}}

TMaps.struct = {{name = 'Maps', is_array = true, struct = def_types.IPMIChannelConfig.struct}}

function TMaps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Maps) do
        def_types.IPMIChannelConfig.new(v.HostId, v.Instance):validate(prefix, errs, need_convert)
    end

    TMaps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaps.proto_property, errs, need_convert)
    return self
end

function TMaps:unpack(raw)
    return utils.unpack(raw, self.Maps, true)
end

MPCIeIPMIChannelConfig.Maps = TMaps

return MPCIeIPMIChannelConfig
