-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeDevice = {}

---@class MPCIeDevice.MultihostPresence
---@field MultihostPresence integer
local TMultihostPresence = {}
TMultihostPresence.__index = TMultihostPresence
TMultihostPresence.group = {}

local function TMultihostPresence_from_obj(obj)
    return setmetatable(obj, TMultihostPresence)
end

function TMultihostPresence.new(MultihostPresence)
    return TMultihostPresence_from_obj({MultihostPresence = MultihostPresence})
end
---@param obj MPCIeDevice.MultihostPresence
function TMultihostPresence:init_from_obj(obj)
    self.MultihostPresence = obj.MultihostPresence
end

function TMultihostPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostPresence.group)
end

TMultihostPresence.from_obj = TMultihostPresence_from_obj

TMultihostPresence.proto_property = {'MultihostPresence'}

TMultihostPresence.default = {0}

TMultihostPresence.struct = {{name = 'MultihostPresence', is_array = false, struct = nil}}

function TMultihostPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultihostPresence', self.MultihostPresence, 'uint32', false, errs, need_convert)

    TMultihostPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostPresence.proto_property, errs, need_convert)
    return self
end

function TMultihostPresence:unpack(_)
    return self.MultihostPresence
end

MPCIeDevice.MultihostPresence = TMultihostPresence

---@class MPCIeDevice.GroupPosition
---@field GroupPosition string
local TGroupPosition = {}
TGroupPosition.__index = TGroupPosition
TGroupPosition.group = {}

local function TGroupPosition_from_obj(obj)
    return setmetatable(obj, TGroupPosition)
end

function TGroupPosition.new(GroupPosition)
    return TGroupPosition_from_obj({GroupPosition = GroupPosition})
end
---@param obj MPCIeDevice.GroupPosition
function TGroupPosition:init_from_obj(obj)
    self.GroupPosition = obj.GroupPosition
end

function TGroupPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupPosition.group)
end

TGroupPosition.from_obj = TGroupPosition_from_obj

TGroupPosition.proto_property = {'GroupPosition'}

TGroupPosition.default = {''}

TGroupPosition.struct = {{name = 'GroupPosition', is_array = false, struct = nil}}

function TGroupPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'GroupPosition', self.GroupPosition, 'string', false, errs, need_convert)

    TGroupPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupPosition.proto_property, errs, need_convert)
    return self
end

function TGroupPosition:unpack(_)
    return self.GroupPosition
end

MPCIeDevice.GroupPosition = TGroupPosition

---@class MPCIeDevice.RefComponent
---@field RefComponent string
local TRefComponent = {}
TRefComponent.__index = TRefComponent
TRefComponent.group = {}

local function TRefComponent_from_obj(obj)
    return setmetatable(obj, TRefComponent)
end

function TRefComponent.new(RefComponent)
    return TRefComponent_from_obj({RefComponent = RefComponent})
end
---@param obj MPCIeDevice.RefComponent
function TRefComponent:init_from_obj(obj)
    self.RefComponent = obj.RefComponent
end

function TRefComponent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefComponent.group)
end

TRefComponent.from_obj = TRefComponent_from_obj

TRefComponent.proto_property = {'RefComponent'}

TRefComponent.default = {''}

TRefComponent.struct = {{name = 'RefComponent', is_array = false, struct = nil}}

function TRefComponent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefComponent', self.RefComponent, 'string', true, errs, need_convert)

    TRefComponent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefComponent.proto_property, errs, need_convert)
    return self
end

function TRefComponent:unpack(_)
    return self.RefComponent
end

MPCIeDevice.RefComponent = TRefComponent

---@class MPCIeDevice.DeviceType
---@field DeviceType integer
local TDeviceType = {}
TDeviceType.__index = TDeviceType
TDeviceType.group = {}

local function TDeviceType_from_obj(obj)
    return setmetatable(obj, TDeviceType)
end

function TDeviceType.new(DeviceType)
    return TDeviceType_from_obj({DeviceType = DeviceType})
end
---@param obj MPCIeDevice.DeviceType
function TDeviceType:init_from_obj(obj)
    self.DeviceType = obj.DeviceType
end

function TDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceType.group)
end

TDeviceType.from_obj = TDeviceType_from_obj

TDeviceType.proto_property = {'DeviceType'}

TDeviceType.default = {0}

TDeviceType.struct = {{name = 'DeviceType', is_array = false, struct = nil}}

function TDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)

    TDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceType.proto_property, errs, need_convert)
    return self
end

function TDeviceType:unpack(_)
    return self.DeviceType
end

MPCIeDevice.DeviceType = TDeviceType

---@class MPCIeDevice.Container
---@field Container string
local TContainer = {}
TContainer.__index = TContainer
TContainer.group = {}

local function TContainer_from_obj(obj)
    return setmetatable(obj, TContainer)
end

function TContainer.new(Container)
    return TContainer_from_obj({Container = Container})
end
---@param obj MPCIeDevice.Container
function TContainer:init_from_obj(obj)
    self.Container = obj.Container
end

function TContainer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainer.group)
end

TContainer.from_obj = TContainer_from_obj

TContainer.proto_property = {'Container'}

TContainer.default = {''}

TContainer.struct = {{name = 'Container', is_array = false, struct = nil}}

function TContainer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Container', self.Container, 'string', false, errs, need_convert)

    TContainer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainer.proto_property, errs, need_convert)
    return self
end

function TContainer:unpack(_)
    return self.Container
end

MPCIeDevice.Container = TContainer

return MPCIeDevice
