-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = require 'class.types.types'

local MPCIeCardFlashChecker = {}

---@class MPCIeCardFlashChecker.PCIeQuadrupleList
---@field PCIeQuadrupleList def_types.IdAndDescription[]
local TPCIeQuadrupleList = {}
TPCIeQuadrupleList.__index = TPCIeQuadrupleList
TPCIeQuadrupleList.group = {}

local function TPCIeQuadrupleList_from_obj(obj)
    obj.PCIeQuadrupleList = utils.from_obj(def_types.IdAndDescription, obj.PCIeQuadrupleList, true)
    return setmetatable(obj, TPCIeQuadrupleList)
end

function TPCIeQuadrupleList.new(PCIeQuadrupleList)
    return TPCIeQuadrupleList_from_obj({PCIeQuadrupleList = PCIeQuadrupleList})
end
---@param obj MPCIeCardFlashChecker.PCIeQuadrupleList
function TPCIeQuadrupleList:init_from_obj(obj)
    self.PCIeQuadrupleList = obj.PCIeQuadrupleList
end

function TPCIeQuadrupleList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeQuadrupleList.group)
end

TPCIeQuadrupleList.from_obj = TPCIeQuadrupleList_from_obj

TPCIeQuadrupleList.proto_property = {'PCIeQuadrupleList'}

TPCIeQuadrupleList.default = {{}}

TPCIeQuadrupleList.struct = {{name = 'PCIeQuadrupleList', is_array = true, struct = def_types.IdAndDescription.struct}}

function TPCIeQuadrupleList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PCIeQuadrupleList) do
        def_types.IdAndDescription.new(v.Id, v.Description):validate(prefix, errs, need_convert)
    end

    TPCIeQuadrupleList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeQuadrupleList.proto_property, errs, need_convert)
    return self
end

function TPCIeQuadrupleList:unpack(raw)
    return utils.unpack(raw, self.PCIeQuadrupleList, true)
end

MPCIeCardFlashChecker.PCIeQuadrupleList = TPCIeQuadrupleList

---@class MPCIeCardFlashChecker.FaultStatus
---@field FaultStatus integer
local TFaultStatus = {}
TFaultStatus.__index = TFaultStatus
TFaultStatus.group = {}

local function TFaultStatus_from_obj(obj)
    return setmetatable(obj, TFaultStatus)
end

function TFaultStatus.new(FaultStatus)
    return TFaultStatus_from_obj({FaultStatus = FaultStatus})
end
---@param obj MPCIeCardFlashChecker.FaultStatus
function TFaultStatus:init_from_obj(obj)
    self.FaultStatus = obj.FaultStatus
end

function TFaultStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultStatus.group)
end

TFaultStatus.from_obj = TFaultStatus_from_obj

TFaultStatus.proto_property = {'FaultStatus'}

TFaultStatus.default = {0}

TFaultStatus.struct = {{name = 'FaultStatus', is_array = false, struct = nil}}

function TFaultStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultStatus', self.FaultStatus, 'uint8', false, errs, need_convert)

    TFaultStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultStatus.proto_property, errs, need_convert)
    return self
end

function TFaultStatus:unpack(_)
    return self.FaultStatus
end

MPCIeCardFlashChecker.FaultStatus = TFaultStatus

---@class MPCIeCardFlashChecker.GroupPosition
---@field GroupPosition string
local TGroupPosition = {}
TGroupPosition.__index = TGroupPosition
TGroupPosition.group = {}

local function TGroupPosition_from_obj(obj)
    return setmetatable(obj, TGroupPosition)
end

function TGroupPosition.new(GroupPosition)
    return TGroupPosition_from_obj({GroupPosition = GroupPosition})
end
---@param obj MPCIeCardFlashChecker.GroupPosition
function TGroupPosition:init_from_obj(obj)
    self.GroupPosition = obj.GroupPosition
end

function TGroupPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupPosition.group)
end

TGroupPosition.from_obj = TGroupPosition_from_obj

TGroupPosition.proto_property = {'GroupPosition'}

TGroupPosition.default = {''}

TGroupPosition.struct = {{name = 'GroupPosition', is_array = false, struct = nil}}

function TGroupPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'GroupPosition', self.GroupPosition, 'string', false, errs, need_convert)

    TGroupPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupPosition.proto_property, errs, need_convert)
    return self
end

function TGroupPosition:unpack(_)
    return self.GroupPosition
end

MPCIeCardFlashChecker.GroupPosition = TGroupPosition

return MPCIeCardFlashChecker
