-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local pc_ie_device_class_types = require 'class.types.PCIeDevice'
local pc_ie_card_class_types = require 'class.types.PCIeCard'
local pcie_addr_info_class_types = require 'class.types.PcieAddrInfo'
local business_connector_class_types = require 'class.types.BusinessConnector'
local ser_des_class_types = require 'class.types.SerDes'
local unit_configuration_class_types = require 'class.types.UnitConfiguration'
local business_topo_node_class_types = require 'class.types.BusinessTopoNode'
local bdf_config_class_types = require 'class.types.BDFConfig'
local cpu_bus_info_class_types = require 'class.types.CpuBusInfo'
local pc_ie_vpd_info_class_types = require 'class.types.PCIeVPDInfo'
local pc_ie_load_info_class_types = require 'class.types.PCIeLoadInfo'
local pc_ie_load_info_backup_class_types = require 'class.types.PCIeLoadInfoBackup'
local pc_ie_ipmi_channel_config_class_types = require 'class.types.PCIeIPMIChannelConfig'
local pc_ie_card_flash_checker_class_types = require 'class.types.PCIeCardFlashChecker'
local pc_ie_devices_intf_types = require 'pcie_device.json_types.PCIeDevices'
local properties_intf_types = require 'pcie_device.json_types.Properties'
local pc_ie_device_intf_types = require 'pcie_device.json_types.PCIeDevice'
local ras_intf_types = require 'pcie_device.json_types.RAS'
local pc_ie_card_intf_types = require 'pcie_device.json_types.PCIeCard'
local unit_intf_types = require 'pcie_device.json_types.Unit'
local pcie_addr_info_intf_types = require 'pcie_device.json_types.PcieAddrInfo'
local unit_config_error_intf_types = require 'pcie_device.json_types.UnitConfigError'
local eth_device_intf_types = require 'pcie_device.json_types.EthDevice'

local PCIeDevices = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices'] = {
            ['SetPcieErrorStatus'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'SocketID'},
                    {['baseType'] = 'U8', ['param'] = 'Bus'}, {['baseType'] = 'U8', ['param'] = 'Device'},
                    {['baseType'] = 'U8', ['param'] = 'Function'}, {['baseType'] = 'String', ['param'] = 'ErrorType'},
                    {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['SetBandwidthReduction'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'Bus'},
                    {['baseType'] = 'U8', ['param'] = 'Device'}, {['baseType'] = 'U8', ['param'] = 'Function'},
                    {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['SetUCEByBIOS'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'Bus'},
                    {['baseType'] = 'U8', ['param'] = 'Device'}, {['baseType'] = 'U8', ['param'] = 'Function'},
                    {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['SetDiagnosticFault'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'SocketID'},
                    {['baseType'] = 'U8', ['param'] = 'Bus'}, {['baseType'] = 'U8', ['param'] = 'Device'},
                    {['baseType'] = 'U8', ['param'] = 'Function'}, {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['SetPredictiveFault'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'SocketID'},
                    {['baseType'] = 'U8', ['param'] = 'Bus'}, {['baseType'] = 'U8', ['param'] = 'Device'},
                    {['baseType'] = 'U8', ['param'] = 'Function'}, {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['GetDeviceName'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'SocketID'},
                    {['baseType'] = 'U8', ['param'] = 'Bus'}, {['baseType'] = 'U8', ['param'] = 'Device'},
                    {['baseType'] = 'U8', ['param'] = 'Function'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U8', ['param'] = 'Status'}, {['baseType'] = 'String', ['param'] = 'DeviceName'}
                }
            },
            ['GetPCIeCardNum'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'PCIeCardNum'}}},
            ['SetFaultByBios'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Bus'}, {['baseType'] = 'U8', ['param'] = 'Device'},
                    {['baseType'] = 'U8', ['param'] = 'Function'}, {['baseType'] = 'U8', ['param'] = 'FaultStatus'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            },
            ['SetLinkSpeedReduced'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Segment'}, {['baseType'] = 'U8', ['param'] = 'Bus'},
                    {['baseType'] = 'U8', ['param'] = 'Device'}, {['baseType'] = 'U8', ['param'] = 'Function'},
                    {['baseType'] = 'U8', ['param'] = 'Value'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PCIeDevices'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = pc_ie_devices_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PCIeDevice = {
    ['table_name'] = 't_pcie_dev_info',
    ['prop_configs'] = {
        ['Container'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = pc_ie_device_class_types.Container
        },
        ['DeviceType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = pc_ie_device_class_types.DeviceType
        },
        ['RefComponent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['readOnly'] = true,
            ['validator'] = pc_ie_device_class_types.RefComponent
        },
        ['GroupPosition'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = pc_ie_device_class_types.GroupPosition
        },
        ['MultihostPresence'] = {['baseType'] = 'U32', ['validator'] = pc_ie_device_class_types.MultihostPresence}
    },
    ['default_props'] = {
        ['Container'] = pc_ie_device_class_types.Container.default[1],
        ['DeviceType'] = pc_ie_device_class_types.DeviceType.default[1],
        ['RefComponent'] = pc_ie_device_class_types.RefComponent.default[1],
        ['GroupPosition'] = pc_ie_device_class_types.GroupPosition.default[1],
        ['MultihostPresence'] = pc_ie_device_class_types.MultihostPresence.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices.PCIeDevice'] = {
            ['SlotID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.SlotID
            },
            ['Segment'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.Segment
            },
            ['SocketID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.SocketID
            },
            ['Bus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.Bus
            },
            ['Device'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.Device
            },
            ['Function'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.Function
            },
            ['DevBus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.DevBus
            },
            ['DevDevice'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.DevDevice
            },
            ['DevFunction'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.DevFunction
            },
            ['DiagnosticFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['validator'] = pc_ie_device_intf_types.DiagnosticFault
            },
            ['PredictiveFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['validator'] = pc_ie_device_intf_types.PredictiveFault
            },
            ['UCEByBIOS'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['validator'] = pc_ie_device_intf_types.UCEByBIOS
            },
            ['BandwidthReduction'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['validator'] = pc_ie_device_intf_types.BandwidthReduction
            },
            ['LinkSpeedReduced'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['validator'] = pc_ie_device_intf_types.LinkSpeedReduced
            },
            ['FunctionClass'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.FunctionClass
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.DeviceName
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.Position
            },
            ['FaultByBios'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.FaultByBios
            },
            ['SlotType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'FullLength', 'HalfLength', 'LowProfile', 'M2', 'Mini', 'OCP3Large', 'OCP3Small', 'OEM', 'U2'
                },
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.SlotType
            },
            ['FunctionProtocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'CXL', 'PCIe'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.FunctionProtocol
            },
            ['FunctionType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Physical', 'Virtual'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.FunctionType
            },
            ['PCIeType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.PCIeType
            },
            ['PCIeDeviceType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'MultiFunction', 'Retimer', 'Simulated', 'SingleFunction'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_device_intf_types.PCIeDeviceType
            },
            ['BaseClassCode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pc_ie_device_intf_types.BaseClassCode
            },
            ['SubClassCode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pc_ie_device_intf_types.SubClassCode
            },
            ['ProgrammingInterface'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pc_ie_device_intf_types.ProgrammingInterface
            },
            ['MaxPCIeType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5', 'Gen6'},
                ['validator'] = pc_ie_device_intf_types.MaxPCIeType
            },
            ['NegotiatedPCIeType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5', 'Gen6'},
                ['validator'] = pc_ie_device_intf_types.NegotiatedPCIeType
            }
        },
        ['bmc.kepler.Systems.PCIeDevices.PCIeDevice.RAS'] = {
            ['CorrectableError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = ras_intf_types.CorrectableError
            },
            ['UncorrectableError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = ras_intf_types.UncorrectableError
            },
            ['FatalError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = ras_intf_types.FatalError
            },
            ['ParityError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = ras_intf_types.ParityError
            },
            ['SystemError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = ras_intf_types.SystemError
            },
            ['FatalErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = ras_intf_types.FatalErrorCount
            },
            ['NonFatalErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = ras_intf_types.NonFatalErrorCount
            },
            ['CorrectableErrorOverfrequencyCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = ras_intf_types.CorrectableErrorOverfrequencyCount
            },
            ['TimeoutError'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'ResetPer', 'SHM'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['validator'] = ras_intf_types.TimeoutError
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PCIeDevices.PCIeDevice'] = {
            ['property_defaults'] = {
                ['SlotID'] = pc_ie_device_intf_types.SlotID.default[1],
                ['Segment'] = pc_ie_device_intf_types.Segment.default[1],
                ['SocketID'] = pc_ie_device_intf_types.SocketID.default[1],
                ['Bus'] = pc_ie_device_intf_types.Bus.default[1],
                ['Device'] = pc_ie_device_intf_types.Device.default[1],
                ['Function'] = pc_ie_device_intf_types.Function.default[1],
                ['DevBus'] = pc_ie_device_intf_types.DevBus.default[1],
                ['DevDevice'] = pc_ie_device_intf_types.DevDevice.default[1],
                ['DevFunction'] = pc_ie_device_intf_types.DevFunction.default[1],
                ['DiagnosticFault'] = pc_ie_device_intf_types.DiagnosticFault.default[1],
                ['PredictiveFault'] = pc_ie_device_intf_types.PredictiveFault.default[1],
                ['UCEByBIOS'] = pc_ie_device_intf_types.UCEByBIOS.default[1],
                ['BandwidthReduction'] = pc_ie_device_intf_types.BandwidthReduction.default[1],
                ['LinkSpeedReduced'] = pc_ie_device_intf_types.LinkSpeedReduced.default[1],
                ['FunctionClass'] = pc_ie_device_intf_types.FunctionClass.default[1],
                ['DeviceName'] = pc_ie_device_intf_types.DeviceName.default[1],
                ['Position'] = pc_ie_device_intf_types.Position.default[1],
                ['FaultByBios'] = pc_ie_device_intf_types.FaultByBios.default[1],
                ['SlotType'] = pc_ie_device_intf_types.SlotType.default[1],
                ['FunctionProtocol'] = pc_ie_device_intf_types.FunctionProtocol.default[1],
                ['FunctionType'] = pc_ie_device_intf_types.FunctionType.default[1],
                ['PCIeType'] = pc_ie_device_intf_types.PCIeType.default[1],
                ['PCIeDeviceType'] = pc_ie_device_intf_types.PCIeDeviceType.default[1],
                ['BaseClassCode'] = pc_ie_device_intf_types.BaseClassCode.default[1],
                ['SubClassCode'] = pc_ie_device_intf_types.SubClassCode.default[1],
                ['ProgrammingInterface'] = pc_ie_device_intf_types.ProgrammingInterface.default[1],
                ['MaxPCIeType'] = pc_ie_device_intf_types.MaxPCIeType.default[1],
                ['NegotiatedPCIeType'] = pc_ie_device_intf_types.NegotiatedPCIeType.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = pc_ie_device_intf_types
        },
        ['bmc.kepler.Systems.PCIeDevices.PCIeDevice.RAS'] = {
            ['property_defaults'] = {
                ['CorrectableError'] = ras_intf_types.CorrectableError.default[1],
                ['UncorrectableError'] = ras_intf_types.UncorrectableError.default[1],
                ['FatalError'] = ras_intf_types.FatalError.default[1],
                ['ParityError'] = ras_intf_types.ParityError.default[1],
                ['SystemError'] = ras_intf_types.SystemError.default[1],
                ['FatalErrorCount'] = ras_intf_types.FatalErrorCount.default[1],
                ['NonFatalErrorCount'] = ras_intf_types.NonFatalErrorCount.default[1],
                ['CorrectableErrorOverfrequencyCount'] = ras_intf_types.CorrectableErrorOverfrequencyCount.default[1],
                ['TimeoutError'] = ras_intf_types.TimeoutError.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ConfigureSelf,
                ['props'] = {
                    ['FatalErrorCount'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['NonFatalErrorCount'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting},
                    ['CorrectableErrorOverfrequencyCount'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.BasicSetting
                    },
                    ['TimeoutError'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}
                }
            },
            ['interface_types'] = ras_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PCIeCard = {
    ['prop_configs'] = {
        ['PcbID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = pc_ie_card_class_types.PcbID},
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = pc_ie_card_class_types.RefChip
        },
        ['Protocol'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = pc_ie_card_class_types.Protocol},
        ['MaxFrameLen'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['validator'] = pc_ie_card_class_types.MaxFrameLen
        },
        ['DevBus'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = pc_ie_card_class_types.DevBus},
        ['DevDevice'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = pc_ie_card_class_types.DevDevice},
        ['DevFunction'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = pc_ie_card_class_types.DevFunction}
    },
    ['default_props'] = {
        ['PcbID'] = pc_ie_card_class_types.PcbID.default[1],
        ['RefChip'] = pc_ie_card_class_types.RefChip.default[1],
        ['Protocol'] = pc_ie_card_class_types.Protocol.default[1],
        ['MaxFrameLen'] = pc_ie_card_class_types.MaxFrameLen.default[1],
        ['DevBus'] = pc_ie_card_class_types.DevBus.default[1],
        ['DevDevice'] = pc_ie_card_class_types.DevDevice.default[1],
        ['DevFunction'] = pc_ie_card_class_types.DevFunction.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Name
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Model
            },
            ['NodeID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.NodeID
            },
            ['SlotID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SlotID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceName
            },
            ['FunctionClass'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FunctionClass
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Description
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PcbVersion
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = pc_ie_card_intf_types.BoardID
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.BoardName
            },
            ['LinkWidthAbility'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = pc_ie_card_intf_types.LinkWidthAbility
            },
            ['LinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = pc_ie_card_intf_types.LinkWidth
            },
            ['LinkSpeedCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LinkSpeedCapability
            },
            ['LinkSpeed'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LinkSpeed
            },
            ['VendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceID
            },
            ['SubVendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubVendorID
            },
            ['SubDeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubDeviceID
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Position
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Manufacturer
            },
            ['LaneOwner'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LaneOwner
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FirmwareVersion
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PartNumber
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SerialNumber
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Health
            },
            ['CardModel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.CardModel
            },
            ['CardManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.CardManufacturer
            },
            ['CardForServers'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = pc_ie_card_intf_types.CardForServers
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.RefComponent
            },
            ['Presence'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = pc_ie_card_intf_types.Presence}
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['UID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = unit_intf_types.UID
            },
            ['Type'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = unit_intf_types.Type},
            ['HWSRVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.HWSRVersion
            },
            ['CurrentUpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = unit_intf_types.CurrentUpgradeStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/PCIeCards/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['property_defaults'] = {
                ['Name'] = pc_ie_card_intf_types.Name.default[1],
                ['Model'] = pc_ie_card_intf_types.Model.default[1],
                ['NodeID'] = pc_ie_card_intf_types.NodeID.default[1],
                ['SlotID'] = pc_ie_card_intf_types.SlotID.default[1],
                ['DeviceName'] = pc_ie_card_intf_types.DeviceName.default[1],
                ['FunctionClass'] = pc_ie_card_intf_types.FunctionClass.default[1],
                ['Description'] = pc_ie_card_intf_types.Description.default[1],
                ['PcbVersion'] = pc_ie_card_intf_types.PcbVersion.default[1],
                ['BoardID'] = 65535,
                ['BoardName'] = pc_ie_card_intf_types.BoardName.default[1],
                ['LinkWidthAbility'] = 'N/A',
                ['LinkWidth'] = 'N/A',
                ['LinkSpeedCapability'] = pc_ie_card_intf_types.LinkSpeedCapability.default[1],
                ['LinkSpeed'] = pc_ie_card_intf_types.LinkSpeed.default[1],
                ['VendorID'] = pc_ie_card_intf_types.VendorID.default[1],
                ['DeviceID'] = pc_ie_card_intf_types.DeviceID.default[1],
                ['SubVendorID'] = pc_ie_card_intf_types.SubVendorID.default[1],
                ['SubDeviceID'] = pc_ie_card_intf_types.SubDeviceID.default[1],
                ['Position'] = pc_ie_card_intf_types.Position.default[1],
                ['Manufacturer'] = pc_ie_card_intf_types.Manufacturer.default[1],
                ['LaneOwner'] = pc_ie_card_intf_types.LaneOwner.default[1],
                ['FirmwareVersion'] = pc_ie_card_intf_types.FirmwareVersion.default[1],
                ['PartNumber'] = pc_ie_card_intf_types.PartNumber.default[1],
                ['SerialNumber'] = pc_ie_card_intf_types.SerialNumber.default[1],
                ['Health'] = pc_ie_card_intf_types.Health.default[1],
                ['CardModel'] = pc_ie_card_intf_types.CardModel.default[1],
                ['CardManufacturer'] = pc_ie_card_intf_types.CardManufacturer.default[1],
                ['CardForServers'] = pc_ie_card_intf_types.CardForServers.default[1],
                ['RefComponent'] = pc_ie_card_intf_types.RefComponent.default[1],
                ['Presence'] = pc_ie_card_intf_types.Presence.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = pc_ie_card_intf_types
        },
        ['bmc.kepler.Systems.Board.Unit'] = {
            ['property_defaults'] = {
                ['UID'] = unit_intf_types.UID.default[1],
                ['Type'] = unit_intf_types.Type.default[1],
                ['HWSRVersion'] = unit_intf_types.HWSRVersion.default[1],
                ['CurrentUpgradeStatus'] = unit_intf_types.CurrentUpgradeStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = unit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local OCPCard = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Name
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Model
            },
            ['NodeID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.NodeID
            },
            ['SlotID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SlotID
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceName
            },
            ['FunctionClass'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FunctionClass
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Description
            },
            ['PcbVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PcbVersion
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = pc_ie_card_intf_types.BoardID
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.BoardName
            },
            ['LinkWidthAbility'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = pc_ie_card_intf_types.LinkWidthAbility
            },
            ['LinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = pc_ie_card_intf_types.LinkWidth
            },
            ['LinkSpeedCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LinkSpeedCapability
            },
            ['LinkSpeed'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LinkSpeed
            },
            ['VendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.DeviceID
            },
            ['SubVendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubVendorID
            },
            ['SubDeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SubDeviceID
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Position
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Manufacturer
            },
            ['LaneOwner'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.LaneOwner
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.FirmwareVersion
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.PartNumber
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.SerialNumber
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pc_ie_card_intf_types.Health
            },
            ['CardForServers'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = pc_ie_card_intf_types.CardForServers
            },
            ['RefComponent'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = pc_ie_card_intf_types.RefComponent
            },
            ['Presence'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = pc_ie_card_intf_types.Presence},
            ['CardModel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = pc_ie_card_intf_types.CardModel
            },
            ['CardManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = pc_ie_card_intf_types.CardManufacturer
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/OCPCards/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PCIeDevices.PCIeCard'] = {
            ['property_defaults'] = {
                ['Name'] = pc_ie_card_intf_types.Name.default[1],
                ['Model'] = pc_ie_card_intf_types.Model.default[1],
                ['NodeID'] = pc_ie_card_intf_types.NodeID.default[1],
                ['SlotID'] = pc_ie_card_intf_types.SlotID.default[1],
                ['DeviceName'] = pc_ie_card_intf_types.DeviceName.default[1],
                ['FunctionClass'] = pc_ie_card_intf_types.FunctionClass.default[1],
                ['Description'] = pc_ie_card_intf_types.Description.default[1],
                ['PcbVersion'] = pc_ie_card_intf_types.PcbVersion.default[1],
                ['BoardID'] = 65535,
                ['BoardName'] = pc_ie_card_intf_types.BoardName.default[1],
                ['LinkWidthAbility'] = 'N/A',
                ['LinkWidth'] = 'N/A',
                ['LinkSpeedCapability'] = pc_ie_card_intf_types.LinkSpeedCapability.default[1],
                ['LinkSpeed'] = pc_ie_card_intf_types.LinkSpeed.default[1],
                ['VendorID'] = pc_ie_card_intf_types.VendorID.default[1],
                ['DeviceID'] = pc_ie_card_intf_types.DeviceID.default[1],
                ['SubVendorID'] = pc_ie_card_intf_types.SubVendorID.default[1],
                ['SubDeviceID'] = pc_ie_card_intf_types.SubDeviceID.default[1],
                ['Position'] = pc_ie_card_intf_types.Position.default[1],
                ['Manufacturer'] = pc_ie_card_intf_types.Manufacturer.default[1],
                ['LaneOwner'] = pc_ie_card_intf_types.LaneOwner.default[1],
                ['FirmwareVersion'] = pc_ie_card_intf_types.FirmwareVersion.default[1],
                ['PartNumber'] = pc_ie_card_intf_types.PartNumber.default[1],
                ['SerialNumber'] = pc_ie_card_intf_types.SerialNumber.default[1],
                ['Health'] = pc_ie_card_intf_types.Health.default[1],
                ['CardForServers'] = pc_ie_card_intf_types.CardForServers.default[1],
                ['RefComponent'] = pc_ie_card_intf_types.RefComponent.default[1],
                ['Presence'] = pc_ie_card_intf_types.Presence.default[1],
                ['CardModel'] = pc_ie_card_intf_types.CardModel.default[1],
                ['CardManufacturer'] = pc_ie_card_intf_types.CardManufacturer.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = pc_ie_card_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PcieAddrInfo = {
    ['table_name'] = 't_pcie_addr_info',
    ['prop_configs'] = {
        ['ContainerUID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.ContainerUID
        },
        ['ContainerUnitType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.ContainerUnitType
        },
        ['Location'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.Location
        },
        ['ContainerSlot'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.ContainerSlot
        },
        ['DevBus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.DevBus
        },
        ['DevDevice'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = pcie_addr_info_class_types.DevFunction
        },
        ['GroupPosition'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = pcie_addr_info_class_types.GroupPosition
        },
        ['MultihostPresence'] = {['baseType'] = 'U32', ['validator'] = pcie_addr_info_class_types.MultihostPresence}
    },
    ['default_props'] = {
        ['ContainerUID'] = pcie_addr_info_class_types.ContainerUID.default[1],
        ['ContainerUnitType'] = pcie_addr_info_class_types.ContainerUnitType.default[1],
        ['Location'] = pcie_addr_info_class_types.Location.default[1],
        ['ContainerSlot'] = pcie_addr_info_class_types.ContainerSlot.default[1],
        ['DevBus'] = pcie_addr_info_class_types.DevBus.default[1],
        ['DevDevice'] = pcie_addr_info_class_types.DevDevice.default[1],
        ['DevFunction'] = pcie_addr_info_class_types.DevFunction.default[1],
        ['GroupPosition'] = pcie_addr_info_class_types.GroupPosition.default[1],
        ['MultihostPresence'] = pcie_addr_info_class_types.MultihostPresence.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PcieAddrInfo'] = {
            ['GroupID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.GroupID
            },
            ['SlotID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = pcie_addr_info_intf_types.SlotID
            },
            ['ComponentType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.ComponentType
            },
            ['ControllerIndex'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.ControllerIndex
            },
            ['ControllerType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.ControllerType
            },
            ['SocketID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = pcie_addr_info_intf_types.SocketID
            },
            ['Segment'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.Segment
            },
            ['Bus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pcie_addr_info_intf_types.Bus
            },
            ['Device'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pcie_addr_info_intf_types.Device
            },
            ['Function'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = pcie_addr_info_intf_types.Function
            },
            ['VendorID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.DeviceID
            },
            ['PortID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = pcie_addr_info_intf_types.PortID
            },
            ['Lanes'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.Lanes
            },
            ['PCIeType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Gen1', 'Gen2', 'Gen3', 'Gen4', 'Gen5', 'Gen6'},
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.PCIeType
            },
            ['SlotType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {
                    'FullLength', 'HalfLength', 'LowProfile', 'M2', 'Mini', 'OCP3Large', 'OCP3Small', 'OEM', 'U2'
                },
                ['usage'] = {'CSR'},
                ['validator'] = pcie_addr_info_intf_types.SlotType
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/PcieAddrInfo/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PcieAddrInfo'] = {
            ['property_defaults'] = {
                ['GroupID'] = pcie_addr_info_intf_types.GroupID.default[1],
                ['SlotID'] = pcie_addr_info_intf_types.SlotID.default[1],
                ['ComponentType'] = pcie_addr_info_intf_types.ComponentType.default[1],
                ['ControllerIndex'] = pcie_addr_info_intf_types.ControllerIndex.default[1],
                ['ControllerType'] = pcie_addr_info_intf_types.ControllerType.default[1],
                ['SocketID'] = pcie_addr_info_intf_types.SocketID.default[1],
                ['Segment'] = pcie_addr_info_intf_types.Segment.default[1],
                ['Bus'] = pcie_addr_info_intf_types.Bus.default[1],
                ['Device'] = pcie_addr_info_intf_types.Device.default[1],
                ['Function'] = pcie_addr_info_intf_types.Function.default[1],
                ['VendorID'] = pcie_addr_info_intf_types.VendorID.default[1],
                ['DeviceID'] = pcie_addr_info_intf_types.DeviceID.default[1],
                ['PortID'] = 255,
                ['Lanes'] = pcie_addr_info_intf_types.Lanes.default[1],
                ['PCIeType'] = pcie_addr_info_intf_types.PCIeType.default[1],
                ['SlotType'] = pcie_addr_info_intf_types.SlotType.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = pcie_addr_info_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BusinessConnector = {
    ['prop_configs'] = {
        ['Name'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = business_connector_class_types.Name},
        ['Direction'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.Direction
        },
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = business_connector_class_types.Slot},
        ['LinkWidth'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.LinkWidth
        },
        ['MaxLinkRate'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.MaxLinkRate
        },
        ['ConnectorType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.ConnectorType
        },
        ['SilkText'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.SilkText
        },
        ['UpstreamResources'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/Port'},
            ['validator'] = business_connector_class_types.UpstreamResources
        },
        ['ActualResourceOrder'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = business_connector_class_types.ActualResourceOrder
        },
        ['Ports'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/Port'},
            ['validator'] = business_connector_class_types.Ports
        },
        ['RefMgmtConnector'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['refInterface'] = 'bmc.kepler.Connector',
            ['validator'] = business_connector_class_types.RefMgmtConnector
        },
        ['RefMgmtConnectorTianChi'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['refInterface'] = 'bmc.kepler.Connector',
            ['validator'] = business_connector_class_types.RefMgmtConnectorTianChi
        },
        ['RefPCIeAddrInfo'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = business_connector_class_types.RefPCIeAddrInfo
        },
        ['BCUIndex'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = business_connector_class_types.BCUIndex
        }
    },
    ['default_props'] = {
        ['Name'] = business_connector_class_types.Name.default[1],
        ['Direction'] = business_connector_class_types.Direction.default[1],
        ['Slot'] = business_connector_class_types.Slot.default[1],
        ['LinkWidth'] = business_connector_class_types.LinkWidth.default[1],
        ['MaxLinkRate'] = business_connector_class_types.MaxLinkRate.default[1],
        ['ConnectorType'] = business_connector_class_types.ConnectorType.default[1],
        ['SilkText'] = business_connector_class_types.SilkText.default[1],
        ['UpstreamResources'] = business_connector_class_types.UpstreamResources.default[1],
        ['ActualResourceOrder'] = business_connector_class_types.ActualResourceOrder.default[1],
        ['Ports'] = business_connector_class_types.Ports.default[1],
        ['RefMgmtConnector'] = business_connector_class_types.RefMgmtConnector.default[1],
        ['RefMgmtConnectorTianChi'] = business_connector_class_types.RefMgmtConnectorTianChi.default[1],
        ['RefPCIeAddrInfo'] = business_connector_class_types.RefPCIeAddrInfo.default[1],
        ['BCUIndex'] = business_connector_class_types.BCUIndex.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.UnitConfigError'] = {
            ['Port1LinkInfo'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port1LinkInfo
            },
            ['Port1Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port1Status
            },
            ['Port2LinkInfo'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port2LinkInfo
            },
            ['Port2Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port2Status
            },
            ['AbsenceAllowed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['enum'] = {0, 1},
                ['validator'] = unit_config_error_intf_types.AbsenceAllowed
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/BusinessConnector/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.UnitConfigError'] = {
            ['property_defaults'] = {
                ['Port1LinkInfo'] = unit_config_error_intf_types.Port1LinkInfo.default[1],
                ['Port1Status'] = 255,
                ['Port2LinkInfo'] = unit_config_error_intf_types.Port2LinkInfo.default[1],
                ['Port2Status'] = 255,
                ['AbsenceAllowed'] = 0
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = unit_config_error_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SerDes = {
    ['prop_configs'] = {
        ['Name'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = ser_des_class_types.Name},
        ['ID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ser_des_class_types.ID},
        ['SocketID'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ser_des_class_types.SocketID},
        ['LinkWidth'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ser_des_class_types.LinkWidth},
        ['WorkMode'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ser_des_class_types.WorkMode},
        ['PCIePorts'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Struct',
            ['$ref'] = 'types.json#/defs/PortConfig',
            ['validator'] = ser_des_class_types.PCIePorts
        },
        ['SASPorts'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Struct',
            ['$ref'] = 'types.json#/defs/PortConfig',
            ['validator'] = ser_des_class_types.SASPorts
        },
        ['ModeConfigs'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/SerdesModeConfig'},
            ['validator'] = ser_des_class_types.ModeConfigs
        }
    },
    ['default_props'] = {
        ['Name'] = ser_des_class_types.Name.default[1],
        ['ID'] = ser_des_class_types.ID.default[1],
        ['SocketID'] = ser_des_class_types.SocketID.default[1],
        ['LinkWidth'] = ser_des_class_types.LinkWidth.default[1],
        ['WorkMode'] = ser_des_class_types.WorkMode.default[1],
        ['PCIePorts'] = ser_des_class_types.PCIePorts.default[1],
        ['SASPorts'] = ser_des_class_types.SASPorts.default[1],
        ['ModeConfigs'] = ser_des_class_types.ModeConfigs.default[1]
    }
}

local EthDevice = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PCIeDevices.EthDevice'] = {
            ['PortId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = eth_device_intf_types.PortId
            },
            ['LaneId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = eth_device_intf_types.LaneId
            },
            ['Segment'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = eth_device_intf_types.Segment
            },
            ['SocketID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = eth_device_intf_types.SocketID
            },
            ['ControllerIndex'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = eth_device_intf_types.ControllerIndex
            },
            ['Bus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = eth_device_intf_types.Bus
            },
            ['Device'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = eth_device_intf_types.Device
            },
            ['Function'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = eth_device_intf_types.Function
            },
            ['PortFunctionId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 255,
                ['validator'] = eth_device_intf_types.PortFunctionId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PCIeDevices/EthDevices/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PCIeDevices.EthDevice'] = {
            ['property_defaults'] = {
                ['PortId'] = eth_device_intf_types.PortId.default[1],
                ['LaneId'] = eth_device_intf_types.LaneId.default[1],
                ['Segment'] = eth_device_intf_types.Segment.default[1],
                ['SocketID'] = eth_device_intf_types.SocketID.default[1],
                ['ControllerIndex'] = eth_device_intf_types.ControllerIndex.default[1],
                ['Bus'] = 255,
                ['Device'] = 255,
                ['Function'] = 255,
                ['PortFunctionId'] = 255
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = eth_device_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local UnitConfiguration = {
    ['prop_configs'] = {
        ['SlotType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = unit_configuration_class_types.SlotType
        },
        ['SlotNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = unit_configuration_class_types.SlotNumber
        },
        ['SlotSilkText'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = unit_configuration_class_types.SlotSilkText
        },
        ['ContainerUID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = unit_configuration_class_types.ContainerUID
        },
        ['ContainerSlot'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = unit_configuration_class_types.ContainerSlot
        },
        ['Configurations'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/Configuration'},
            ['validator'] = unit_configuration_class_types.Configurations
        }
    },
    ['default_props'] = {
        ['SlotType'] = unit_configuration_class_types.SlotType.default[1],
        ['SlotNumber'] = unit_configuration_class_types.SlotNumber.default[1],
        ['SlotSilkText'] = unit_configuration_class_types.SlotSilkText.default[1],
        ['ContainerUID'] = unit_configuration_class_types.ContainerUID.default[1],
        ['ContainerSlot'] = unit_configuration_class_types.ContainerSlot.default[1],
        ['Configurations'] = unit_configuration_class_types.Configurations.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.UnitConfigError'] = {
            ['Port1LinkInfo'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port1LinkInfo
            },
            ['Port1Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port1Status
            },
            ['Port2LinkInfo'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port2LinkInfo
            },
            ['Port2Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = unit_config_error_intf_types.Port2Status
            },
            ['AbsenceAllowed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['enum'] = {0, 1},
                ['usage'] = {'CSR'},
                ['validator'] = unit_config_error_intf_types.AbsenceAllowed
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/UnitConfiguration/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.UnitConfigError'] = {
            ['property_defaults'] = {
                ['Port1LinkInfo'] = unit_config_error_intf_types.Port1LinkInfo.default[1],
                ['Port1Status'] = 255,
                ['Port2LinkInfo'] = unit_config_error_intf_types.Port2LinkInfo.default[1],
                ['Port2Status'] = 255,
                ['AbsenceAllowed'] = 0
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = unit_config_error_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ConfigureSelf},
            ['interface_types'] = properties_intf_types
        }
    })
}

local BusinessTopoNode = {
    ['prop_configs'] = {
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = business_topo_node_class_types.Slot},
        ['UID'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = business_topo_node_class_types.UID},
        ['Type'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = business_topo_node_class_types.Type},
        ['RefSmcChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = business_topo_node_class_types.RefSmcChip
        }
    },
    ['default_props'] = {
        ['Slot'] = business_topo_node_class_types.Slot.default[1],
        ['UID'] = business_topo_node_class_types.UID.default[1],
        ['Type'] = business_topo_node_class_types.Type.default[1],
        ['RefSmcChip'] = business_topo_node_class_types.RefSmcChip.default[1]
    }
}

local BDFConfig = {
    ['table_name'] = 't_bdf_config',
    ['prop_configs'] = {
        ['SocketId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['validator'] = bdf_config_class_types.SocketId
        },
        ['Type'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = bdf_config_class_types.Type},
        ['ConfigLength'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = bdf_config_class_types.ConfigLength
        },
        ['BDFConfigs'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/BDFConfiguration'},
            ['validator'] = bdf_config_class_types.BDFConfigs
        }
    },
    ['default_props'] = {
        ['SocketId'] = bdf_config_class_types.SocketId.default[1],
        ['Type'] = bdf_config_class_types.Type.default[1],
        ['ConfigLength'] = 255,
        ['BDFConfigs'] = bdf_config_class_types.BDFConfigs.default[1]
    }
}

local CpuBusInfo = {
    ['table_name'] = 't_cpu_bus_info',
    ['prop_configs'] = {
        ['SocketID'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['primaryKey'] = true,
            ['validator'] = cpu_bus_info_class_types.SocketID
        },
        ['SysId'] = {['baseType'] = 'U8', ['default'] = 1, ['validator'] = cpu_bus_info_class_types.SysId},
        ['BusBaseAddr'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = cpu_bus_info_class_types.BusBaseAddr},
        ['BusSize'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = cpu_bus_info_class_types.BusSize}
    },
    ['default_props'] = {['SocketID'] = 0, ['SysId'] = 1, ['BusBaseAddr'] = 0, ['BusSize'] = 0}
}

local PCIeVPDInfo = {
    ['table_name'] = 't_pcie_vpd_info',
    ['prop_configs'] = {
        ['DevBus'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = pc_ie_vpd_info_class_types.DevBus},
        ['DevDevice'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = pc_ie_vpd_info_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = pc_ie_vpd_info_class_types.DevFunction
        },
        ['SerialNumber'] = {['baseType'] = 'String', ['validator'] = pc_ie_vpd_info_class_types.SerialNumber},
        ['PartNumber'] = {['baseType'] = 'String', ['validator'] = pc_ie_vpd_info_class_types.PartNumber}
    },
    ['default_props'] = {
        ['DevBus'] = pc_ie_vpd_info_class_types.DevBus.default[1],
        ['DevDevice'] = pc_ie_vpd_info_class_types.DevDevice.default[1],
        ['DevFunction'] = pc_ie_vpd_info_class_types.DevFunction.default[1],
        ['SerialNumber'] = pc_ie_vpd_info_class_types.SerialNumber.default[1],
        ['PartNumber'] = pc_ie_vpd_info_class_types.PartNumber.default[1]
    }
}

local PCIeLoadInfo = {
    ['table_name'] = 't_pcie_load_info',
    ['prop_configs'] = {
        ['Type'] = {
            ['baseType'] = 'String',
            ['default'] = 'NA',
            ['primaryKey'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.Type
        },
        ['SlotID'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['primaryKey'] = true,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.SlotID
        },
        ['ID'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.ID
        },
        ['AuxID'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.AuxID
        },
        ['Segment'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.Segment
        },
        ['SocketID'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.SocketID
        },
        ['DevBus'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.DevBus
        },
        ['DevDevice'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.DevFunction
        },
        ['MultihostPresence'] = {
            ['baseType'] = 'U32',
            ['default'] = 1,
            ['usage'] = {'ResetPer'},
            ['validator'] = pc_ie_load_info_class_types.MultihostPresence
        }
    },
    ['default_props'] = {
        ['Type'] = 'NA',
        ['SlotID'] = 0,
        ['ID'] = 0,
        ['AuxID'] = 0,
        ['Segment'] = 0,
        ['SocketID'] = 0,
        ['DevBus'] = 0,
        ['DevDevice'] = 0,
        ['DevFunction'] = 0,
        ['MultihostPresence'] = 1
    }
}

local PCIeLoadInfoBackup = {
    ['table_name'] = 't_pcie_load_info_backup',
    ['prop_configs'] = {
        ['Type'] = {
            ['baseType'] = 'String',
            ['default'] = 'NA',
            ['primaryKey'] = true,
            ['validator'] = pc_ie_load_info_backup_class_types.Type
        },
        ['SlotID'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['primaryKey'] = true,
            ['validator'] = pc_ie_load_info_backup_class_types.SlotID
        },
        ['ID'] = {['baseType'] = 'U32', ['default'] = 0, ['validator'] = pc_ie_load_info_backup_class_types.ID},
        ['AuxID'] = {['baseType'] = 'U32', ['default'] = 0, ['validator'] = pc_ie_load_info_backup_class_types.AuxID},
        ['Segment'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pc_ie_load_info_backup_class_types.Segment
        },
        ['SocketID'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pc_ie_load_info_backup_class_types.SocketID
        },
        ['DevBus'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = pc_ie_load_info_backup_class_types.DevBus},
        ['DevDevice'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pc_ie_load_info_backup_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pc_ie_load_info_backup_class_types.DevFunction
        },
        ['MultihostPresence'] = {
            ['baseType'] = 'U32',
            ['default'] = 1,
            ['validator'] = pc_ie_load_info_backup_class_types.MultihostPresence
        },
        ['RecoverFlag'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = pc_ie_load_info_backup_class_types.RecoverFlag
        }
    },
    ['default_props'] = {
        ['Type'] = 'NA',
        ['SlotID'] = 0,
        ['ID'] = 0,
        ['AuxID'] = 0,
        ['Segment'] = 0,
        ['SocketID'] = 0,
        ['DevBus'] = 0,
        ['DevDevice'] = 0,
        ['DevFunction'] = 0,
        ['MultihostPresence'] = 1,
        ['RecoverFlag'] = 0
    }
}

local PCIeIPMIChannelConfig = {
    ['prop_configs'] = {
        ['Maps'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/IPMIChannelConfig'},
            ['validator'] = pc_ie_ipmi_channel_config_class_types.Maps
        }
    },
    ['default_props'] = {['Maps'] = pc_ie_ipmi_channel_config_class_types.Maps.default[1]}
}

local PCIeCardFlashChecker = {
    ['table_name'] = 't_pcie_card_flash_checker',
    ['prop_configs'] = {
        ['GroupPosition'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = pc_ie_card_flash_checker_class_types.GroupPosition
        },
        ['FaultStatus'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR', 'ResetPer', 'SHM'},
            ['validator'] = pc_ie_card_flash_checker_class_types.FaultStatus
        },
        ['PCIeQuadrupleList'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Array',
            ['items'] = {['baseType'] = 'Struct', ['$ref'] = 'types.json#/defs/IdAndDescription'},
            ['validator'] = pc_ie_card_flash_checker_class_types.PCIeQuadrupleList
        }
    },
    ['default_props'] = {
        ['GroupPosition'] = pc_ie_card_flash_checker_class_types.GroupPosition.default[1],
        ['FaultStatus'] = pc_ie_card_flash_checker_class_types.FaultStatus.default[1],
        ['PCIeQuadrupleList'] = pc_ie_card_flash_checker_class_types.PCIeQuadrupleList.default[1]
    }
}

local M = {}

function M.init(bus)
    class('PCIeDevices', PCIeDevices):set_bus(bus)
    class('PCIeDevice', PCIeDevice):set_bus(bus)
    class('PCIeCard', PCIeCard):set_bus(bus)
    class('OCPCard', OCPCard):set_bus(bus)
    class('PcieAddrInfo', PcieAddrInfo):set_bus(bus)
    class('BusinessConnector', BusinessConnector):set_bus(bus)
    class('SerDes', SerDes):set_bus(bus)
    class('EthDevice', EthDevice):set_bus(bus)
    class('UnitConfiguration', UnitConfiguration):set_bus(bus)
    class('BusinessTopoNode', BusinessTopoNode):set_bus(bus)
    class('BDFConfig', BDFConfig):set_bus(bus)
    class('CpuBusInfo', CpuBusInfo):set_bus(bus)
    class('PCIeVPDInfo', PCIeVPDInfo):set_bus(bus)
    class('PCIeLoadInfo', PCIeLoadInfo):set_bus(bus)
    class('PCIeLoadInfoBackup', PCIeLoadInfoBackup):set_bus(bus)
    class('PCIeIPMIChannelConfig', PCIeIPMIChannelConfig):set_bus(bus)
    class('PCIeCardFlashChecker', PCIeCardFlashChecker):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetPcieErrorStatus(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetPcieErrorStatus = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetPcieErrorStatusReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetPcieErrorStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetBandwidthReduction(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetBandwidthReduction = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetBandwidthReductionReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetBandwidthReductionRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetUCEByBIOS(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetUCEByBIOS = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetUCEByBIOSReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetUCEByBIOSRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetDiagnosticFault(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetDiagnosticFault = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetDiagnosticFaultReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetDiagnosticFaultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetPredictiveFault(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetPredictiveFault = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetPredictiveFaultReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetPredictiveFaultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesGetDeviceName(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].GetDeviceName = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.GetDeviceNameReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.GetDeviceNameRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesGetPCIeCardNum(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].GetPCIeCardNum = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.GetPCIeCardNumReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.GetPCIeCardNumRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetFaultByBios(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetFaultByBios = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetFaultByBiosReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetFaultByBiosRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPCIeDevicesPCIeDevicesSetLinkSpeedReduced(cb)
    class('PCIeDevices')['bmc.kepler.Systems.PCIeDevices'].SetLinkSpeedReduced = function(obj, ctx, ...)
        local req = pc_ie_devices_intf_types.SetLinkSpeedReducedReq.new(...):validate(nil, nil, true)
        local rsp = pc_ie_devices_intf_types.SetLinkSpeedReducedRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
