#!/usr/bin/env python
# coding: utf-8
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

import glob
import json
import os
import stat
import subprocess


# 定制化脚本，由manifest构建时调用
class Customization():
    def __init__(self, board_name, rootfs_path):
        self.board_name = board_name
        self.rootfs_path = rootfs_path

    def post_image(self):
        # 增加文件的权限
        subprocess.run(['/usr/bin/sudo', '/usr/bin/chown', '0:103', f'{self.rootfs_path}/opt/bmc/sr'], check=True)
        subprocess.run(['/usr/bin/sudo', '/usr/bin/chown', '-R', '0:103', f'{self.rootfs_path}/opt/bmc/sr'], check=True)
        subprocess.run(['/usr/bin/sudo', '/usr/bin/chmod', '-R', '440', f'{self.rootfs_path}/opt/bmc/sr'], check=True)
        subprocess.run(['/usr/bin/sudo', '/usr/bin/chmod', '550', f'{self.rootfs_path}/opt/bmc/sr'], check=True)
