local class = require 'mc.class'
local app_base = require 'mc.client_app_base'
local observability_client = class(app_base.Client)
local mc_utils = require 'mc.utils'
local unit_data_dir = mc_utils.realpath('.')
local cert_dir = unit_data_dir .. '/cert_key'

function observability_client:GetCertificateObjects()
    return {}
end

function observability_client:CertificateServiceCertificateServiceExportCertKeyByFIFO(ctx, CertificateUsageType)
    return {FilePath = cert_dir .. '/SSL.key'}
end

function observability_client:GetDashboardObservabilityObject()
    return {Enabled = true}
end

function observability_client:GetProductObjects()
    return {test = {AssetTag = 1}}
end

function observability_client:GetOverviewObjects()
    return {test = {FruId = 0}}
end

function observability_client:GetBoardObjects()
    return {test = {BoardSerialNumber = 1}}
end

function observability_client:GetDashboardObservabilityLogsObject()
    return {
        Enabled = false,
        ExportIntervalSeconds = 5,
        set_property = function(prop_name, prop_value)
            return -1
        end
    }
end

function observability_client:GetAssemblyObjects()
    return {['/bmc/kepler/Managers/1/Assembly'] = {HostName = ""}}
end

function observability_client:set_error(val)
    self.err = val
end

function observability_client:ctor()
    self.signal_slots = {}
end

return observability_client.new('observability')