-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-27
-- Description: DO NOT EDIT; Code generated by "test_${project_name}.lua.mako"
local skynet = require 'skynet'
require 'skynet.manager'
require 'observability.json_types.Receiver'
local log = require 'mc.logging'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local dbus = require 'sd_bus'
local lu = require 'luaunit'
local gvariant = require 'mc.gvariant'
local test_common = require 'test_common.utils'
local vos = require 'utils.vos'
local defs = require 'public.defs'

local ctx = {
    Interface = 'observability',
    ClientAddr = '127.0.0.1',
    UserName = 'Administrator'
}

local function prepare_test_data()
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    os.execute('mkdir -p ' .. test_data_dir)
    os.execute('mkdir -p ' .. '/tmp/test_dump')
    if vos.get_file_accessible(defs.SSL_KEY_PATH) then
        os.execute('rm -rf ' .. defs.SSL_KEY_PATH)
    end
end

local function clear_test_data(exit_test)
    log:info('clear test data')
    local test_data_dir = skynet.getenv('TEST_DATA_DIR')
    if not exit_test then return utils.remove_file(test_data_dir) end

    skynet.timeout(0, function()
        skynet.sleep(20)
        skynet.abort()
        utils.remove_file(test_data_dir)
        utils.remove_file('/tmp/test_dump')
    end)
end

local function test_observability_mdb(bus)
    log:info('================ test_observability_mdb ================')
    local ret, obj = pcall(mdb.get_object, bus, '/bmc/kepler/ObservabilityService/Receivers/0',
                           'bmc.kepler.ObservabilityService.Receiver')
    lu.assertEquals(ret, true)
    lu.assertEquals(obj.Address, '')
    lu.assertEquals(obj.Port, 0)
    lu.assertEquals(obj.Protocol, 'OtlpHttp')
    lu.assertEquals(obj.Enabled, false)
    lu.assertEquals(obj.ReceiverId, 0)
end

local function test_attribute_set(bus)
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Receivers/0',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService.Receiver',
            'Enabled', gvariant.new_bool(true))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'Enabled', gvariant.new_bool(true))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'ServerIdentity', gvariant.new_string('HostName'))
    end)
    assert(ok)
end

local function test_method(bus)
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Receivers/0',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService.Receiver',
            'Address', gvariant.new_string('1.1.1.1'))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Receivers/0',
            'bmc.kepler.ObservabilityService.Receiver', 'SubmitTestTelemetryData',
            'a{ss}', require 'mc.context'.new())
    end)
    assert(ok)
end

local function test_identity_prop_change(bus)
    -- 修改主机标识为SN
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'ServerIdentity', gvariant.new_string('BoardSN'))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.frudata', '/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.Systems.FruData.Board',
            'BoardSerialNumber', gvariant.new_string('1234'))
    end)
    assert(ok)

    -- 修改主机标识为资产标签
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'ServerIdentity', gvariant.new_string('ProductAssetTag'))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.frudata', '/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.Systems.FruData.Product',
            'AssetTag', gvariant.new_string('1234'))
    end)
    assert(ok)

    -- 修改主机标识为主机名
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.ObservabilityService',
            'ServerIdentity', gvariant.new_string('HostName'))
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.bmc_network', '/bmc/kepler/Managers/1/Assembly',
            'org.freedesktop.DBus.Properties', 'Set', 'ssv', 'bmc.kepler.Assembly',
            'HostName', gvariant.new_string('1234'))
    end)
    assert(ok)
end

local function test_get_config(bus)
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'GetConfigurations', 'a{ss}', ctx, 0)
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Metrics',
            'bmc.kepler.ObservabilityService.Metrics', 'GetConfigurations', 'a{ss}', ctx, 0)
    end)
    assert(ok)

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Logs',
            'bmc.kepler.ObservabilityService.Logs', 'GetConfigurations', 'a{ss}', ctx, 0)
    end)
    assert(ok)
end

local function test_set_traces_config(bus)
    -- 设置正常参数
    local traces_config = {
        SamplingRate = "0.1",
        SamplingPolicy = "Fixed",
        SamplingLevel = "Component",
        ExportIntervalSeconds = "30"
    }
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(ok)

    traces_config.SamplingPolicy = "Adaptive"
    traces_config.SamplingLevel = "Function"
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(ok)

    -- 设置异常参数
    traces_config = {
        SamplingRate = "1.5",
        SamplingPolicy = "TestProbability",
        SamplingLevel = "TestLevel",
        ExportIntervalSeconds = "100"
    }
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(not ok)
    traces_config.SamplingRate = "0.1111111"

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(not ok)
    traces_config.SamplingRate = "0.1"

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(not ok)
    traces_config.SamplingPolicy = "Fixed"

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(not ok)
    traces_config.SamplingLevel = "Component"

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Traces',
            'bmc.kepler.ObservabilityService.Traces', 'SetConfigurations', 'a{ss}a{ss}', ctx, traces_config)
    end)
    assert(not ok)
    traces_config.ExportIntervalSeconds = "10"
end

local function test_set_metrics_config(bus)
    -- 设置正常参数
    local metrics_config = {
        ExportIntervalSeconds = "500",
        ActivatedMetrics = "bmc.hw.chip.accessor"
    }
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Metrics',
            'bmc.kepler.ObservabilityService.Metrics', 'SetConfigurations', 'a{ss}a{ss}', ctx, metrics_config)
    end)
    assert(ok)

    -- 设置异常参数
    metrics_config = {
        ExportIntervalSeconds = "3601",
        ActivatedMetrics = "bmc.hw.test.accessor"
    }
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Metrics',
            'bmc.kepler.ObservabilityService.Metrics', 'SetConfigurations', 'a{ss}a{ss}', ctx, metrics_config)
    end)
    assert(not ok)
    metrics_config.ExportIntervalSeconds = "60"

    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Metrics',
            'bmc.kepler.ObservabilityService.Metrics', 'SetConfigurations', 'a{ss}a{ss}', ctx, metrics_config)
    end)
    assert(not ok)
end

local function test_set_logs_config(bus)
    -- 设置正常参数
    local logs_config = {
        Enabled = "true",
        ExportIntervalSeconds = "30"
    }
    local ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Logs',
            'bmc.kepler.ObservabilityService.Logs', 'SetConfigurations', 'a{ss}a{ss}', ctx, logs_config)
    end)
    assert(ok)

    -- 设置异常参数
    logs_config = {
        Enabled = "false",
        ExportIntervalSeconds = "100"
    }
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Logs',
            'bmc.kepler.ObservabilityService.Logs', 'SetConfigurations', 'a{ss}a{ss}', ctx, logs_config)
    end)
    assert(not ok)
    logs_config.ExportIntervalSeconds = "60"

    logs_config.Enabled = "aaa"
    ok = pcall(function()
        bus:call('bmc.kepler.observability', '/bmc/kepler/ObservabilityService/Logs',
            'bmc.kepler.ObservabilityService.Logs', 'SetConfigurations', 'a{ss}a{ss}', ctx, logs_config)
    end)
    assert(not ok)
end

local function test_export_policy_config(bus)
    test_get_config(bus)
    test_set_traces_config(bus)
    test_set_metrics_config(bus)
    test_set_logs_config(bus)
end

local function test_observability()
    skynet.sleep(20)
    log:info('================ test start ================')
    local bus = dbus.open_user(true)
    test_observability_mdb(bus)
    test_attribute_set(bus)
    test_method(bus)
    test_identity_prop_change(bus)
    test_export_policy_config(bus)
    log:info('================ test complete ================')
end

skynet.start(function()
    clear_test_data(false)
    prepare_test_data()
    test_common.dbus_launch()
    skynet.uniqueservice('persistence/service/main')
    skynet.uniqueservice('mock_service/mock_frudata')
    skynet.uniqueservice('mock_service/mock_bmc_network')
    skynet.uniqueservice('main')
    skynet.fork(function()
        local ok, err = pcall(test_observability)
        clear_test_data(true)
        if not ok then
            error(err)
        end
    end)
end)
