local class = require 'mc.class'
local app_base = require 'mc.client_app_base'
local subscribe_signal = require 'mc.mdb.subscribe_signal'
local observability_client = class(app_base.Client)

function observability_client:GetDashboardObservabilityObject()
    return {Enabled = true}
end

function observability_client:GetProductObjects()
    return {['/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104'] = {AssetTag = 1}}
end

function observability_client:GetOverviewObjects()
    return {['/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104'] = {FruId = 0}}
end

function observability_client:GetBoardObjects()
    return {['/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104'] = {BoardSerialNumber = 1}}
end

function observability_client:GetAssemblyObjects()
    return {['/bmc/kepler/Managers/1/Assembly'] = {HostName = ""}}
end

function observability_client:OnBoardPropertiesChanged(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_properties_changed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Systems.FruData.Board', {'BoardSerialNumber'})
end

function observability_client:OnProductPropertiesChanged(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_properties_changed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Systems.FruData.Product', {'AssetTag'})
end

function observability_client:OnAssemblyPropertiesChanged(cb)
    self.signal_slots[#self.signal_slots + 1] = subscribe_signal.on_properties_changed(self:get_bus(), '/bmc', cb,
        'bmc.kepler.Assembly', {'HostName'})
end

function observability_client:GetDashboardObservabilityTracesObject()
    return {
        SamplingRate = 0.5,
        SamplingPolicy = 2,
        SamplingLevel = 3,
        ExportIntervalSeconds = 5,
        set_property = function(prop_name, prop_value)
            return 0
        end
    }
end

function observability_client:GetDashboardObservabilityMetricsObject()
    return {
        ExportIntervalSeconds = 5,
        ActivatedMetrics = {"bmc.hw.chip.io"},
        set_property = function(prop_name, prop_value)
            return 0
        end
    }
end

function observability_client:GetDashboardObservabilityLogsObject()
    return {
        Enabled = false,
        ExportIntervalSeconds = 5,
        set_property = function(prop_name, prop_value)
            return 0
        end
    }
end

function observability_client:set_error(val)
    self.err = val
end

function observability_client:ctor()
    self.signal_slots = {}
end

return observability_client.new('observability')