
local skynet = require 'skynet'
local sd_bus = require 'sd_bus'
local mdb = require 'mc.mdb'

local FRUDATA_PATH = '/bmc/kepler/Systems/1/FruDatas/FruData_Fru0_010104'
local BOADRD_INTF = 'bmc.kepler.Systems.FruData.Board'
local PRODUCT_INTF = 'bmc.kepler.Systems.FruData.Product'
local OVERVIEW_INTF = 'bmc.kepler.Systems.FruData.Overview'

local prop_intf = mdb.register_interface('bmc.kepler.Object.Properties', {
    ClassName = {'s', nil, true, nil, false},
    ObjectName = {'s', nil, true, nil, false},
    ObjectIdentifier = {'(ysss)', nil, true, nil, false}
}, {}, {})

local frudata_board_intf = mdb.register_interface(BOADRD_INTF,
    {
        BoardSerialNumber = {'s', nil, false, '', false}
    }, {}, {}
)

local frudata_product_intf = mdb.register_interface(PRODUCT_INTF,
    {
        AssetTag = {'s', nil, false, '', false}
    }, {}, {}
)

local frudata_overview_intf = mdb.register_interface(OVERVIEW_INTF,
    {
        FruId = {'y', nil, false, 0, false}
    }, {}, {}
)

local frudata = mdb.register_object(FRUDATA_PATH,
    {
        {
            name = 'board',
            interface = frudata_board_intf
        },
        {
            name = 'product',
            interface = frudata_product_intf
        },
        {
            name = 'overview',
            interface = frudata_overview_intf
        },
        {
            name = 'ObjectProperties',
            interface = prop_intf
        }
    }
)

function frudata:ctor()
    self.path = FRUDATA_PATH
end

local bus
local stub = {}
local M = {}
local PNAME_TEST = "test_frudata_msg"
local PTYPE_TEST = 102
local board_obj
local product_obj
local prop_obj

function M.run()
    skynet.register_protocol({
        name = PNAME_TEST,
        id = PTYPE_TEST,
        pack = skynet.pack,
        unpack = skynet.unpack
    })
end

function stub:register_frudata()
    bus = sd_bus.open_user(true)
    bus:request_name('bmc.kepler.frudata')

    board_obj = frudata.board.new()
    board_obj:register(bus)

    product_obj = frudata.product.new()
    product_obj:register(bus)

    prop_obj = frudata.ObjectProperties.new('1')
    prop_obj.ObjectIdentifier = {0, '', '', ''}
    prop_obj:register(bus)
end

skynet.start(function()
    skynet.register(".frudata")
    stub:register_frudata()
    M.run()
end)