
local skynet = require 'skynet'
local sd_bus = require 'sd_bus'
local mdb = require 'mc.mdb'

local ASSEMBLY_PATH = '/bmc/kepler/Managers/1/Assembly'
local ASSEMBLY_INTF = 'bmc.kepler.Assembly'

local prop_intf = mdb.register_interface('bmc.kepler.Object.Properties', {
    ClassName = {'s', nil, true, nil, false},
    ObjectName = {'s', nil, true, nil, false},
    ObjectIdentifier = {'(ysss)', nil, true, nil, false}
}, {}, {})

local assembly_intf = mdb.register_interface(ASSEMBLY_INTF,
    {
        HostName = {'s', nil, false, '', false}
    }, {}, {}
)

local network = mdb.register_object(ASSEMBLY_PATH,
    {
        {
            name = 'assembly',
            interface = assembly_intf
        },
        {
            name = 'ObjectProperties',
            interface = prop_intf
        }
    }
)

function network:ctor()
    self.path = ASSEMBLY_PATH
end

local bus
local stub = {}
local M = {}
local PNAME_TEST = "test_network_msg"
local PTYPE_TEST = 102
local assembly_obj
local prop_obj

function M.run()
    skynet.register_protocol({
        name = PNAME_TEST,
        id = PTYPE_TEST,
        pack = skynet.pack,
        unpack = skynet.unpack
    })
end

function stub:register_network()
    bus = sd_bus.open_user(true)
    bus:request_name('bmc.kepler.bmc_network')

    assembly_obj = network.assembly.new()
    assembly_obj:register(bus)

    prop_obj = network.ObjectProperties.new('1')
    prop_obj.ObjectIdentifier = {0, '', '', ''}
    prop_obj:register(bus)
end

skynet.start(function()
    skynet.register(".bmc_network")
    stub:register_network()
    M.run()
end)