-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-25
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ObservabilityTraces = {}

---@class ObservabilityTraces.ExportIntervalSeconds
---@field ExportIntervalSeconds integer
local TExportIntervalSeconds = {}
TExportIntervalSeconds.__index = TExportIntervalSeconds
TExportIntervalSeconds.group = {}

local function TExportIntervalSeconds_from_obj(obj)
    return setmetatable(obj, TExportIntervalSeconds)
end

function TExportIntervalSeconds.new(ExportIntervalSeconds)
    return TExportIntervalSeconds_from_obj({ExportIntervalSeconds = ExportIntervalSeconds})
end
---@param obj ObservabilityTraces.ExportIntervalSeconds
function TExportIntervalSeconds:init_from_obj(obj)
    self.ExportIntervalSeconds = obj.ExportIntervalSeconds
end

function TExportIntervalSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportIntervalSeconds.group)
end

TExportIntervalSeconds.from_obj = TExportIntervalSeconds_from_obj

TExportIntervalSeconds.proto_property = {'ExportIntervalSeconds'}

TExportIntervalSeconds.default = {0}

TExportIntervalSeconds.struct = {{name = 'ExportIntervalSeconds', is_array = false, struct = nil}}

function TExportIntervalSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExportIntervalSeconds', self.ExportIntervalSeconds, 'uint32', false, errs, need_convert)

    TExportIntervalSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportIntervalSeconds.proto_property, errs, need_convert)
    return self
end

function TExportIntervalSeconds:unpack(_)
    return self.ExportIntervalSeconds
end

ObservabilityTraces.ExportIntervalSeconds = TExportIntervalSeconds

---@class ObservabilityTraces.SamplingLevel
---@field SamplingLevel integer
local TSamplingLevel = {}
TSamplingLevel.__index = TSamplingLevel
TSamplingLevel.group = {}

local function TSamplingLevel_from_obj(obj)
    return setmetatable(obj, TSamplingLevel)
end

function TSamplingLevel.new(SamplingLevel)
    return TSamplingLevel_from_obj({SamplingLevel = SamplingLevel})
end
---@param obj ObservabilityTraces.SamplingLevel
function TSamplingLevel:init_from_obj(obj)
    self.SamplingLevel = obj.SamplingLevel
end

function TSamplingLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSamplingLevel.group)
end

TSamplingLevel.from_obj = TSamplingLevel_from_obj

TSamplingLevel.proto_property = {'SamplingLevel'}

TSamplingLevel.default = {0}

TSamplingLevel.struct = {{name = 'SamplingLevel', is_array = false, struct = nil}}

function TSamplingLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SamplingLevel', self.SamplingLevel, 'uint8', false, errs, need_convert)

    TSamplingLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSamplingLevel.proto_property, errs, need_convert)
    return self
end

function TSamplingLevel:unpack(_)
    return self.SamplingLevel
end

ObservabilityTraces.SamplingLevel = TSamplingLevel

---@class ObservabilityTraces.SamplingPolicy
---@field SamplingPolicy integer
local TSamplingPolicy = {}
TSamplingPolicy.__index = TSamplingPolicy
TSamplingPolicy.group = {}

local function TSamplingPolicy_from_obj(obj)
    return setmetatable(obj, TSamplingPolicy)
end

function TSamplingPolicy.new(SamplingPolicy)
    return TSamplingPolicy_from_obj({SamplingPolicy = SamplingPolicy})
end
---@param obj ObservabilityTraces.SamplingPolicy
function TSamplingPolicy:init_from_obj(obj)
    self.SamplingPolicy = obj.SamplingPolicy
end

function TSamplingPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSamplingPolicy.group)
end

TSamplingPolicy.from_obj = TSamplingPolicy_from_obj

TSamplingPolicy.proto_property = {'SamplingPolicy'}

TSamplingPolicy.default = {0}

TSamplingPolicy.struct = {{name = 'SamplingPolicy', is_array = false, struct = nil}}

function TSamplingPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SamplingPolicy', self.SamplingPolicy, 'uint8', false, errs, need_convert)

    TSamplingPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSamplingPolicy.proto_property, errs, need_convert)
    return self
end

function TSamplingPolicy:unpack(_)
    return self.SamplingPolicy
end

ObservabilityTraces.SamplingPolicy = TSamplingPolicy

---@class ObservabilityTraces.SamplingRate
---@field SamplingRate number
local TSamplingRate = {}
TSamplingRate.__index = TSamplingRate
TSamplingRate.group = {}

local function TSamplingRate_from_obj(obj)
    return setmetatable(obj, TSamplingRate)
end

function TSamplingRate.new(SamplingRate)
    return TSamplingRate_from_obj({SamplingRate = SamplingRate})
end
---@param obj ObservabilityTraces.SamplingRate
function TSamplingRate:init_from_obj(obj)
    self.SamplingRate = obj.SamplingRate
end

function TSamplingRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSamplingRate.group)
end

TSamplingRate.from_obj = TSamplingRate_from_obj

TSamplingRate.proto_property = {'SamplingRate'}

TSamplingRate.default = {0}

TSamplingRate.struct = {{name = 'SamplingRate', is_array = false, struct = nil}}

function TSamplingRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SamplingRate', self.SamplingRate, 'double', false, errs, need_convert)

    TSamplingRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSamplingRate.proto_property, errs, need_convert)
    return self
end

function TSamplingRate:unpack(_)
    return self.SamplingRate
end

ObservabilityTraces.SamplingRate = TSamplingRate

ObservabilityTraces.interface = mdb.register_interface('bmc.kepler.Dashboard.Observability.Traces', {
    SamplingRate = {'d', nil, false, nil, false},
    SamplingPolicy = {'y', nil, false, nil, false},
    SamplingLevel = {'y', nil, false, nil, false},
    ExportIntervalSeconds = {'u', nil, false, nil, false}
}, {}, {})

return ObservabilityTraces
