-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-25
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ObservabilityServiceMetrics = {}

---@class ObservabilityServiceMetrics.SupportedMetrics
---@field SupportedMetrics string[]
local TSupportedMetrics = {}
TSupportedMetrics.__index = TSupportedMetrics
TSupportedMetrics.group = {}

local function TSupportedMetrics_from_obj(obj)
    return setmetatable(obj, TSupportedMetrics)
end

function TSupportedMetrics.new(SupportedMetrics)
    return TSupportedMetrics_from_obj({SupportedMetrics = SupportedMetrics})
end
---@param obj ObservabilityServiceMetrics.SupportedMetrics
function TSupportedMetrics:init_from_obj(obj)
    self.SupportedMetrics = obj.SupportedMetrics
end

function TSupportedMetrics:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedMetrics.group)
end

TSupportedMetrics.from_obj = TSupportedMetrics_from_obj

TSupportedMetrics.proto_property = {'SupportedMetrics'}

TSupportedMetrics.default = {{}}

TSupportedMetrics.struct = {{name = 'SupportedMetrics', is_array = true, struct = nil}}

function TSupportedMetrics:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedMetrics', self.SupportedMetrics, 'string', true, errs, need_convert)

    TSupportedMetrics:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedMetrics.proto_property, errs, need_convert)
    return self
end

function TSupportedMetrics:unpack(_)
    return self.SupportedMetrics
end

ObservabilityServiceMetrics.SupportedMetrics = TSupportedMetrics

---@class ObservabilityServiceMetrics.SetConfigurationsRsp
local TSetConfigurationsRsp = {}
TSetConfigurationsRsp.__index = TSetConfigurationsRsp
TSetConfigurationsRsp.group = {}

local function TSetConfigurationsRsp_from_obj(obj)
    return setmetatable(obj, TSetConfigurationsRsp)
end

function TSetConfigurationsRsp.new()
    return TSetConfigurationsRsp_from_obj({})
end
---@param obj ObservabilityServiceMetrics.SetConfigurationsRsp
function TSetConfigurationsRsp:init_from_obj(obj)

end

function TSetConfigurationsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConfigurationsRsp.group)
end

TSetConfigurationsRsp.from_obj = TSetConfigurationsRsp_from_obj

TSetConfigurationsRsp.proto_property = {}

TSetConfigurationsRsp.default = {}

TSetConfigurationsRsp.struct = {}

function TSetConfigurationsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetConfigurationsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConfigurationsRsp.proto_property, errs, need_convert)
    return self
end

function TSetConfigurationsRsp:unpack(_)
end

ObservabilityServiceMetrics.SetConfigurationsRsp = TSetConfigurationsRsp

---@class ObservabilityServiceMetrics.GetConfigurationsReq
local TGetConfigurationsReq = {}
TGetConfigurationsReq.__index = TGetConfigurationsReq
TGetConfigurationsReq.group = {}

local function TGetConfigurationsReq_from_obj(obj)
    return setmetatable(obj, TGetConfigurationsReq)
end

function TGetConfigurationsReq.new()
    return TGetConfigurationsReq_from_obj({})
end
---@param obj ObservabilityServiceMetrics.GetConfigurationsReq
function TGetConfigurationsReq:init_from_obj(obj)

end

function TGetConfigurationsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigurationsReq.group)
end

TGetConfigurationsReq.from_obj = TGetConfigurationsReq_from_obj

TGetConfigurationsReq.proto_property = {}

TGetConfigurationsReq.default = {}

TGetConfigurationsReq.struct = {}

function TGetConfigurationsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetConfigurationsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigurationsReq.proto_property, errs, need_convert)
    return self
end

function TGetConfigurationsReq:unpack(_)
end

ObservabilityServiceMetrics.GetConfigurationsReq = TGetConfigurationsReq

---@class ObservabilityServiceMetrics.ConfigData
---@field key string
---@field value string
local TConfigData = {}
TConfigData.__index = TConfigData
TConfigData.group = {}

local function TConfigData_from_obj(obj)
    return setmetatable(obj, TConfigData)
end

function TConfigData.new(dict)
    return TConfigData_from_obj(dict)
end

---@param obj ObservabilityServiceMetrics.ConfigData
function TConfigData:init_from_obj(obj)
    self = obj
end

function TConfigData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigData.group)
end

TConfigData.from_obj = TConfigData_from_obj

TConfigData.proto_property = {}

TConfigData.default = {}

TConfigData.struct = {}

function TConfigData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TConfigData:remove_error_props(errs, self)
    return self
end

function TConfigData:unpack(_)
    return self
end

ObservabilityServiceMetrics.ConfigData = TConfigData

---@class ObservabilityServiceMetrics.SetConfigurationsReq
---@field Configurations ObservabilityServiceMetrics.ConfigData
local TSetConfigurationsReq = {}
TSetConfigurationsReq.__index = TSetConfigurationsReq
TSetConfigurationsReq.group = {}

local function TSetConfigurationsReq_from_obj(obj)
    return setmetatable(obj, TSetConfigurationsReq)
end

function TSetConfigurationsReq.new(Configurations)
    return TSetConfigurationsReq_from_obj({Configurations = Configurations})
end
---@param obj ObservabilityServiceMetrics.SetConfigurationsReq
function TSetConfigurationsReq:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TSetConfigurationsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConfigurationsReq.group)
end

TSetConfigurationsReq.from_obj = TSetConfigurationsReq_from_obj

TSetConfigurationsReq.proto_property = {'Configurations'}

TSetConfigurationsReq.default = {ObservabilityServiceMetrics.ConfigData.default}

TSetConfigurationsReq.struct = {
    {name = 'Configurations', is_array = false, struct = ObservabilityServiceMetrics.ConfigData.struct}
}

function TSetConfigurationsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ObservabilityServiceMetrics.ConfigData.new(self.Configurations):validate(prefix, errs, need_convert)

    TSetConfigurationsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConfigurationsReq.proto_property, errs, need_convert)
    return self
end

function TSetConfigurationsReq:unpack(_)
    return self.Configurations
end

ObservabilityServiceMetrics.SetConfigurationsReq = TSetConfigurationsReq

---@class ObservabilityServiceMetrics.GetConfigurationsRsp
---@field Configurations ObservabilityServiceMetrics.ConfigData
local TGetConfigurationsRsp = {}
TGetConfigurationsRsp.__index = TGetConfigurationsRsp
TGetConfigurationsRsp.group = {}

local function TGetConfigurationsRsp_from_obj(obj)
    return setmetatable(obj, TGetConfigurationsRsp)
end

function TGetConfigurationsRsp.new(Configurations)
    return TGetConfigurationsRsp_from_obj({Configurations = Configurations})
end
---@param obj ObservabilityServiceMetrics.GetConfigurationsRsp
function TGetConfigurationsRsp:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TGetConfigurationsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigurationsRsp.group)
end

TGetConfigurationsRsp.from_obj = TGetConfigurationsRsp_from_obj

TGetConfigurationsRsp.proto_property = {'Configurations'}

TGetConfigurationsRsp.default = {ObservabilityServiceMetrics.ConfigData.default}

TGetConfigurationsRsp.struct = {
    {name = 'Configurations', is_array = false, struct = ObservabilityServiceMetrics.ConfigData.struct}
}

function TGetConfigurationsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ObservabilityServiceMetrics.ConfigData.new(self.Configurations):validate(prefix, errs, need_convert)

    TGetConfigurationsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigurationsRsp.proto_property, errs, need_convert)
    return self
end

function TGetConfigurationsRsp:unpack(_)
    return self.Configurations
end

ObservabilityServiceMetrics.GetConfigurationsRsp = TGetConfigurationsRsp

ObservabilityServiceMetrics.interface = mdb.register_interface('bmc.kepler.ObservabilityService.Metrics',
    {SupportedMetrics = {'as', {}, true, nil, false}}, {
        GetConfigurations = {'a{ss}', 'a{ss}', TGetConfigurationsReq, TGetConfigurationsRsp},
        SetConfigurations = {'a{ss}a{ss}', '', TSetConfigurationsReq, TSetConfigurationsRsp}
    }, {})

return ObservabilityServiceMetrics
