-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-12
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Assembly = {}

---@class Assembly.FQDN
---@field FQDN string
local TFQDN = {}
TFQDN.__index = TFQDN
TFQDN.group = {}

local function TFQDN_from_obj(obj)
    return setmetatable(obj, TFQDN)
end

function TFQDN.new(FQDN)
    return TFQDN_from_obj({FQDN = FQDN})
end
---@param obj Assembly.FQDN
function TFQDN:init_from_obj(obj)
    self.FQDN = obj.FQDN
end

function TFQDN:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFQDN.group)
end

TFQDN.from_obj = TFQDN_from_obj

TFQDN.proto_property = {'FQDN'}

TFQDN.default = {''}

TFQDN.struct = {{name = 'FQDN', is_array = false, struct = nil}}

function TFQDN:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FQDN', self.FQDN, 'string', false, errs, need_convert)

    TFQDN:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFQDN.proto_property, errs, need_convert)
    return self
end

function TFQDN:unpack(_)
    return self.FQDN
end

Assembly.FQDN = TFQDN

---@class Assembly.UUID
---@field UUID string
local TUUID = {}
TUUID.__index = TUUID
TUUID.group = {}

local function TUUID_from_obj(obj)
    return setmetatable(obj, TUUID)
end

function TUUID.new(UUID)
    return TUUID_from_obj({UUID = UUID})
end
---@param obj Assembly.UUID
function TUUID:init_from_obj(obj)
    self.UUID = obj.UUID
end

function TUUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUUID.group)
end

TUUID.from_obj = TUUID_from_obj

TUUID.proto_property = {'UUID'}

TUUID.default = {''}

TUUID.struct = {{name = 'UUID', is_array = false, struct = nil}}

function TUUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UUID', self.UUID, 'string', true, errs, need_convert)

    TUUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUUID.proto_property, errs, need_convert)
    return self
end

function TUUID:unpack(_)
    return self.UUID
end

Assembly.UUID = TUUID

---@class Assembly.DomainName
---@field DomainName string
local TDomainName = {}
TDomainName.__index = TDomainName
TDomainName.group = {}

local function TDomainName_from_obj(obj)
    return setmetatable(obj, TDomainName)
end

function TDomainName.new(DomainName)
    return TDomainName_from_obj({DomainName = DomainName})
end
---@param obj Assembly.DomainName
function TDomainName:init_from_obj(obj)
    self.DomainName = obj.DomainName
end

function TDomainName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDomainName.group)
end

TDomainName.from_obj = TDomainName_from_obj

TDomainName.proto_property = {'DomainName'}

TDomainName.default = {''}

TDomainName.struct = {{name = 'DomainName', is_array = false, struct = nil}}

function TDomainName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DomainName', self.DomainName, 'string', false, errs, need_convert)

    TDomainName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDomainName.proto_property, errs, need_convert)
    return self
end

function TDomainName:unpack(_)
    return self.DomainName
end

Assembly.DomainName = TDomainName

---@class Assembly.SystemGUID
---@field SystemGUID string
local TSystemGUID = {}
TSystemGUID.__index = TSystemGUID
TSystemGUID.group = {}

local function TSystemGUID_from_obj(obj)
    return setmetatable(obj, TSystemGUID)
end

function TSystemGUID.new(SystemGUID)
    return TSystemGUID_from_obj({SystemGUID = SystemGUID})
end
---@param obj Assembly.SystemGUID
function TSystemGUID:init_from_obj(obj)
    self.SystemGUID = obj.SystemGUID
end

function TSystemGUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemGUID.group)
end

TSystemGUID.from_obj = TSystemGUID_from_obj

TSystemGUID.proto_property = {'SystemGUID'}

TSystemGUID.default = {''}

TSystemGUID.struct = {{name = 'SystemGUID', is_array = false, struct = nil}}

function TSystemGUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemGUID', self.SystemGUID, 'string', false, errs, need_convert)

    TSystemGUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemGUID.proto_property, errs, need_convert)
    return self
end

function TSystemGUID:unpack(_)
    return self.SystemGUID
end

Assembly.SystemGUID = TSystemGUID

---@class Assembly.HostName
---@field HostName string
local THostName = {}
THostName.__index = THostName
THostName.group = {}

local function THostName_from_obj(obj)
    return setmetatable(obj, THostName)
end

function THostName.new(HostName)
    return THostName_from_obj({HostName = HostName})
end
---@param obj Assembly.HostName
function THostName:init_from_obj(obj)
    self.HostName = obj.HostName
end

function THostName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostName.group)
end

THostName.from_obj = THostName_from_obj

THostName.proto_property = {'HostName'}

THostName.default = {''}

THostName.struct = {{name = 'HostName', is_array = false, struct = nil}}

function THostName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostName', self.HostName, 'string', false, errs, need_convert)

    THostName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostName.proto_property, errs, need_convert)
    return self
end

function THostName:unpack(_)
    return self.HostName
end

Assembly.HostName = THostName

Assembly.interface = mdb.register_interface('bmc.kepler.Assembly', {
    HostName = {'s', nil, false, nil, false},
    SystemGUID = {'s', nil, false, nil, false},
    DomainName = {'s', nil, false, nil, false},
    UUID = {'s', {}, true, nil, false},
    FQDN = {'s', {}, false, nil, false}
}, {}, {})

return Assembly
